/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.qubership.profiler.dump.FilesEnumeration;
import org.qubership.profiler.dump.IDataInputStreamEx;
import org.qubership.profiler.timeout.ReadInterruptedException;
import org.qubership.profiler.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInputStreamEx
extends FilterInputStream
implements IDataInputStreamEx {
    static final NumberFormat fileIndexFormat = NumberFormat.getIntegerInstance();
    private static final Logger log;
    private int position = 0;
    private final Long contentLength;
    private char[] charBuffer = new char[8];
    private byte[] byteBuffer = new byte[8];

    public DataInputStreamEx(InputStream in) {
        this(in, null);
    }

    public DataInputStreamEx(InputStream in, Long contentLength) {
        super(in);
        this.contentLength = contentLength;
    }

    @Override
    public String readString() throws IOException {
        return this.readString(0x6400000);
    }

    public String readString(int maxLength) throws IOException {
        int length = this.readVarInt();
        if (length > maxLength) {
            throw new IOException("Expecting string of max length " + maxLength + ", got " + length + " chars; position = " + this.position);
        }
        char[] x = new char[length];
        for (int i = 0; i < length; ++i) {
            x[i] = this.readChar();
        }
        return new String(x);
    }

    public int readString(Writer out, int maxLength) throws IOException {
        int length = this.readVarInt();
        if (length < maxLength) {
            maxLength = length;
        }
        if (length == 0) {
            return 0;
        }
        for (int i = 0; i < maxLength; ++i) {
            out.write(this.readChar());
        }
        if (length > maxLength) {
            this.skipBytes((maxLength - length) * 2);
        }
        return length;
    }

    public char readChar() throws IOException {
        int c2;
        int c1 = this.read();
        if ((c1 | (c2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)(c1 << 8 | c2);
    }

    public short readShort() throws IOException {
        int c2;
        int c1 = this.read();
        if ((c1 | (c2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)(c1 << 8 | c2);
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public long readLong() throws IOException {
        byte[] buffer = this.byteBuffer;
        this.readFully(buffer, 0, 8);
        return ((long)buffer[0] << 56) + ((long)(buffer[1] & 0xFF) << 48) + ((long)(buffer[2] & 0xFF) << 40) + ((long)(buffer[3] & 0xFF) << 32) + ((long)(buffer[4] & 0xFF) << 24) + (long)((buffer[5] & 0xFF) << 16) + (long)((buffer[6] & 0xFF) << 8) + (long)(buffer[7] & 0xFF);
    }

    public void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    public void readFully(byte[] buffer, int pos, int len) throws IOException {
        while (len > 0) {
            int bytesRead = this.read(buffer, pos, len);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            pos += bytesRead;
            len -= bytesRead;
        }
    }

    @Override
    public int readVarInt() throws IOException {
        int res = this.read();
        if (res == -1) {
            throw new EOFException();
        }
        if ((res & 0x80) == 0) {
            return res;
        }
        res &= 0xFFFFFF7F;
        int x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        if (((res |= x << 7) & 0x4000) == 0) {
            return res;
        }
        res &= 0xFFFFBFFF;
        x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        if (((res |= x << 14) & 0x200000) == 0) {
            return res;
        }
        res &= 0xFFDFFFFF;
        x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        if (((res |= x << 21) & 0x10000000) == 0) {
            return res;
        }
        res &= 0xEFFFFFFF;
        x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        return res |= x << 28;
    }

    public long readVarLong() throws IOException {
        int res = this.read();
        if (res == -1) {
            throw new EOFException();
        }
        if ((res & 0x80) == 0) {
            return res;
        }
        res &= 0xFFFFFF7F;
        int x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        if (((res |= x << 7) & 0x4000) == 0) {
            return res;
        }
        res &= 0xFFFFBFFF;
        x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        if (((res |= x << 14) & 0x200000) == 0) {
            return res;
        }
        res &= 0xFFDFFFFF;
        x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        if (((res |= x << 21) & 0x10000000) == 0) {
            return res;
        }
        res &= 0xEFFFFFFF;
        x = this.read();
        if (x == -1) {
            throw new EOFException();
        }
        if ((x & 0x80) == 0) {
            return (long)x << 28 | (long)res;
        }
        long resLong = (long)(x & 0x7F) << 28 | (long)res;
        return (long)this.readVarInt() << 35 | resLong;
    }

    public final int readVarIntZigZag() throws IOException {
        int res = this.readVarInt();
        return res >>> 1 ^ -(res & 1);
    }

    public final long readVarLongZigZag() throws IOException {
        long res = this.readVarLong();
        return res >>> 1 ^ -(res & 1L);
    }

    @Override
    public int position() {
        return this.position;
    }

    private void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new ReadInterruptedException();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkInterrupted();
        long bytesRead = super.skip(n);
        this.position = (int)((long)this.position + bytesRead);
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        this.checkInterrupted();
        int i = super.read();
        ++this.position;
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkInterrupted();
        int bytesRead = super.read(b);
        this.position += bytesRead;
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkInterrupted();
        int bytesRead = super.read(b, off, len);
        this.position += bytesRead;
        return bytesRead;
    }

    public void skipBytes(int bytes) throws IOException {
        while (bytes > 0) {
            long skipped = this.skip(bytes);
            if (skipped == 0L) {
                throw new EOFException();
            }
            bytes = (int)((long)bytes - skipped);
        }
    }

    @Override
    public void skipString() throws IOException {
        int length = this.readVarInt();
        this.skipBytes(length * 2);
    }

    public static InputStream openInputStream(File file) throws IOException {
        boolean isGzip = file.getName().endsWith(".gz");
        try {
            return new BufferedInputStream(new GZIPInputStream((InputStream)new FileInputStream(file.getAbsolutePath() + (isGzip ? "" : ".gz")), 131072), 131072);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String fileName = file.getAbsolutePath();
            if (isGzip) {
                fileName = fileName.substring(0, fileName.length() - 2);
            }
            return new BufferedInputStream(new FileInputStream(fileName), 131072);
        }
    }

    public Long contentLength() {
        return this.contentLength;
    }

    private static File attemptGZExt(File file) {
        if (file.exists()) {
            return file;
        }
        String name = file.getName();
        name = name.endsWith(".gz") ? name.substring(0, name.length() - 3) : name + ".gz";
        File otherFile = new File(file.getParent(), name);
        return otherFile.exists() ? otherFile : file;
    }

    public static FilesEnumeration openDataInputStreams(List<File> files) throws IOException {
        ArrayList<File> correctedGzExt = new ArrayList<File>(files.size());
        for (File file : files) {
            file = DataInputStreamEx.attemptGZExt(file);
            correctedGzExt.add(file);
        }
        return new FilesEnumeration(correctedGzExt.iterator());
    }

    public static DataInputStreamEx openDataInputStream(File file) throws IOException {
        if (!(file = DataInputStreamEx.attemptGZExt(file)).exists()) {
            log.warn("File " + file.getAbsolutePath() + " does not exist. Returning null output stream");
            return null;
        }
        FilesEnumeration fen = DataInputStreamEx.openDataInputStreams(Collections.singletonList(file));
        InputStream fin = fen.nextElement();
        return new DataInputStreamEx(fin, fen.currentFileLenght());
    }

    public static synchronized DataInputStreamEx openDataInputStreamAllSequences(File root, String name) throws IOException {
        return new DataInputStreamEx(new SequenceInputStream(DataInputStreamEx.enumerateInputStreams(root, name)));
    }

    public static synchronized FilesEnumeration enumerateInputStreams(File root, String name) throws IOException {
        File logsRoot = new File(root, name);
        if (!logsRoot.exists() || !logsRoot.isDirectory()) {
            throw new RuntimeException("Failed to read logs from directory " + logsRoot.getCanonicalPath());
        }
        File[] files = logsRoot.listFiles();
        if (files == null || files.length == 0) {
            throw new RuntimeException("Failed to find any files in " + root.getCanonicalPath());
        }
        ArrayList<File> toLoad = new ArrayList<File>(files.length);
        for (File f : files) {
            String fileName;
            if (f.isDirectory() || ".".equals(fileName = f.getName()) || "..".equals(fileName)) continue;
            toLoad.add(f);
        }
        Collections.sort(toLoad, new Comparator<File>(){

            @Override
            public int compare(File file, File t1) {
                return file.getName().compareTo(t1.getName());
            }
        });
        return DataInputStreamEx.openDataInputStreams(toLoad);
    }

    public static synchronized DataInputStreamEx openDataInputStream(File root, String name, int index) throws IOException {
        return DataInputStreamEx.openDataInputStream(new File(root, name + File.separatorChar + fileIndexFormat.format(index)));
    }

    public static DataInputStreamEx reopenDataInputStream(DataInputStreamEx prev, File root, String name, int index) throws IOException {
        if (prev != null) {
            IOHelper.close(prev);
        }
        return DataInputStreamEx.openDataInputStream(root, name, index);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            super.close();
        }
    }

    static {
        fileIndexFormat.setGroupingUsed(false);
        fileIndexFormat.setMinimumIntegerDigits(6);
        log = LoggerFactory.getLogger(DataInputStreamEx.class);
    }
}

