/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.qubership.profiler.dump.DumpFile;
import org.qubership.profiler.dump.FileDeleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpRoot {
    private static final Logger log = LoggerFactory.getLogger(DumpRoot.class);
    private String path;
    private String name;
    private AtomicLong sizeInBytes = new AtomicLong();
    private final Queue<DumpFile> lowPriorityFiles = new LinkedList<DumpFile>();
    private final Queue<DumpFile> highPriorityFiles = new LinkedList<DumpFile>();
    private final Map<String, List<DumpFile>> filesWithDependencies = new HashMap<String, List<DumpFile>>();

    public DumpRoot(String path) {
        if (path == null) {
            throw new NullPointerException("Parameter path should not be null");
        }
        this.path = path;
        this.name = new File(path).getName();
    }

    public void registerFile(DumpFile file) throws IllegalArgumentException {
        if (!this.name.equals(file.getDumpRootName())) {
            throw new IllegalArgumentException(String.format("File %s must not be registered in %s", file, this));
        }
        if (file.getDependentFile() != null) {
            this.addFileWithDependency(file);
        } else {
            this.addToQueue(file);
            String relativePath = this.getRelativePath(file.getPath());
            List<DumpFile> dependsOnFiles = this.filesWithDependencies.get(relativePath);
            if (dependsOnFiles != null) {
                for (DumpFile dependsOnFile : dependsOnFiles) {
                    dependsOnFile.setDependentFile(null);
                    this.addToQueue(dependsOnFile);
                }
                this.filesWithDependencies.remove(relativePath);
            }
        }
        this.sizeInBytes.getAndAdd(file.getSize());
    }

    private void addToQueue(DumpFile file) {
        Queue<DumpFile> queue = this.getProperQueue(file);
        queue.add(file);
    }

    private void addFileWithDependency(DumpFile file) {
        String dependentFileRelativePath = this.getRelativePath(file.getDependentFile().getPath());
        List<DumpFile> dumpFiles = this.filesWithDependencies.get(dependentFileRelativePath);
        if (dumpFiles == null) {
            dumpFiles = new LinkedList<DumpFile>();
            this.filesWithDependencies.put(dependentFileRelativePath, dumpFiles);
        }
        dumpFiles.add(file);
    }

    private boolean removeFileWithDependency(DumpFile file) {
        String dependentFileRelativePath = this.getRelativePath(file.getDependentFile().getPath());
        List<DumpFile> dumpFiles = this.filesWithDependencies.get(dependentFileRelativePath);
        if (dumpFiles == null) {
            return false;
        }
        boolean success = dumpFiles.remove(file);
        if (dumpFiles.isEmpty()) {
            this.filesWithDependencies.remove(dependentFileRelativePath);
        }
        return success;
    }

    private String getRelativePath(String path) {
        return path.substring(this.path.length() + 1);
    }

    public DumpFile getFirstFile() {
        if (!this.lowPriorityFiles.isEmpty()) {
            return this.lowPriorityFiles.peek();
        }
        if (!this.highPriorityFiles.isEmpty()) {
            return this.highPriorityFiles.peek();
        }
        if (!this.filesWithDependencies.isEmpty()) {
            return this.filesWithDependencies.values().iterator().next().iterator().next();
        }
        return null;
    }

    public boolean contains(DumpFile file) {
        if (file.getDependentFile() != null) {
            for (List<DumpFile> files : this.filesWithDependencies.values()) {
                if (!files.contains(file)) continue;
                return true;
            }
            return false;
        }
        Queue<DumpFile> queue = this.getProperQueue(file);
        return queue.contains(file);
    }

    public boolean isEmpty() {
        return this.lowPriorityFiles.isEmpty() && this.highPriorityFiles.isEmpty() && this.filesWithDependencies.isEmpty();
    }

    public long getSizeInBytes() {
        return this.sizeInBytes.get();
    }

    public Collection<DumpFile> deleteFile(DumpFile file, FileDeleter fileDeleter) {
        List<DumpFile> result;
        boolean success;
        if (file.getDependentFile() != null) {
            success = this.removeFileWithDependency(file);
        } else {
            Queue<DumpFile> queue = this.getProperQueue(file);
            success = queue.remove(file);
        }
        if (!success) {
            log.warn("Remove wrong dump file {} from DumpRoot {}", (Object)file, (Object)this);
            return Collections.EMPTY_LIST;
        }
        this.deleteFile(fileDeleter, file);
        if (this.lowPriorityFiles.isEmpty()) {
            log.info("There are no 'trace'/'calls'/'xml' files in dump root {}. Delete all files", (Object)this);
            result = new ArrayList<DumpFile>(this.highPriorityFiles);
            for (List<DumpFile> files : this.filesWithDependencies.values()) {
                result.addAll(files);
            }
            result.add(file);
            this.erase(fileDeleter);
        } else {
            result = Collections.singletonList(file);
        }
        if (this.isEmpty()) {
            fileDeleter.deleteRecursively(this.path);
        }
        return result;
    }

    public boolean erase(FileDeleter fileDeleter) {
        log.info("Erasing dump root {}", (Object)this);
        this.lowPriorityFiles.clear();
        this.highPriorityFiles.clear();
        this.filesWithDependencies.clear();
        return fileDeleter.deleteRecursively(this.path);
    }

    private Queue<DumpFile> getProperQueue(DumpFile file) {
        String dirName = file.getParentDirName();
        for (String removableDir : DumpFile.REMOVABLE_DIRS) {
            if (!dirName.startsWith(removableDir)) continue;
            return this.lowPriorityFiles;
        }
        return this.highPriorityFiles;
    }

    private boolean deleteFile(FileDeleter fileDeleter, DumpFile file) {
        this.sizeInBytes.getAndAdd(-file.getSize());
        return fileDeleter.deleteFile(file);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DumpRoot{name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", size=" + this.getSizeInBytes() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DumpRoot dumpRoot = (DumpRoot)o;
        return this.path.equals(dumpRoot.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

