/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.File;
import org.qubership.profiler.dump.DumpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDeleter {
    private static final Logger log = LoggerFactory.getLogger(FileDeleter.class);
    private static final int MAX_DOWN_HIERARCHY_LEVEL = 3;
    private static final int MAX_UP_HIERARCHY_LEVEL = 3;

    public boolean deleteFile(DumpFile dumpFile) {
        log.info("Delete file {}", (Object)dumpFile);
        return this.deleteFile("file", new File(dumpFile.getPath()));
    }

    public boolean deleteRecursively(String path) {
        File dirFile = new File(path);
        if (!this.deleteDir(dirFile, 1)) {
            return false;
        }
        this.deleteParentIfEmpty(dirFile.getParentFile(), 1);
        return true;
    }

    private boolean deleteDir(File dir, int level) {
        if (dir.isFile()) {
            return this.deleteFile("file", dir);
        }
        if (level > 3) {
            log.warn("Skip deleting dir {}. Hierarchy limit {} exceeded.", (Object)dir, (Object)level);
            return false;
        }
        if (!dir.exists()) {
            log.warn("Directory {} does not exist", (Object)dir);
            return false;
        }
        if (!dir.isDirectory()) {
            log.warn("The path is expected to be a directory {}", (Object)dir);
            return false;
        }
        log.info("Removing directory {}", (Object)dir);
        File[] files = dir.listFiles();
        boolean childrenDeleted = true;
        if (files != null) {
            for (File file : files) {
                if (this.deleteDir(file, level + 1)) continue;
                childrenDeleted = false;
            }
        }
        return childrenDeleted && this.deleteFile("directory", dir);
    }

    private boolean deleteFile(String title, File dir) {
        if (!dir.exists()) {
            log.warn("{} does not exist: {}", (Object)title, (Object)dir);
            return false;
        }
        boolean outcome = dir.delete();
        if (outcome) {
            log.info("Removing {} {}", (Object)title, (Object)dir);
        } else {
            log.warn("Unable to remove {} {}", (Object)title, (Object)dir);
        }
        return outcome;
    }

    private boolean deleteParentIfEmpty(File parentFile, int level) {
        if (level > 3) {
            log.warn("Stop recursive deletion of empty dirs on dir {}. Max hierarchy level exceeded border value {}", (Object)parentFile, (Object)level);
            return false;
        }
        File[] files = parentFile.listFiles();
        if (files.length > 0) {
            log.info("Dir {} is not empty. Skip deleting", (Object)parentFile);
            return false;
        }
        boolean deleted = parentFile.delete();
        if (!deleted) {
            log.warn("Can't delete dir {}", (Object)parentFile);
            return false;
        }
        this.deleteParentIfEmpty(parentFile.getParentFile(), level + 1);
        return true;
    }
}

