/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.formatters.title;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.formatters.title.AbstractTitleFormatter;
import org.qubership.profiler.formatters.title.Function;
import org.qubership.profiler.formatters.title.ProfilerTitle;
import org.qubership.profiler.formatters.title.ProfilerTitleBuilder;
import org.qubership.profiler.formatters.title.TitleCommonTools;

public class QuartzJobTitleFormatter
extends AbstractTitleFormatter {
    private Set<String> SKIP_PARAMS = Collections.EMPTY_SET;

    @Override
    public ProfilerTitle formatTitle(String classMethod, Map<String, Integer> tagToIdMap, Object params, List<ParameterInfo> defaultListParams) {
        ProfilerTitleBuilder title = new ProfilerTitleBuilder();
        String jobType = TitleCommonTools.getParameter(tagToIdMap, params, "job.action.type");
        title.append(QuartzJobTitleFormatter.getJobTypeNameById(jobType));
        String jobName = TitleCommonTools.getParameter(tagToIdMap, params, "job.name");
        title.append(" ").appendHtml("<b>").append(jobName.isEmpty() ? "Name unknown" : jobName).appendHtml("</b>");
        TitleCommonTools.addParameter(title, tagToIdMap, params, " ", "job.id", new Function<Collection<String>, String>(){

            @Override
            public String apply(Collection<String> jobIDs) {
                return "(" + StringUtils.join(jobIDs, ",") + ")";
            }
        });
        if ("7020873015013388042".equals(jobType)) {
            String jobClass = TitleCommonTools.getParameter(tagToIdMap, params, "job.class");
            String jobMethod = TitleCommonTools.getParameter(tagToIdMap, params, "job.method");
            title.append(" (").append(QuartzJobTitleFormatter.getClassName(jobClass)).append(".").append(jobMethod).append(")");
        }
        TitleCommonTools.addGenericParams(title, tagToIdMap, params, defaultListParams, this.SKIP_PARAMS);
        return title;
    }

    @Override
    public ProfilerTitle formatCommonTitle(String classMethod, Map<String, Integer> tagToIdMap, Map<Integer, List<String>> params, Map<String, Object> formatContext) {
        ProfilerTitleBuilder title = new ProfilerTitleBuilder();
        String jobType = TitleCommonTools.getParameter(tagToIdMap, params, "job.action.type");
        title.append(QuartzJobTitleFormatter.getJobTypeNameById(jobType));
        String jobName = TitleCommonTools.getParameter(tagToIdMap, params, "job.name");
        title.append(" ").append(jobName.isEmpty() ? "Name unknown" : jobName);
        if ("7020873015013388042".equals(jobType)) {
            String jobClass = TitleCommonTools.getParameter(tagToIdMap, params, "job.class");
            String jobMethod = TitleCommonTools.getParameter(tagToIdMap, params, "job.method");
            title.append(" (").append(QuartzJobTitleFormatter.getClassName(jobClass)).append(".").append(jobMethod).append(")");
        }
        return title;
    }

    private static String getJobTypeNameById(String jobTypeId) {
        switch (jobTypeId) {
            case "7020873015013388039": {
                return "JMS quartz job";
            }
            case "7020873015013388040": {
                return "URL quartz job";
            }
            case "7020873015013388041": {
                return "EJB quartz job";
            }
            case "7020873015013388042": {
                return "Class quartz job";
            }
            case "7020873015013388043": {
                return "SOAP quartz job";
            }
        }
        if (jobTypeId.isEmpty()) {
            return "Quartz job";
        }
        return jobTypeId + " quartz job";
    }

    private static String getClassName(String fullClassName) {
        int dotIndex = fullClassName.lastIndexOf(46);
        return dotIndex == -1 ? fullClassName : fullClassName.substring(dotIndex + 1);
    }
}

