/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument;

import java.util.HashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.qubership.profiler.instrument.ProfileMethodAdapter;
import org.qubership.profiler.instrument.TypeUtils;
import org.qubership.profiler.util.MethodInstrumentationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileClassAdapter
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(ProfileClassAdapter.class);
    private final String className;
    private String sourceFileName;
    private final HashMap<String, MethodInstrumentationInfo> selectedRules;
    private final String jarName;
    private int classVersion;

    public ProfileClassAdapter(ClassVisitor cv, String className, HashMap<String, MethodInstrumentationInfo> selectedRules, String jarName) {
        super(589824, cv);
        this.className = className;
        this.selectedRules = selectedRules;
        this.jarName = jarName;
        log.debug("Transforming class {}, {} rules match this class name", (Object)className, (Object)selectedRules.size());
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classVersion = version & 0xFFFF;
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.sourceFileName = source;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodInstrumentationInfo info = this.selectedRules.get(name + desc);
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (info != null) {
            String fullName = TypeUtils.getMethodFullname(name, desc, this.className, this.sourceFileName, info.firstLineNumber, this.jarName);
            mv = new ProfileMethodAdapter(mv, access, this.className, name, desc, fullName, info.rule, this.classVersion);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        for (MethodInstrumentationInfo info : this.selectedRules.values()) {
            info.rule.onClassEnd(this, this.className);
        }
        super.visitEnd();
    }

    public int getClassVersion() {
        return this.classVersion;
    }
}

