/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeUtils {
    public static final Logger log = LoggerFactory.getLogger(TypeUtils.class);
    private static final Pattern MVN_URL = Pattern.compile("(?:wrap:)?mvn:([^/]++)/([^/]++)/([^/$]++)");

    public static String getFullJarName(ProtectionDomain pd) {
        if (pd == null) {
            return null;
        }
        URI uri = null;
        try {
            File file;
            CodeSource source = pd.getCodeSource();
            if (source == null) {
                return null;
            }
            URL location = source.getLocation();
            if (location == null) {
                return null;
            }
            String stringUri = null;
            try {
                uri = location.toURI();
                stringUri = uri.toString();
            }
            catch (URISyntaxException e) {
                stringUri = location.toString();
            }
            if (stringUri == null) {
                return null;
            }
            if (stringUri.startsWith("jar:file:")) {
                int endIdx = stringUri.endsWith("!/") ? stringUri.length() - 2 : stringUri.length();
                file = new File(stringUri.substring("jar:file:".length(), endIdx));
            } else if (stringUri.startsWith("file:")) {
                file = new File(stringUri.substring("file:".length()));
            } else if (stringUri.startsWith("vfs:")) {
                file = new File(stringUri.substring("vfs:".length()));
            } else {
                if (stringUri.startsWith("mvn:")) {
                    return TypeUtils.resolveMvnJar(stringUri);
                }
                if (uri == null) {
                    return "unknown";
                }
                file = new File(uri);
            }
            String path = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (file.isDirectory()) {
                path = path + '/';
            }
            return path;
        }
        catch (Exception t) {
            log.info("Unable to get jar name for protection domain " + pd + ", uri=" + uri, t);
            return null;
        }
    }

    public static String resolveMvnJar(String stringUri) {
        Matcher matcher = MVN_URL.matcher(stringUri);
        if (matcher.lookingAt()) {
            String group = matcher.group(1);
            String artifact = matcher.group(2);
            String version = matcher.group(3);
            return "system" + File.separatorChar + group.replace('.', File.separatorChar) + File.separatorChar + artifact + File.separatorChar + version + File.separatorChar + artifact + '-' + version + ".jar";
        }
        return stringUri;
    }

    public static String getJarName(ProtectionDomain pd) {
        String path = TypeUtils.getFullJarName(pd);
        if (path == null) {
            return null;
        }
        try {
            int next;
            int idx = path.lastIndexOf(47);
            for (int i = 0; i < 2 && idx > 0 && (next = path.lastIndexOf(47, idx - 1)) != -1; ++i) {
                idx = next;
            }
            return path.substring(Math.max(idx + 1, 0));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getMethodFullname(String methodName, String desc, String className, String sourceFileName, int firstLineNumber, String jarName) {
        StringBuilder sb = new StringBuilder(desc.length() + methodName.length() + className.length() + (jarName != null ? jarName.length() : 0) + 25);
        sb.append(Type.getReturnType(desc).getClassName()).append(' ');
        if (className != null) {
            sb.append(className.replace('/', '.')).append('.');
        }
        sb.append(methodName).append('(');
        for (Type type : Type.getArgumentTypes(desc)) {
            sb.append(type.getClassName()).append(',');
        }
        int lastIdx = sb.length() - 1;
        if (sb.charAt(lastIdx) != ',') {
            sb.append(')');
        } else {
            sb.setCharAt(lastIdx, ')');
        }
        sb.append(" (");
        sb.append(sourceFileName);
        sb.append(':');
        sb.append(firstLineNumber);
        sb.append(')');
        if (jarName != null) {
            sb.append(" [");
            sb.append(jarName);
            sb.append(']');
        }
        return sb.toString();
    }

    public static Object typeToFrameType(Type type) {
        switch (type.getSort()) {
            case 9: {
                return type.toString();
            }
            case 10: {
                return type.getInternalName();
            }
            case 8: {
                return Opcodes.DOUBLE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Opcodes.INTEGER;
            }
            case 6: {
                return Opcodes.FLOAT;
            }
            case 7: {
                return Opcodes.LONG;
            }
        }
        return Opcodes.TOP;
    }

    public static void pushDefaultValue(GeneratorAdapter ga, Type type) {
        switch (type.getSort()) {
            case 1: {
                ga.push(false);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ga.push(0);
                break;
            }
            case 7: {
                ga.push(0L);
                break;
            }
            case 6: {
                ga.push(0.0f);
                break;
            }
            case 8: {
                ga.push(0.0);
                break;
            }
            case 0: {
                break;
            }
            default: {
                ga.push((Type)null);
            }
        }
    }
}

