/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.custom.util;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.qubership.profiler.agent.DefaultMethodImplInfo;
import org.qubership.profiler.instrument.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMethodAdder
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(DefaultMethodAdder.class);
    private final DefaultMethodImplInfo methodInfo;
    private boolean methodAlreadyExists;
    private String superName;
    private boolean isInterface;

    public DefaultMethodAdder(ClassVisitor cv, DefaultMethodImplInfo methodInfo) {
        super(589824, cv);
        this.methodInfo = methodInfo;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superName = superName;
        this.isInterface = (access & 0x200) > 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.methodInfo.methodName.equals(name) && desc.equals(this.methodInfo.methodDescr)) {
            this.methodAlreadyExists = true;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (!this.methodAlreadyExists) {
            Type[] argumentTypes;
            log.info("Adding method {}{} to class {}", this.methodInfo.methodName, this.methodInfo.methodDescr, this.methodInfo.className);
            MethodVisitor mv = this.visitMethod(this.methodInfo.access, this.methodInfo.methodName, this.methodInfo.methodDescr, null, null);
            GeneratorAdapter ga = new GeneratorAdapter(mv, this.methodInfo.access, this.methodInfo.methodName, this.methodInfo.methodDescr);
            mv.visitCode();
            if (this.methodInfo.skipSuper) {
                Type returnType = Type.getReturnType(this.methodInfo.methodDescr);
                TypeUtils.pushDefaultValue(ga, returnType);
            } else {
                ga.loadThis();
                ga.loadArgs();
                mv.visitMethodInsn(183, this.superName, this.methodInfo.methodName, this.methodInfo.methodDescr, this.isInterface);
            }
            ga.returnValue();
            int argsLength = 1;
            for (Type argumentType : argumentTypes = Type.getArgumentTypes(this.methodInfo.methodDescr)) {
                argsLength += argumentType.getSize();
            }
            ga.visitMaxs(argsLength, argsLength);
            mv.visitEnd();
        }
        super.visitEnd();
    }
}

