/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.custom.util;

import org.qubership.profiler.agent.Configuration_01;
import org.qubership.profiler.instrument.ProfileMethodAdapter;
import org.qubership.profiler.instrument.custom.MethodInstrumenter;
import org.qubership.profiler.instrument.custom.util.ExecuteMethod;
import org.qubership.profiler.instrument.custom.util.TryCatchData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ExecuteMethodAfter
extends ExecuteMethod {
    private static final Logger log = LoggerFactory.getLogger(ExecuteMethodAfter.class);
    private boolean catchesException = false;

    @Override
    public MethodInstrumenter init(Element e, Configuration_01 configuration) {
        this.catchesException = e.hasAttribute("exception-only") || e.hasAttribute("exception");
        return super.init(e, configuration);
    }

    @Override
    public void declareLocals(ProfileMethodAdapter ma) {
        super.declareLocals(ma);
        if (ma.getReturnType().getSort() != 0) {
            ma.declareResultVariable();
        }
    }

    @Override
    protected String parseMethodArgs(String methodName) {
        if (!this.catchesException) {
            return super.parseMethodArgs(methodName);
        }
        int argStart = methodName.indexOf(40);
        String newMethodArg = methodName;
        if (argStart == -1) {
            newMethodArg = methodName + "(throwable)";
        } else if (methodName.indexOf("throwable", argStart) == -1) {
            newMethodArg = methodName.substring(0, methodName.length() - 1) + ",throwable)";
        }
        if (!methodName.equals(newMethodArg)) {
            log.debug("Please specify <<throwable>> argument position in execute-when. Automatically used {} instead of configured {}", (Object)newMethodArg, (Object)methodName);
        }
        return super.parseMethodArgs(newMethodArg);
    }

    @Override
    public void onMethodExit(ProfileMethodAdapter ma) {
        super.onMethodExit(ma);
        int result = -1;
        if (ma.getReturnType().getSort() != 0) {
            result = ma.getResultVariableNumber();
            ma.storeLocal(result);
        }
        if (this.shouldAddPlainTryCatchBlocks(ma.getClassVersion())) {
            TryCatchData tryCatchData = this.appendTry(ma);
            this.appendCall(ma);
            this.appendCatch(ma, null, tryCatchData);
        } else {
            this.appendCall(ma);
        }
        if (result != -1) {
            ma.loadLocal(result);
        }
    }

    @Override
    public void onMethodException(ProfileMethodAdapter ma) {
        super.onMethodException(ma);
        if (this.shouldAddPlainTryCatchBlocks(ma.getClassVersion())) {
            TryCatchData tryCatchData = this.appendTry(ma);
            this.appendCall(ma);
            this.appendCatch(ma, null, tryCatchData);
        } else {
            this.appendCall(ma);
        }
    }
}

