/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.custom.util;

import org.objectweb.asm.Type;
import org.qubership.profiler.agent.Configuration_01;
import org.qubership.profiler.instrument.ProfileMethodAdapter;
import org.qubership.profiler.instrument.custom.MethodInstrumenter;
import org.qubership.profiler.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class LogParameter
extends MethodInstrumenter {
    private static final Logger log = LoggerFactory.getLogger(LogParameter.class);
    private String eventName;
    private int parameterIndex;
    private int savedParameterIndex;
    private Boolean earlyToString;

    @Override
    public LogParameter init(Element e, Configuration_01 configuration) {
        String content = XMLHelper.getTextContent(e);
        int parameter = -1;
        try {
            parameter = Integer.parseInt(content);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (parameter == -1) {
            parameter = 0;
            log.warn("Detected unparseable log-parameter record. log-parameter tag should contain an integer. Assuming the first one");
        }
        this.parameterIndex = parameter;
        String eventName = e.getAttribute("name");
        if (eventName.length() == 0) {
            eventName = "p" + parameter;
            log.warn("Event name is not specified, using {}", (Object)eventName);
        }
        this.eventName = eventName;
        String earlyToString = e.getAttribute("early-to-string");
        if (earlyToString.length() != 0) {
            this.earlyToString = Boolean.valueOf(earlyToString);
        }
        return this;
    }

    @Override
    public void declareLocals(ProfileMethodAdapter ma) {
        this.savedParameterIndex = ma.saveArg(this.parameterIndex);
    }

    @Override
    public void onMethodEnter(ProfileMethodAdapter ma) {
        Type[] argumentTypes = ma.getArgumentTypes();
        if (this.parameterIndex >= argumentTypes.length) {
            log.warn("Unable to log parameter {} as {} in method {} since method has only {} parameters", this.parameterIndex, this.eventName, ma.getMethodFullName(), argumentTypes.length);
            return;
        }
        log.debug("Logging parameter {} as {} in method {}", this.parameterIndex, this.eventName, ma.getMethodFullName());
        ma.loadLocal(this.savedParameterIndex);
        Type argumentType = argumentTypes[this.parameterIndex];
        ma.box(argumentType);
        ma.logEvent(this.eventName, argumentType, this.earlyToString == null ? false : this.earlyToString);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogParameter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogParameter that = (LogParameter)o;
        if (this.parameterIndex != that.parameterIndex) {
            return false;
        }
        if (this.eventName != null ? !this.eventName.equals(that.eventName) : that.eventName != null) {
            return false;
        }
        return !(this.earlyToString != null ? !this.earlyToString.equals(that.earlyToString) : that.earlyToString != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.eventName != null ? this.eventName.hashCode() : 0);
        result = 31 * result + this.parameterIndex;
        result = 31 * result + (this.earlyToString != null ? this.earlyToString.hashCode() : 0);
        return result;
    }
}

