/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.enhancement;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.qubership.profiler.instrument.enhancement.ClassInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInfoImpl
extends ClassInfo {
    private static final Logger log = LoggerFactory.getLogger(ClassInfoImpl.class);
    private Manifest jarManifest;

    @Override
    public String getJarAttribute(String name) {
        Manifest manifest = this.getJarManifest();
        if (manifest == null) {
            return "unknown";
        }
        return this.jarManifest.getMainAttributes().getValue(name);
    }

    @Override
    public String getJarSubAttribute(String entryName, String attrName) {
        Manifest manifest = this.getJarManifest();
        if (manifest == null) {
            return "unknown";
        }
        Attributes attr = manifest.getAttributes(entryName);
        if (attr == null) {
            return "unknown";
        }
        return attr.getValue(attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getJarManifest() {
        if (this.jarManifest != null) {
            return this.jarManifest;
        }
        String fullJarName = this.getJarName();
        if (fullJarName == null) {
            log.info("Unable to get attribute for class {} since jar name is not known for protection domain {}", (Object)this.getClassName(), (Object)this.getProtectionDomain());
            return null;
        }
        ZipFile jarFile = null;
        try {
            jarFile = fullJarName.contains("!/") ? ((JarURLConnection)new URL("jar:file:" + fullJarName + "!/").openConnection()).getJarFile() : new JarFile(fullJarName);
            this.jarManifest = ((JarFile)jarFile).getManifest();
        }
        catch (IOException e) {
            log.warn("Unable to open jar file {}", (Object)fullJarName);
            log.debug("Unable to open jar file", e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.jarManifest;
    }
}

