/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.enhancement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.agent.EnhancementRegistry;
import org.qubership.profiler.instrument.enhancement.FilteredEnhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancementRegistryImpl
implements EnhancementRegistry {
    public static final Logger log = LoggerFactory.getLogger(EnhancementRegistryImpl.class);
    Map<String, Object> enhancers = new HashMap<String, Object>();
    Map<String, Object> filtersByName = new HashMap<String, Object>();

    @Override
    public List getEnhancers(String className) {
        Object o = this.enhancers.get(className);
        if (o == null) {
            return Collections.EMPTY_LIST;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.singletonList(o);
    }

    @Override
    public void addEnhancer(String className, Object filteredEnhancer) {
        FilteredEnhancer enhancer = (FilteredEnhancer)filteredEnhancer;
        Object o = this.enhancers.get(className);
        if (o == null) {
            this.enhancers.put(className, enhancer);
            return;
        }
        if (o instanceof List) {
            List list = (List)o;
            if (list.contains(filteredEnhancer)) {
                if (log.isDebugEnabled()) {
                    log.debug("Attempt to put the same enhancer twice for the class {}", (Object)className, (Object)new Throwable());
                } else {
                    log.debug("Attempt to put the same enhancer twice for the class {}", (Object)className);
                }
                return;
            }
            list.add(filteredEnhancer);
            return;
        }
        if (o == filteredEnhancer) {
            if (log.isDebugEnabled()) {
                log.debug("Attempt to put the same enhancer twice for the class {}", (Object)className, (Object)new Throwable());
            } else {
                log.debug("Attempt to put the same enhancer twice for the class {}", (Object)className);
            }
            return;
        }
        ArrayList<FilteredEnhancer> list = new ArrayList<FilteredEnhancer>();
        list.add((FilteredEnhancer)o);
        list.add(enhancer);
        this.enhancers.put(className, list);
    }

    @Override
    public Object getFilter(String name) {
        return this.filtersByName.get(name);
    }

    @Override
    public void addFilter(String name, Object filter) {
        this.filtersByName.put(name, filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnhancementRegistryImpl that = (EnhancementRegistryImpl)o;
        return !(this.enhancers != null ? !this.enhancers.equals(that.enhancers) : that.enhancers != null);
    }

    public int hashCode() {
        return this.enhancers != null ? this.enhancers.hashCode() : 0;
    }
}

