/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.enhancement;

import java.util.Map;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.Configuration_01;
import org.qubership.profiler.agent.EnhancementRegistry;
import org.qubership.profiler.agent.EnhancerRegistryPlugin;
import org.qubership.profiler.configuration.ConfigStackElement;
import org.qubership.profiler.instrument.enhancement.ClassEnhancer;
import org.qubership.profiler.instrument.enhancement.ClassInfo;
import org.qubership.profiler.instrument.enhancement.FilteredEnhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EnhancerPlugin {
    public static final Logger log = LoggerFactory.getLogger(EnhancerPlugin.class);
    public final Map<String, ClassEnhancer> enhancersCollection;
    private ConfigStackElement stack;

    public EnhancerPlugin() {
        String name = this.getClass().getName() + "Enhancers";
        log.debug("Trying to find enhancer {}", (Object)name);
        Map enhancersCollection = null;
        try {
            Class<?> enhancerClass = Class.forName(name, true, this.getClass().getClassLoader());
            enhancersCollection = (Map)enhancerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.warn("Unable to find enhancers collection class {}", (Object)name, (Object)e);
        }
        catch (InstantiationException e) {
            log.warn("Unable to create enhancers collection {}", (Object)name, (Object)e);
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to create enhancers collection {}", (Object)name, (Object)e);
        }
        this.enhancersCollection = enhancersCollection;
        this.register();
    }

    private void register() {
        EnhancerRegistryPlugin registry = Bootstrap.getPlugin(EnhancerRegistryPlugin.class);
        if (registry == null) {
            log.warn("Unable to find EnhancerPluginRegistryImpl in the classpath. Will not be able to use {} enhancements", (Object)this);
            return;
        }
        registry.addEnhancerPlugin(this.getClass().getSimpleName().substring("EnhancerPlugin_".length()), this);
    }

    public void init(Element node, Configuration_01 conf) {
        if (this.enhancersCollection == null || this.enhancersCollection.isEmpty()) {
            log.debug("Enhancers collection is null or empty");
            return;
        }
        EnhancementRegistry er = conf.getEnhancementRegistry();
        for (Map.Entry<String, ClassEnhancer> entry : this.enhancersCollection.entrySet()) {
            er.addEnhancer(entry.getKey(), new FilteredEnhancer(this, entry.getValue()));
        }
    }

    public boolean accept(ClassInfo info) {
        return true;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass();
    }

    public void setStackTraceAtCreate(ConfigStackElement currentStack) {
        this.stack = currentStack;
    }

    public ConfigStackElement getStackTraceAtCreate() {
        return this.stack;
    }
}

