/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.io.Call;
import org.qubership.profiler.io.CallFilterer;
import org.qubership.profiler.io.CallListener;
import org.qubership.profiler.io.CallsFileHeader;
import org.qubership.profiler.io.ICallReader;
import org.qubership.profiler.io.SuspendLog;
import org.qubership.profiler.io.call.CallDataReader;
import org.qubership.profiler.io.call.CallDataReaderFactory;
import org.qubership.profiler.io.call.ReactorCallReader;
import org.qubership.profiler.timeout.ReadInterruptedException;

public abstract class CallReader
implements ICallReader {
    protected final CallFilterer cf;
    protected final CallListener callback;
    protected final Collection<Throwable> exceptions = new LinkedBlockingQueue<Throwable>();
    static final FileFilter CALLS_FILE_FINDER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".calls.log");
        }
    };
    protected long callBeginTime;
    protected long minCallBeginTime;
    protected long begin = Long.MIN_VALUE;
    protected long end = Long.MAX_VALUE;
    protected long beginSuspendLog = Long.MIN_VALUE;
    protected long endSuspendLog = Long.MAX_VALUE;
    protected CallDataReader callDataReader;
    protected ReactorCallReader reactorCallReader;

    @Override
    public Collection<Throwable> getExceptions() {
        return this.exceptions;
    }

    public CallReader(CallListener callback, CallFilterer cf) {
        this.callback = callback;
        this.cf = cf;
    }

    @Override
    public final void find() {
        this.innerFind();
    }

    protected abstract void innerFind();

    public static CallsFileHeader readStartTime(DataInputStreamEx calls) throws IOException {
        long time = calls.readLong();
        int fileFormat = 0;
        if ((int)(time >>> 32) == -66052) {
            fileFormat = (int)(time & 0xFFFFFFFFFFFFFFFFL);
            time = calls.readLong();
        }
        return new CallsFileHeader(fileFormat, time);
    }

    protected boolean findCallsInStream(DataInputStreamEx is, DataInputStreamEx reactorCalls, String callsStreamIndex, SuspendLog suspendLog, ArrayList<Call> result, BitSet requiredIds) {
        return this.findCallsInStream(is, reactorCalls, callsStreamIndex, suspendLog, result, requiredIds, Long.MAX_VALUE);
    }

    protected boolean findCallsInStream(DataInputStreamEx is, DataInputStreamEx reactorCalls, String callsStreamIndex, SuspendLog suspendLog, ArrayList<Call> result, BitSet requiredIds, long endScan) {
        try {
            CallDataReader reader;
            long time;
            DataInputStreamEx calls = is;
            DataInputStreamEx rCalls = reactorCalls;
            CallsFileHeader cfh = CallReader.readStartTime(is);
            int fileFormat = cfh.getFileFormat();
            this.callBeginTime = time = cfh.getStartTime();
            this.minCallBeginTime = Math.min(this.minCallBeginTime, time);
            boolean reactorCallsAvailable = rCalls != null;
            this.callDataReader = reader = CallDataReaderFactory.createReader(fileFormat);
            if (reactorCallsAvailable) {
                this.reactorCallReader = CallDataReaderFactory.createReactorReader(rCalls.readVarInt());
            }
            Call call = new Call();
            long begin = this.begin;
            long end = this.end;
            while (true) {
                if (Thread.interrupted()) {
                    throw new ReadInterruptedException();
                }
                reader.read(call, calls, requiredIds);
                if (reactorCallsAvailable) {
                    this.reactorCallReader.read(call, rCalls);
                }
                call.time = time += call.time;
                if (call.time + (long)call.duration < begin || call.time > end) {
                    if (call.time > endScan) {
                        return true;
                    }
                    reader.skipParams(call, calls);
                    continue;
                }
                call.setSuspendDuration(suspendLog.getSuspendDuration(call.time, call.time + (long)call.duration));
                reader.readParams(call, calls, requiredIds);
                call.callsStreamIndex = callsStreamIndex;
                result.add(call);
                call = new Call();
            }
        }
        catch (EOFException calls) {
        }
        catch (IOException e) {
            this.exceptions.add(e);
        }
        return false;
    }

    @Override
    public void setTimeFilterCondition(long begin, long end) {
        this.begin = begin;
        this.end = end;
        this.beginSuspendLog = begin - (long)(SUSPEND_LOG_READER_EXTRA_TIME * 60 * 1000);
        this.endSuspendLog = end + (long)(SUSPEND_LOG_READER_EXTRA_TIME * 60 * 1000);
    }

    public long getBegin() {
        return this.begin;
    }

    public long getEnd() {
        return this.end;
    }

    public String getRootReference() {
        return "unknown";
    }
}

