/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.io.Call;
import org.qubership.profiler.io.CallFilterer;
import org.qubership.profiler.io.CallListener;
import org.qubership.profiler.io.JSHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class CallToJS
implements CallListener {
    private static final Logger log = LoggerFactory.getLogger(CallToJS.class);
    protected final PrintWriter out;
    String prevDumpDir;
    BitSet prevIds = new BitSet();
    @Value(value="${org.qubership.profiler.DUMP_ROOT_LOCATION:#{null}}")
    private File rootFile;
    private CallFilterer cf;
    private Map<String, DeferredCalls> deferredCalls = new ConcurrentHashMap<String, DeferredCalls>();

    private CallToJS() {
        throw new RuntimeException("No-args not supported");
    }

    public CallToJS(PrintWriter out, CallFilterer cf) {
        this.out = out;
        this.cf = cf;
    }

    protected void printAdditionalRootReferenceDetails(String rootReference) throws IOException {
        Properties properties;
        block10: {
            properties = new Properties();
            if (this.rootFile == null) {
                log.warn("Cannot find root file of dump");
                return;
            }
            File metaInfFile = new File(this.rootFile.getPath() + "/" + rootReference + "/meta-inf.properties");
            if (metaInfFile.exists()) {
                try (FileInputStream fileInputStream = new FileInputStream(metaInfFile);){
                    properties.load(fileInputStream);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            log.debug("meta-inf.properties file does not exist.");
        }
        if (properties.isEmpty()) {
            return;
        }
        this.out.print(", \"");
        JSHelper.escapeJS(this.out, properties.getProperty("serviceName"));
        this.out.print("\", \"");
        JSHelper.escapeJS(this.out, properties.getProperty("namespace"));
        this.out.print("\"");
    }

    private void deferCalls(String rootReference, List<Call> toDefer, List<String> tags, Map<String, ParameterInfoDto> paramInfo, BitSet requredIds) {
        if (toDefer == null || toDefer.size() <= 0) {
            return;
        }
        if (!this.deferredCalls.containsKey(rootReference)) {
            this.deferredCalls.put(rootReference, new DeferredCalls(toDefer, tags, paramInfo, requredIds));
            return;
        }
        DeferredCalls dc = this.deferredCalls.get(rootReference);
        dc.calls.addAll(toDefer);
        if (dc.tags.size() < tags.size()) {
            dc.tags = tags;
        }
        dc.paramInfo.putAll(paramInfo);
        dc.requredIds.or(requredIds);
    }

    @Override
    public void processCalls(String rootReference, ArrayList<Call> calls, List<String> tags, Map<String, ParameterInfoDto> paramInfo, BitSet requredIds) {
        ArrayList<Call> toDefer = new ArrayList<Call>(calls.size());
        ArrayList<Call> toPrint = new ArrayList<Call>(calls.size());
        for (Call call : calls) {
            if (call.reactorChainId != null) {
                toDefer.add(call);
                continue;
            }
            toPrint.add(call);
        }
        this.deferCalls(rootReference, toDefer, tags, paramInfo, requredIds);
        this.printCalls(rootReference, toPrint, tags, paramInfo, requredIds);
    }

    @Override
    public void postProcess(String rootReference) {
        DeferredCalls dc = this.deferredCalls.get(rootReference);
        if (dc != null) {
            List<Call> combinedCalls = this.combineReactorCalls(dc.calls);
            this.printCalls(rootReference, combinedCalls, dc.tags, dc.paramInfo, dc.requredIds);
        }
    }

    private boolean acceptCall(Call call) {
        if (this.cf == null) {
            return true;
        }
        return this.cf.filter(call);
    }

    private List<Call> combineReactorCalls(List<Call> toGroup) {
        HashMap<String, ArrayList<Call>> collect = new HashMap<String, ArrayList<Call>>();
        for (Call call : toGroup) {
            if (call.reactorChainId == null) continue;
            ArrayList<Call> byChainId = (ArrayList<Call>)collect.get(call.reactorChainId);
            if (byChainId == null) {
                byChainId = new ArrayList<Call>();
                collect.put(call.reactorChainId, byChainId);
            }
            byChainId.add(call);
        }
        ArrayList<Call> result = new ArrayList<Call>(toGroup.size());
        for (Map.Entry entry : collect.entrySet()) {
            Call newCall = new Call();
            newCall.params = new HashMap<Integer, List<String>>();
            newCall.time = Long.MAX_VALUE;
            newCall.reactorChainId = (String)entry.getKey();
            long latestFinish = Long.MIN_VALUE;
            HashSet<String> affectedThreads = new HashSet<String>();
            HashSet<String> callsStreamIndexes = new HashSet<String>();
            for (Call call : (List)entry.getValue()) {
                latestFinish = Math.max(latestFinish, call.time + (long)call.duration);
                affectedThreads.add(call.threadName);
                if (!StringUtils.isBlank(call.callsStreamIndex)) {
                    callsStreamIndexes.add(call.callsStreamIndex);
                }
                newCall.time = Math.min(call.time, newCall.time);
                newCall.memoryUsed += call.memoryUsed;
                newCall.waitTime += call.waitTime;
                newCall.cpuTime += call.cpuTime;
                newCall.nonBlocking += call.nonBlocking;
                newCall.calls += call.calls;
                newCall.method = call.method;
                newCall.transactions += call.transactions;
                newCall.traceFileIndex = call.traceFileIndex;
                newCall.bufferOffset = call.bufferOffset;
                newCall.recordIndex = call.recordIndex;
                newCall.suspendDuration += call.suspendDuration;
                newCall.netRead += call.netRead;
                newCall.netWritten += call.netWritten;
                this.combineParams(call, newCall);
            }
            newCall.threadName = StringUtils.join(affectedThreads, "_");
            newCall.callsStreamIndex = StringUtils.join(callsStreamIndexes, "_");
            newCall.duration = (int)(latestFinish - newCall.time);
            result.add(newCall);
        }
        return result;
    }

    private void combineParams(Call call, Call newCall) {
        if (call.params == null) {
            return;
        }
        for (Map.Entry<Integer, List<String>> integerListEntry : call.params.entrySet()) {
            Integer key = integerListEntry.getKey();
            List<String> srcList = integerListEntry.getValue();
            if (srcList == null || srcList.size() == 0) {
                return;
            }
            List<String> theList = newCall.params.get(key);
            if (theList == null) {
                theList = new ArrayList<String>();
                newCall.params.put(key, theList);
            }
            theList.addAll(srcList);
        }
    }

    public void printCalls(String rootReference, List<Call> calls, List<String> tags, Map<String, ParameterInfoDto> paramInfo, BitSet requredIds) {
        try {
            if (calls.isEmpty()) {
                return;
            }
            boolean sameDir = rootReference.equals(this.prevDumpDir);
            if (!sameDir) {
                this.prevIds.clear();
                this.prevDumpDir = rootReference;
            }
            PrintWriter out = this.out;
            out.print("{ var f=CL.addFolder(\"");
            out.print(rootReference.replace('\\', '/'));
            out.print("\"");
            this.printAdditionalRootReferenceDetails(rootReference);
            out.println(");");
            out.println(" var t = f.tags;");
            int k = 0;
            int i = -1;
            while ((i = requredIds.nextSetBit(i + 1)) >= 0) {
                if (sameDir && this.prevIds.get(i)) continue;
                this.prevIds.set(i);
                String string = i < tags.size() ? tags.get(i) : "tag " + i;
                out.print("t.a(");
                out.print(i);
                out.print(",\"");
                JSHelper.escapeJS(out, string);
                out.print("\");");
                if (++k != 10) continue;
                out.println();
                k = 0;
            }
            if (!sameDir) {
                k = 0;
                for (ParameterInfoDto parameterInfoDto : paramInfo.values()) {
                    out.print("t.b(\"");
                    JSHelper.escapeJS(out, parameterInfoDto.name);
                    out.print("\",");
                    out.print(parameterInfoDto.list ? (char)'1' : '0');
                    out.print(',');
                    out.print(parameterInfoDto.order);
                    out.print(',');
                    out.print(parameterInfoDto.index ? (char)'1' : '0');
                    out.print(",\"");
                    if (parameterInfoDto.signatureFunction != null) {
                        JSHelper.escapeJS(out, parameterInfoDto.signatureFunction);
                    }
                    out.print("\");");
                    if (++k != 10) continue;
                    out.println();
                    k = 0;
                }
            }
            out.println("var q=f.id;");
            out.println("var w=[];");
            HashMap<String, Integer> threadIdx = new HashMap<String, Integer>(20);
            for (Call call : calls) {
                String threadName = call.threadName;
                if (threadName == null || threadIdx.containsKey(threadName)) continue;
                int threadId = threadIdx.size();
                threadIdx.put(threadName, threadId);
                out.print("w[");
                out.print(threadId);
                out.print("]=\"");
                JSHelper.escapeJS(out, threadName);
                out.println("\";");
            }
            out.println("CL.append([");
            boolean bl = false;
            for (Call call : calls) {
                boolean bl2;
                if (!this.acceptCall(call)) continue;
                if (bl2) {
                    out.print(',');
                } else {
                    bl2 = true;
                }
                this.printCall(call, threadIdx);
            }
            out.println("]);");
            out.println("}");
        }
        catch (Throwable t) {
            log.info("Unable to convert calls from {} to javascript", (Object)rootReference, (Object)t);
        }
    }

    private void printCall(Call call, Map<String, Integer> threadIdx) throws IOException {
        this.out.print("[");
        this.out.print(call.time - (long)call.queueWaitDuration);
        this.out.print(',');
        this.out.print(call.duration + call.queueWaitDuration);
        this.out.print(',');
        this.out.print(call.nonBlocking);
        this.out.print(',');
        this.out.print(call.cpuTime);
        this.out.print(',');
        this.out.print(call.queueWaitDuration);
        this.out.print(',');
        this.out.print(call.suspendDuration);
        this.out.print(',');
        this.out.print(call.calls);
        this.out.print(",q,");
        String rowId = call.reactorChainId == null ? "q+'_" + call.traceFileIndex + "_" + call.bufferOffset + "_" + call.recordIndex + "_" + call.reactorFileIndex + "_" + call.reactorBufferOffset + "'" : "'chain_'+q+'_" + call.reactorChainId + "_" + call.callsStreamIndex + "'";
        this.out.print(rowId);
        this.out.print(",");
        this.out.print(call.method);
        this.out.print(',');
        this.out.print(call.transactions);
        this.out.print(',');
        this.out.print(call.memoryUsed);
        this.out.print(',');
        this.out.print(call.logsGenerated);
        this.out.print(',');
        this.out.print(call.logsWritten);
        this.out.print(',');
        this.out.print(call.fileRead + call.fileWritten);
        this.out.print(',');
        this.out.print(call.fileWritten);
        this.out.print(',');
        this.out.print(call.netRead + call.netWritten);
        this.out.print(',');
        this.out.print(call.netWritten);
        if (call.params != null && !call.params.isEmpty()) {
            this.out.print(",{");
            boolean commaRequiredParams = false;
            if (call.threadName != null) {
                this.out.print("\"-5\":w[");
                this.out.print(threadIdx.get(call.threadName));
                this.out.print(']');
                commaRequiredParams = true;
            }
            for (Map.Entry<Integer, List<String>> param : call.params.entrySet()) {
                if (!commaRequiredParams) {
                    commaRequiredParams = true;
                } else {
                    this.out.print(',');
                }
                Integer id = param.getKey();
                if (id > 0) {
                    this.out.print(id);
                } else {
                    this.out.print('\"');
                    this.out.print(id);
                    this.out.print('\"');
                }
                List<String> value = param.getValue();
                int valueSize = value.size();
                this.out.print(':');
                if (valueSize > 1) {
                    this.out.print('[');
                }
                for (int i = 0; i < valueSize; ++i) {
                    if (i != 0) {
                        this.out.print(',');
                    }
                    this.out.print("\"");
                    JSHelper.escapeJS(this.out, value.get(i));
                    this.out.print("\"");
                }
                if (valueSize <= 1) continue;
                this.out.print(']');
            }
            this.out.print('}');
        }
        this.out.println("]");
    }

    private static class DeferredCalls {
        List<Call> calls;
        List<String> tags;
        Map<String, ParameterInfoDto> paramInfo;
        BitSet requredIds;

        public DeferredCalls(List<Call> calls, List<String> tags, Map<String, ParameterInfoDto> paramInfo, BitSet requredIds) {
            this.calls = calls;
            this.tags = tags;
            this.paramInfo = paramInfo;
            this.requredIds = requredIds;
        }
    }
}

