/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.qubership.profiler.io.InputStreamNoCloseAdapter;
import org.qubership.profiler.io.InputStreamProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWalker {
    public static final Logger log = LoggerFactory.getLogger(FileWalker.class);
    private final InputStreamProcessor out;

    public FileWalker(InputStreamProcessor out) {
        this.out = out;
    }

    public void walk(String root) throws IOException {
        File f;
        this.walkFileOrDirectory(f, (f = new File(root)).isDirectory() ? new HashSet() : Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean walkFileOrDirectory(File f, Set<String> processedFiles) throws IOException {
        String path = f.getAbsolutePath();
        if (f.isDirectory()) {
            log.info("Looking in directory {} for thread dumps", (Object)path);
        } else {
            log.info("Looking in file {} for thread dumps, file size is {}", (Object)path, (Object)f.length());
        }
        if (f.isDirectory()) {
            if (!processedFiles.add(path)) {
                log.info("Looks like directory {} is recursively included into itself", (Object)path);
                return true;
            }
            for (File file : f.listFiles()) {
                if (!this.walkFileOrDirectory(file, processedFiles)) break;
            }
            return true;
        }
        try (FileInputStream is = null;){
            is = new FileInputStream(f);
            boolean bl = this.walkFileOrArchive(f.getName(), is);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean walkFileOrArchive(String fileName, InputStream is) throws IOException {
        if (fileName.endsWith(".gz")) {
            log.info("Processing gzip archive {}", (Object)fileName);
            try (GZIPInputStream gzip = null;){
                gzip = new GZIPInputStream(new InputStreamNoCloseAdapter(is));
                boolean bl = this.walkFileOrArchive(fileName.substring(0, fileName.length() - 2), gzip);
                return bl;
            }
        }
        if (fileName.endsWith(".zip")) {
            log.info("Processing zip archive {}", (Object)fileName);
            try (ZipInputStream zis = null;){
                ZipEntry ze;
                zis = new ZipInputStream(new InputStreamNoCloseAdapter(is));
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.isDirectory() || ze.getSize() < 100L) continue;
                    log.info("Processing zip file {}, size {}", (Object)ze.getName(), (Object)ze.getSize());
                    if (this.walkFileOrArchive(ze.getName(), zis)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
        return this.out.process(is, fileName);
    }
}

