/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.qubership.profiler.analyzer.comparators.TotalSelfCount;
import org.qubership.profiler.io.Hotspot;
import org.qubership.profiler.io.HotspotTag;
import org.qubership.profiler.io.Pair;
import org.qubership.profiler.io.serializers.JsonSerializer;
import org.qubership.profiler.sax.values.ClobValue;
import org.qubership.profiler.sax.values.StringValue;

public class HotspotToJson
implements JsonSerializer<Hotspot> {
    private final Map<String, Integer> folder2id;
    private final int maxNestLevel;
    Hotspot rootNode;
    int level;
    int deepIdx;
    ArrayList<StringWriter> deep = new ArrayList();
    JsonFactory jsonFactory;

    public HotspotToJson(Map<String, Integer> folder2id) {
        this(folder2id, 100);
    }

    public HotspotToJson(Map<String, Integer> folder2id, int maxNestLevel) {
        this.folder2id = folder2id;
        this.maxNestLevel = maxNestLevel;
    }

    @Override
    public void serialize(Hotspot value, JsonGenerator gen) throws IOException {
        this.rootNode = value;
        this.walk(value, gen);
        this.rootNode = null;
        if (this.deep.isEmpty()) {
            return;
        }
        gen.writeRaw(';');
        int deepSize = this.deep.size();
        for (int i = 0; i < deepSize; ++i) {
            StringWriter stringWriter = this.deep.get(i);
            this.deep.set(i, null);
            gen.writeRaw(stringWriter.toString());
        }
    }

    protected JsonGenerator createSubSerializer(Writer out) throws IOException {
        if (this.jsonFactory == null) {
            this.jsonFactory = new JsonFactory();
        }
        return this.jsonFactory.createGenerator(out);
    }

    /*
     * WARNING - void declaration
     */
    private int walk(Hotspot out, JsonGenerator gen) throws IOException {
        int canCollapse = 0;
        gen.writeStartArray();
        gen.writeNumber(out.id);
        gen.writeNumber(out.totalTime);
        gen.writeNumber(out.totalTime - out.childTime);
        gen.writeNumber(out.suspensionTime + out.childSuspensionTime);
        gen.writeNumber(out.suspensionTime);
        gen.writeNumber(out.count);
        gen.writeNumber(out.childCount);
        if (out == this.rootNode) {
            gen.writeNumber(out.startTime);
            gen.writeNumber(out.endTime);
        } else {
            gen.writeNumber(out.startTime - this.rootNode.startTime);
            gen.writeNumber(out.endTime - this.rootNode.startTime);
        }
        gen.writeNumber(out.isReactorFrame);
        gen.writeNumber(out.reactorDuration);
        gen.writeNumber(out.blockingOperator);
        gen.writeNumber(out.reactorStartTime);
        gen.writeNumber(out.reactorLeastTime);
        gen.writeNumber(out.prevOperation);
        gen.writeNumber(out.currentOperation);
        ArrayList<Hotspot> child = out.children;
        if (child != null) {
            void var8_10;
            boolean cut;
            ++this.level;
            JsonGenerator oldOut = gen;
            boolean bl = cut = this.level > this.maxNestLevel;
            if (cut) {
                this.level -= this.maxNestLevel;
                ++this.deepIdx;
                gen.writeRaw(",d");
                gen.writeRaw(Integer.toString(this.deepIdx));
                gen.writeRaw("()");
                StringWriter sw = new StringWriter();
                this.deep.add(sw);
                gen = this.createSubSerializer(sw);
                gen.writeRaw("\nfunction d");
                gen.writeRaw(Integer.toString(this.deepIdx));
                gen.writeRaw("(){return");
            }
            gen.writeStartArray();
            if (out.children.size() > 1) {
                Collections.sort(out.children, TotalSelfCount.INSTANCE);
            }
            Hotspot firstChild = child.get(0);
            canCollapse = this.walk(firstChild, gen);
            canCollapse = out.tags != null ? -2 : (!((out.childTime - firstChild.childTime) * 10L > out.totalTime || out.totalTime == 0L && (out.childCount - firstChild.childCount) * 10 > out.childCount || out.count != 0 && out.count * 5 <= firstChild.count) ? (canCollapse >= 0 ? ++canCollapse : --canCollapse) : (out.count != 0 && out.count * 5 <= firstChild.count ? -1 : (canCollapse < 0 ? -3 : 0)));
            boolean bl2 = true;
            while (var8_10 < child.size()) {
                Hotspot hotspot = child.get((int)var8_10);
                int canCollapseChild = this.walk(hotspot, gen);
                if (canCollapseChild < 0 && canCollapse > 0) {
                    canCollapse = -3;
                }
                ++var8_10;
            }
            gen.writeEndArray();
            if (cut) {
                gen.writeRaw('}');
                gen.close();
                gen = oldOut;
                this.level += this.maxNestLevel;
            }
            gen.writeNumber(canCollapse < -2 ? -3 - canCollapse : (canCollapse > 0 ? canCollapse : 0));
            --this.level;
        } else if (out.tags != null) {
            gen.writeRaw(",[],0");
        }
        if (out.tags != null) {
            gen.writeStartArray();
            for (HotspotTag tag : out.tags.values()) {
                gen.writeStartArray();
                gen.writeNumber(tag.id);
                gen.writeNumber(tag.totalTime);
                gen.writeNumber(tag.assemblyId);
                gen.writeNumber(tag.isParallel);
                gen.writeStartArray();
                for (Pair pair : tag.parallels) {
                    gen.writeStartArray();
                    gen.writeNumber((Integer)pair.getKey());
                    gen.writeNumber((Integer)pair.getValue());
                    gen.writeEndArray();
                }
                gen.writeEndArray();
                gen.writeNumber(tag.reactorStartDate);
                gen.writeNumber(tag.count);
                Object val = tag.value;
                if (val instanceof String) {
                    gen.writeString((String)val);
                } else if (val instanceof StringValue) {
                    gen.writeString(((StringValue)val).value);
                } else if (val instanceof ClobValue) {
                    ClobValue clobValue = (ClobValue)val;
                    gen.writeRaw(",");
                    gen.writeRaw(clobValue.folder.charAt(0));
                    gen.writeRaw("[\"");
                    gen.writeRaw(Integer.toString(clobValue.offset));
                    gen.writeRaw('/');
                    gen.writeRaw(Integer.toString(clobValue.fileIndex));
                    gen.writeRaw('/');
                    gen.writeRaw(String.valueOf(this.folder2id.get(clobValue.dataFolderPath)));
                    gen.writeRaw("\"]");
                } else {
                    gen.writeString("(unknown value type) " + String.valueOf(val));
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
        if (child == null) {
            gen.writeRaw('\n');
        }
        return canCollapse;
    }
}

