/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.io.Call;
import org.qubership.profiler.io.CallRowid;
import org.qubership.profiler.io.call.CallDataReaderFactory;
import org.qubership.profiler.io.call.ReactorCallReader;
import org.qubership.profiler.io.searchconditions.BaseSearchConditions;

public abstract class ReactorChainsResolver {
    public List<String>[] splitChainIDs(String[] treeIDs) {
        ArrayList<String> regularCalls = new ArrayList<String>();
        ArrayList<String> chainCalls = new ArrayList<String>();
        for (String s : treeIDs) {
            if (StringUtils.startsWith(s, "chain_")) {
                chainCalls.add(s);
                continue;
            }
            regularCalls.add(s);
        }
        return new List[]{regularCalls, chainCalls};
    }

    public Map<String, String> folderIDMapping(HttpServletRequest req) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : req.getParameterMap().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("f[_") || !key.endsWith("]")) continue;
            String folderId = StringUtils.substring(key, 3, key.length() - 1);
            if (entry.getValue() == null || entry.getValue().length != 1 || StringUtils.isBlank(entry.getValue()[0])) {
                throw new RuntimeException("Illegal value in request by key " + key + ": " + ArrayUtils.toString(entry.getValue()));
            }
            result.put(folderId, entry.getValue()[0]);
        }
        return result;
    }

    public List<CallRowid> resolveReactorChains(HttpServletRequest req, List<String> chainCallIDs) {
        ArrayList<CallRowid> result = new ArrayList<CallRowid>();
        Map<String, List<Chain>> foldersToChains = this.groupChainsByFolders(req, chainCallIDs);
        Map<String, String> folderIdMapping = this.folderIDMapping(req);
        for (Map.Entry<String, List<Chain>> f2c : foldersToChains.entrySet()) {
            String folderId = f2c.getKey();
            Collection chains = f2c.getValue();
            String folderName = folderIdMapping.get(f2c.getKey());
            HashSet<String> chainIDs = new HashSet<String>();
            HashSet<String> toScan = new HashSet<String>();
            for (Chain ch : chains) {
                chainIDs.add(ch.chainId);
                toScan.addAll(Arrays.asList(ch.callsStreamIndexes));
            }
            for (String i : toScan) {
                int sequenceId = Integer.parseInt(i);
                this.scanReactorCallsFile(result, folderName, folderId, sequenceId, chainIDs);
            }
        }
        return result;
    }

    protected abstract DataInputStreamEx openReactorCallsStream(String var1, int var2) throws IOException;

    private void scanReactorCallsFile(List<CallRowid> result, String folderName, String folderId, int sequence, Set<String> searchIDs) {
        Call tmp = new Call();
        try (DataInputStreamEx in2 = this.openReactorCallsStream(folderName, sequence);){
            if (in2 == null) {
                return;
            }
            int fileFormat = in2.readVarInt();
            ReactorCallReader reader = CallDataReaderFactory.createReactorReader(fileFormat);
            while (true) {
                tmp.reactorChainId = null;
                reader.read(tmp, in2);
                if (!searchIDs.contains(tmp.reactorChainId)) continue;
                result.add(new CallRowid(folderName, Integer.parseInt(folderId), tmp.traceFileIndex, tmp.bufferOffset, tmp.recordIndex, tmp.reactorFileIndex, tmp.reactorBufferOffset));
            }
        }
        catch (EOFException in2) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, List<Chain>> groupChainsByFolders(HttpServletRequest req, List<String> chainCallIDs) {
        HashMap<String, List<Chain>> result = new HashMap<String, List<Chain>>();
        for (String chainIdStr : chainCallIDs) {
            String[] split = chainIdStr.split("_");
            if (!StringUtils.equals(split[0], "chain")) {
                throw new RuntimeException("chain id should start with chain_");
            }
            String folderId = split[1];
            String chainId = split[2];
            String[] callsStreamIndexes = new String[split.length - 3];
            System.arraycopy(split, 3, callsStreamIndexes, 0, split.length - 3);
            BaseSearchConditions.putMultimap(result, folderId, new Chain(chainId, callsStreamIndexes));
        }
        return result;
    }

    private static class Chain {
        String chainId;
        String[] callsStreamIndexes;

        public Chain(String chainId, String[] callsStreamIndexes) {
            this.chainId = chainId;
            this.callsStreamIndexes = callsStreamIndexes;
        }
    }
}

