/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.qubership.profiler.agent.DumperCollectorClient;
import org.qubership.profiler.agent.DumperRemoteControlledStream;
import org.qubership.profiler.cloud.transport.PhraseOutputStream;
import org.qubership.profiler.exception.ProfilerAgentIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAndLocalOutputStream
extends OutputStream {
    public static final Logger log = LoggerFactory.getLogger(RemoteAndLocalOutputStream.class);
    private final DumperCollectorClient client;
    private final String streamName;
    private OutputStream local;
    private OutputStream remoteBuffer;
    private int rollingSequenceId = -1;
    private boolean remoteEnabled = true;
    private boolean localEnabled;
    private long rotationPeriod;
    private long requiredRotationSize;
    private boolean resetRequired;

    public RemoteAndLocalOutputStream(DumperCollectorClient client, String streamName, int requestedRollingSequenceId, boolean localEnabled, boolean resetRequired) throws IOException {
        if (client == null) {
            throw new NullPointerException("RemoteAndLocalOutputStream cannot be constructed without CollectorClient");
        }
        this.localEnabled = localEnabled;
        this.client = client;
        this.streamName = streamName;
        this.resetRequired = resetRequired;
        this.remoteBuffer = this.initRemoteBuffer(requestedRollingSequenceId);
    }

    private OutputStream initRemoteBuffer(int requestedRollingSequenceId) throws IOException {
        DumperRemoteControlledStream chunkStream = this.client.createRollingChunk(this.streamName, requestedRollingSequenceId, this.resetRequired);
        this.rollingSequenceId = chunkStream.getRollingSequenceId();
        this.rotationPeriod = chunkStream.getRotationPeriod();
        this.requiredRotationSize = chunkStream.getRequiredRotationSize();
        OutputStream remote = "dictionary".equals(this.streamName) || "suspend".equals(this.streamName) || "params".equals(this.streamName) ? new PhraseOutputStream(chunkStream.getOutputStream(), 10240, 1024) : new BufferedOutputStream(chunkStream.getOutputStream(), 1024);
        return remote;
    }

    private OutputStream getLocal() {
        return this.local;
    }

    public void setLocal(OutputStream local) {
        this.local = local;
    }

    private OutputStream getRemote() {
        return this.remoteBuffer;
    }

    private void checkLocalInitialized() throws ProfilerAgentIOException {
        if (this.localEnabled && this.local == null) {
            throw new ProfilerAgentIOException("Local dump is requested but no local stream provided. Stream " + this.streamName);
        }
    }

    public void writePhrase() throws IOException {
        if (this.remoteEnabled && this.remoteBuffer instanceof PhraseOutputStream) {
            ((PhraseOutputStream)this.remoteBuffer).writePhrase();
        }
    }

    @Override
    public void write(int word) throws IOException {
        this.checkLocalInitialized();
        try {
            if (this.localEnabled) {
                this.getLocal().write(word);
            }
        }
        finally {
            if (this.remoteEnabled) {
                if (log.isTraceEnabled()) {
                    log.trace("writing 1 byte to remote");
                }
                this.getRemote().write(word);
            } else {
                log.warn("remote disabled. not writing byte");
            }
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.checkLocalInitialized();
        try {
            if (this.localEnabled) {
                this.getLocal().write(bytes);
            }
        }
        finally {
            if (this.remoteEnabled) {
                if (log.isTraceEnabled()) {
                    log.trace("writing {} bytes to remote", (Object)bytes.length);
                }
                this.getRemote().write(bytes);
            } else {
                log.warn("remote disabled. not writing {} bytes", (Object)bytes.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.checkLocalInitialized();
        try {
            if (this.localEnabled) {
                this.getLocal().write(bytes, offset, length);
            }
        }
        finally {
            if (this.remoteEnabled) {
                if (log.isTraceEnabled()) {
                    log.trace("writing {} bytes to remote", (Object)length);
                }
                this.getRemote().write(bytes, offset, length);
            } else {
                log.warn("remote disabled. not writing {} bytes", (Object)length);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkLocalInitialized();
        try {
            if (this.localEnabled) {
                this.getLocal().flush();
            }
        }
        finally {
            if (this.remoteEnabled) {
                if (log.isTraceEnabled()) {
                    log.trace("flushing remote");
                }
                if (this.client.isOnline()) {
                    this.getRemote().flush();
                } else {
                    log.debug("not attempting to flush remote output stream {}:{}", (Object)this.streamName, (Object)this.rollingSequenceId);
                }
            } else {
                log.warn("remote disabled. not flushing remote");
            }
        }
    }

    @Override
    public void close() throws IOException {
        block11: {
            this.checkLocalInitialized();
            try {
                if (!this.localEnabled) break block11;
                try {
                    this.getLocal().flush();
                }
                finally {
                    this.getLocal().close();
                }
            }
            finally {
                if (this.remoteEnabled) {
                    if (log.isTraceEnabled()) {
                        log.trace("closing remote");
                    }
                    if (this.client.isOnline()) {
                        this.getRemote().close();
                    } else {
                        log.debug("not attempting to close remote output stream {}:{}", (Object)this.streamName, (Object)this.rollingSequenceId);
                    }
                } else {
                    log.debug("remote disabled. not closing {}:{}", (Object)this.streamName, (Object)this.rollingSequenceId);
                }
            }
        }
    }

    public long getRotationPeriod() {
        return this.rotationPeriod;
    }

    public long getRequiredRotationSize() {
        return this.requiredRotationSize;
    }

    public int getRollingSequenceId() {
        return this.rollingSequenceId;
    }
}

