/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io.searchconditions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.io.Call;
import org.qubership.profiler.io.searchconditions.ComparisonCondition;
import org.qubership.profiler.io.searchconditions.Condition;
import org.qubership.profiler.io.searchconditions.LoadRequest;
import org.qubership.profiler.io.searchconditions.LogicalCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class BaseSearchConditions {
    private static final Logger log = LoggerFactory.getLogger(BaseSearchConditions.class);
    private String conditionsStr;
    private LogicalCondition rootCondition;
    protected Date globalDateFrom;
    protected Date globalDateTo;
    public static final String DATE_1 = "yyyy/MM/dd HH:mm";
    public static final String DATE_2 = "yyyy-MM-dd HH:mm";
    public static final String DATE_3 = "yyyy/MM/dd";
    public static final String DATE_4 = "yyyy-MM-dd";
    protected Map<String, List<String>> serviceNamesToPOD = new HashMap<String, List<String>>();
    protected Map<String, List<String>> podInfoToPOD = new HashMap<String, List<String>>();
    protected Map<String, List<String>> rcInfoToPOD = new HashMap<String, List<String>>();
    protected Map<String, List<String>> dcInfoToPOD = new HashMap<String, List<String>>();
    protected Map<String, List<String>> nameSpacesToPOD = new HashMap<String, List<String>>();
    protected Map<String, String> serviceNames = new HashMap<String, String>();
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Map<String, Date[]> podLifetimes;

    protected BaseSearchConditions() {
        throw new RuntimeException("no-args not supported");
    }

    public BaseSearchConditions(String conditionsStr, Date globalDateFrom, Date globalDateTo) throws IOException {
        this.conditionsStr = conditionsStr;
        this.rootCondition = this.parseConditions(conditionsStr);
        this.globalDateFrom = globalDateFrom;
        this.globalDateTo = globalDateTo;
    }

    public BaseSearchConditions(String conditionsStr, long globalDateFrom, long globalDateTo) throws IOException {
        this(conditionsStr, new Date(globalDateFrom), new Date(globalDateTo));
    }

    public static <K, V> void putMultimap(Map<K, List<V>> map, K key, V value) {
        List<V> toPut = map.get(key);
        if (toPut == null) {
            toPut = new LinkedList<V>();
            map.put(key, toPut);
        }
        toPut.add(value);
    }

    protected void byLines(Map<String, List<String>> map, String info, String podName) {
        for (String line : info.split("\n")) {
            BaseSearchConditions.putMultimap(map, line.trim(), podName);
        }
    }

    protected void initServiceNamespaceMapping() {
    }

    private LogicalCondition parseConditions(String conditionsStr) throws IOException {
        JsonNode node = new ObjectMapper().readTree(conditionsStr);
        Condition temp = this.toCondition(node);
        LogicalCondition result = !((temp = this.normalizeCondition(temp)) instanceof LogicalCondition) ? new LogicalCondition(LogicalCondition.Operation.OR, new LogicalCondition(LogicalCondition.Operation.AND, temp)) : (!LogicalCondition.Operation.OR.equals((Object)((LogicalCondition)temp).getOperation()) ? new LogicalCondition(LogicalCondition.Operation.OR, temp) : (LogicalCondition)temp);
        ArrayList<Condition> listOfAnds = new ArrayList<Condition>(result.getConditions().size());
        for (Condition c : result.getConditions()) {
            if (!(c instanceof LogicalCondition) || !LogicalCondition.Operation.AND.equals((Object)((LogicalCondition)c).getOperation())) {
                listOfAnds.add(new LogicalCondition(LogicalCondition.Operation.AND, c));
                continue;
            }
            listOfAnds.add(c);
        }
        result.setConditions(listOfAnds);
        return result;
    }

    private Condition toCondition(JsonNode node) {
        JsonNode comparator = node.get("comparator");
        JsonNode operation = node.get("operation");
        if (comparator != null) {
            ComparisonCondition result = new ComparisonCondition();
            String lValue = node.get("lValue").get("word").asText();
            result.setlValue(lValue);
            JsonNode rValues = node.get("rValues");
            for (JsonNode rValue : rValues) {
                result.addRValue(rValue.get("word").asText());
            }
            result.setComparator(ComparisonCondition.Comparator.from(comparator.asText()));
            return result;
        }
        if (operation != null) {
            LogicalCondition result = new LogicalCondition();
            result.setOperation(LogicalCondition.Operation.from(operation.asText()));
            JsonNode conditions = node.get("conditions");
            for (JsonNode condition : conditions) {
                result.addCondition(this.toCondition(condition));
            }
            return result;
        }
        throw new RuntimeException("Unknown json node " + node.asText());
    }

    private Condition normalizeCondition(Condition condition) {
        if (!(condition instanceof LogicalCondition)) {
            return condition;
        }
        LogicalCondition lc = (LogicalCondition)condition;
        ArrayList<Condition> oldConditions = new ArrayList<Condition>(lc.getConditions());
        ArrayList<Condition> newConditions = new ArrayList<Condition>();
        block5: for (int i = 0; i < oldConditions.size(); ++i) {
            Condition c = (Condition)oldConditions.get(i);
            Condition normalized = this.normalizeCondition(c);
            if (!(normalized instanceof LogicalCondition)) {
                newConditions.add(normalized);
                continue;
            }
            LogicalCondition child = (LogicalCondition)normalized;
            switch (lc.getOperation()) {
                case NOT: {
                    if (LogicalCondition.Operation.NOT.equals((Object)child.getOperation())) {
                        return this.normalizeCondition(child.getConditions().get(0));
                    }
                    LogicalCondition reverseOperation = new LogicalCondition();
                    reverseOperation.setOperation(LogicalCondition.Operation.OR.equals((Object)child.getOperation()) ? LogicalCondition.Operation.AND : LogicalCondition.Operation.OR);
                    for (Condition toNegate : child.getConditions()) {
                        reverseOperation.addCondition(this.normalizeCondition(new LogicalCondition(LogicalCondition.Operation.NOT, toNegate)));
                    }
                    reverseOperation = (LogicalCondition)this.normalizeCondition(reverseOperation);
                    newConditions.add(reverseOperation);
                    continue block5;
                }
                case AND: {
                    if (LogicalCondition.Operation.AND.equals((Object)child.getOperation())) {
                        oldConditions.addAll(child.getConditions());
                        continue block5;
                    }
                    if (LogicalCondition.Operation.OR.equals((Object)child.getOperation())) {
                        ArrayList<Condition> remaining = new ArrayList<Condition>();
                        for (int j = i + 1; j < oldConditions.size(); ++j) {
                            Condition notYetNormalized = (Condition)oldConditions.get(j);
                            remaining.add(this.normalizeCondition(notYetNormalized));
                        }
                        remaining.addAll(newConditions);
                        LogicalCondition newOr = new LogicalCondition();
                        newOr.setOperation(LogicalCondition.Operation.OR);
                        for (Condition childCondition : child.getConditions()) {
                            LogicalCondition innerAnd = new LogicalCondition(LogicalCondition.Operation.AND, new ArrayList<Condition>(remaining));
                            innerAnd.addCondition(this.normalizeCondition(childCondition));
                            newOr.addCondition(this.normalizeCondition(innerAnd));
                        }
                        return this.normalizeCondition(newOr);
                    }
                    newConditions.add(this.normalizeCondition(c));
                }
                case OR: {
                    if (LogicalCondition.Operation.OR.equals((Object)child.getOperation())) {
                        oldConditions.addAll(child.getConditions());
                    }
                    newConditions.add(this.normalizeCondition(c));
                }
            }
        }
        lc.setConditions(newConditions);
        return lc;
    }

    public List<LoadRequest> loadRequests() {
        this.initServiceNamespaceMapping();
        ArrayList<LoadRequest> result = new ArrayList<LoadRequest>();
        if (!LogicalCondition.Operation.OR.equals((Object)this.rootCondition.getOperation())) {
            throw new RuntimeException("Expecting OR condition as a master condition of a normalized logical operation " + this.rootCondition);
        }
        for (Condition lc : this.rootCondition.getConditions()) {
            if (!(lc instanceof LogicalCondition) || !LogicalCondition.Operation.AND.equals((Object)((LogicalCondition)lc).getOperation())) {
                throw new RuntimeException("expecting AND at the second level of logical expression " + lc);
            }
            LogicalCondition innerAnd = (LogicalCondition)lc;
            PODNameFilter filter = new PODNameFilter(this.globalDateFrom, this.globalDateTo);
            for (Condition insideAnd : innerAnd.getConditions()) {
                ComparisonCondition cc;
                if (insideAnd instanceof LogicalCondition) {
                    LogicalCondition innerNot = (LogicalCondition)insideAnd;
                    if (!LogicalCondition.Operation.NOT.equals((Object)innerNot.getOperation())) {
                        throw new RuntimeException("Expecting NOT or ComparisonCondition at the 3-rd level of " + innerNot);
                    }
                    if (innerNot.getConditions().size() != 1) {
                        throw new RuntimeException("NOT should have exactly one condition inside it " + innerNot);
                    }
                    cc = (ComparisonCondition)innerNot.getConditions().get(0);
                } else {
                    cc = (ComparisonCondition)insideAnd;
                }
                this.applyToFilter(filter, cc);
            }
            this.removeInactivePODs(filter);
            for (String podName : filter.podNames) {
                LoadRequest request = new LoadRequest(podName, filter.dateFrom, filter.dateTo);
                result.add(request);
            }
        }
        return result;
    }

    protected boolean checkPodLifetime() {
        return false;
    }

    private void removeInactivePODs(PODNameFilter filter) {
        Date dateFrom = filter.dateFrom;
        Date dateTo = filter.dateTo;
        if (dateFrom.compareTo(dateTo) > 0) {
            throw new RuntimeException("Date from " + dateFrom + " is greater than date to " + dateTo);
        }
        if (!this.checkPodLifetime()) {
            return;
        }
        Iterator<String> it = filter.podNames.iterator();
        while (it.hasNext()) {
            String podName = it.next();
            Date[] bounds = this.podLifetimes.get(podName);
            if (bounds != null && bounds[0].compareTo(dateTo) <= 0 && bounds[1].compareTo(dateFrom) >= 0) continue;
            it.remove();
        }
    }

    protected void applyToFilter(PODNameFilter filter, ComparisonCondition cc) {
        Set<String> okPODNames;
        if ("pod_name".equalsIgnoreCase(cc.getlValue())) {
            Set<String> options = this.serviceNames.keySet();
            Set<String> okOptions = this.filterAvailableOptions(options, cc.getComparator(), cc.getrValues());
            filter.applyPODNameLimitation(okOptions);
        }
        if ("service_name".equalsIgnoreCase(cc.getlValue())) {
            okPODNames = this.filterPODNamesByMultimapMapping(this.serviceNamesToPOD, cc.getComparator(), cc.getrValues());
            filter.applyPODNameLimitation(okPODNames);
        }
        if ("namespace".equalsIgnoreCase(cc.getlValue())) {
            okPODNames = this.filterPODNamesByMultimapMapping(this.nameSpacesToPOD, cc.getComparator(), cc.getrValues());
            filter.applyPODNameLimitation(okPODNames);
        }
        if ("date".equalsIgnoreCase(cc.getlValue())) {
            if (cc.getrValues().size() != 1) {
                throw new RuntimeException("Expecting exactly one rValue for dates " + this.conditionsStr);
            }
            long newDate = this.parseDateTime(cc.getrValues().get(0));
            if (ComparisonCondition.Comparator.GT.equals((Object)cc.getComparator()) || ComparisonCondition.Comparator.GE.equals((Object)cc.getComparator())) {
                filter.dateFrom = new Date(Math.max(filter.dateFrom.getTime(), newDate));
            } else if (ComparisonCondition.Comparator.LT.equals((Object)cc.getComparator()) || ComparisonCondition.Comparator.LE.equals((Object)cc.getComparator())) {
                filter.dateTo = new Date(Math.max(filter.dateFrom.getTime(), newDate));
            } else {
                throw new RuntimeException("Comparator " + (Object)((Object)cc.getComparator()) + " is not supported for dates");
            }
        }
    }

    private long parseDateTime(String dateStr) {
        for (String dateFormat : Arrays.asList(DATE_1, DATE_2, DATE_3, DATE_4)) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            try {
                return sdf.parse(dateStr).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        int bracketOpen = StringUtils.indexOf(dateStr, '(');
        int bracketClose = StringUtils.lastIndexOf(dateStr, ')');
        String function = StringUtils.substring(dateStr, bracketOpen);
        String operand = StringUtils.substring(dateStr, bracketOpen + 1, bracketClose);
        long time = this.resolveDateFunction(function);
        long delta = this.resolveDateOperand(operand);
        return time - delta;
    }

    private long resolveDateFunction(String function) {
        if ("now".equalsIgnoreCase(function)) {
            return System.currentTimeMillis();
        }
        throw new RuntimeException("Unsupported date function " + function);
    }

    private long resolveDateOperand(String operand) {
        String amountStr = StringUtils.substring(operand, 0, operand.length() - 1);
        long amount = Long.parseLong(amountStr);
        char unit = operand.charAt(operand.length() - 1);
        switch (unit) {
            case 'y': {
                return amount * 1000L * 3600L * 24L * 365L;
            }
            case 'M': {
                return amount * 1000L * 3600L * 24L * 30L;
            }
            case 'w': {
                return amount * 1000L * 3600L * 24L * 7L;
            }
            case 'd': {
                return amount * 1000L * 3600L * 24L;
            }
            case 'H': {
                return amount * 1000L * 3600L;
            }
            case 'm': {
                return amount * 1000L * 60L;
            }
        }
        throw new RuntimeException("Unsupported unit " + unit);
    }

    protected Set<String> filterPODNamesByMultimapMapping(Map<String, List<String>> podNameAggregator, ComparisonCondition.Comparator cmp, Collection<String> compareWith) {
        Set<String> options = podNameAggregator.keySet();
        Set<String> okOptions = this.filterAvailableOptions(options, cmp, compareWith);
        HashSet<String> okPODNames = new HashSet<String>();
        for (String okOption : okOptions) {
            okPODNames.addAll((Collection<String>)podNameAggregator.get(okOption));
        }
        return okPODNames;
    }

    private Set<String> filterAvailableOptions(Set<String> superset, ComparisonCondition.Comparator cmp, Collection<String> compareWith) {
        switch (cmp) {
            case EQ: 
            case IN: {
                HashSet<String> result = new HashSet<String>(superset);
                result.retainAll(compareWith);
                return result;
            }
            case NE: 
            case NOTIN: {
                HashSet<String> result = new HashSet<String>(superset);
                result.removeAll(compareWith);
                return result;
            }
            case LIKE: {
                return this.filterByLike(superset, compareWith);
            }
            case NOTLIKE: {
                Set<String> toRemove = this.filterByLike(superset, compareWith);
                HashSet<String> result = new HashSet<String>(superset);
                result.removeAll(toRemove);
                return result;
            }
        }
        throw new RuntimeException("Invalid comparator " + (Object)((Object)cmp));
    }

    private Set<String> filterByLike(Set<String> superset, Collection<String> compareWith) {
        HashSet<String> result = new HashSet<String>();
        for (String str : superset) {
            for (String toCompare : compareWith) {
                if (!this.matchesPattern(str, toCompare)) continue;
                result.add(str);
            }
        }
        return result;
    }

    private boolean matchesPattern(String word, String pattern) {
        int patternPercentIndex;
        int patternIndex = 0;
        int wordIndex = 0;
        do {
            String patternWord = pattern.substring(patternIndex, (patternPercentIndex = pattern.indexOf(37, patternIndex)) >= 0 ? patternPercentIndex : pattern.length());
            if (patternIndex == 0 && patternPercentIndex > 0 && !word.startsWith(patternWord)) {
                return false;
            }
            if (patternIndex > 0 && patternPercentIndex < 0 && !word.endsWith(patternWord)) {
                return false;
            }
            if ((wordIndex = word.indexOf(patternWord, wordIndex)) < 0) {
                return false;
            }
            wordIndex += patternWord.length();
            patternIndex += patternWord.length() + 1;
        } while (patternPercentIndex >= 0);
        return true;
    }

    public List<Call> filterLoadedCalls(List<Call> toFilter) {
        return toFilter;
    }

    protected static class PODNameFilter {
        Set<String> podNames = null;
        Date dateFrom;
        Date dateTo;

        public PODNameFilter(Date dateFrom, Date dateTo) {
            this.dateFrom = dateFrom;
            this.dateTo = dateTo;
        }

        public void applyPODNameLimitation(Set<String> availablePODNames) {
            if (this.podNames == null) {
                this.podNames = new HashSet<String>(availablePODNames);
            } else {
                this.podNames.retainAll(availablePODNames);
            }
        }
    }
}

