/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.builders;

import java.util.Arrays;
import org.qubership.profiler.chart.Provider;
import org.qubership.profiler.io.SuspendLog;
import org.qubership.profiler.sax.builders.SuspendLogBuilder;
import org.qubership.profiler.sax.raw.SuspendLogVisitor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class MultiRangeSuspendLogBuilder
extends SuspendLogVisitor
implements Provider<SuspendLog> {
    private static int MAX_SIZE = 200000;
    private static int DEFAULT_FIRST_RANGE_RATIO_PCT = 15;
    private static int DEFAULT_MIDDLE_RANGE_RATIO_PCT = 70;
    private static int DEFAULT_LAST_RANGE_RATIO_PCT = 15;
    private long middleRangeStartTime;
    private long middleRangeEndTime;
    private SuspendLogBuilder firstRangeSuspendLogBuilder;
    private SuspendLogBuilder middleRangeSuspendLogBuilder;
    private SuspendLogBuilder lastRangeSuspendLogBuilder;
    private SuspendLog log;

    public MultiRangeSuspendLogBuilder(String rootReference, long middleRangeStartTime, long middleRangeEndTime, ApplicationContext context) {
        this(1000, rootReference, middleRangeStartTime, middleRangeEndTime, context);
    }

    public MultiRangeSuspendLogBuilder(int size, String rootReference, long middleRangeStartTime, long middleRangeEndTime, ApplicationContext context) {
        this(size, MAX_SIZE, rootReference, middleRangeStartTime, middleRangeEndTime, context);
    }

    public MultiRangeSuspendLogBuilder(int size, int maxSize, String rootReference, long middleRangeStartTime, long middleRangeEndTime, ApplicationContext context) {
        this(1, size, maxSize, rootReference, middleRangeStartTime, middleRangeEndTime, context);
    }

    protected MultiRangeSuspendLogBuilder(int api, int size, int maxSize, String rootReference, long middleRangeStartTime, long middleRangeEndTime, ApplicationContext context) {
        this(1, size, maxSize, rootReference, middleRangeStartTime, middleRangeEndTime, DEFAULT_FIRST_RANGE_RATIO_PCT, DEFAULT_MIDDLE_RANGE_RATIO_PCT, DEFAULT_LAST_RANGE_RATIO_PCT, context);
    }

    protected MultiRangeSuspendLogBuilder(int api, int size, int maxSize, String rootReference, long middleRangeStartTime, long middleRangeEndTime, int firstRangeRatioPct, int middleRangeRatioPct, int lastRangeRatioPct, ApplicationContext context) {
        super(api);
        this.middleRangeStartTime = middleRangeStartTime;
        this.middleRangeEndTime = middleRangeEndTime;
        this.firstRangeSuspendLogBuilder = context.getBean(SuspendLogBuilder.class, api, size * firstRangeRatioPct / 100, maxSize * firstRangeRatioPct / 100, rootReference);
        this.middleRangeSuspendLogBuilder = context.getBean(SuspendLogBuilder.class, api, size * middleRangeRatioPct / 100, maxSize * middleRangeRatioPct / 100, rootReference);
        this.lastRangeSuspendLogBuilder = context.getBean(SuspendLogBuilder.class, api, size * lastRangeRatioPct / 100, maxSize * lastRangeRatioPct / 100, rootReference);
        this.log = new SuspendLog(new long[size], new int[size]);
    }

    @Override
    public void visitHiccup(long date, int delay) {
        if (date < this.middleRangeStartTime) {
            this.firstRangeSuspendLogBuilder.visitHiccup(date, delay);
        } else if (date > this.middleRangeEndTime) {
            this.lastRangeSuspendLogBuilder.visitHiccup(date, delay);
        } else {
            this.middleRangeSuspendLogBuilder.visitHiccup(date, delay);
        }
    }

    @Override
    public void visitEnd() {
        int s1 = this.firstRangeSuspendLogBuilder.size;
        int s2 = this.middleRangeSuspendLogBuilder.size;
        int s3 = this.lastRangeSuspendLogBuilder.size;
        int size = s1 + s2 + s3;
        long[] dates = new long[size];
        int[] delays = new int[size];
        int[] trueDelays = new int[size];
        System.arraycopy(this.firstRangeSuspendLogBuilder.dates, 0, dates, 0, s1);
        System.arraycopy(this.middleRangeSuspendLogBuilder.dates, 0, dates, s1, s2);
        System.arraycopy(this.lastRangeSuspendLogBuilder.dates, 0, dates, s1 + s2, s3);
        System.arraycopy(this.firstRangeSuspendLogBuilder.delays, 0, delays, 0, s1);
        System.arraycopy(this.middleRangeSuspendLogBuilder.delays, 0, delays, s1, s2);
        System.arraycopy(this.lastRangeSuspendLogBuilder.delays, 0, delays, s1 + s2, s3);
        this.copyTrueDelays(this.firstRangeSuspendLogBuilder.trueDelays, trueDelays, 0, s1);
        this.copyTrueDelays(this.middleRangeSuspendLogBuilder.trueDelays, trueDelays, s1, s2);
        this.copyTrueDelays(this.lastRangeSuspendLogBuilder.trueDelays, trueDelays, s1 + s2, s3);
        this.log.setValue(dates, delays, trueDelays);
    }

    private void copyTrueDelays(int[] src, int[] dest, int destPos, int length) {
        if (src == null) {
            Arrays.fill(dest, destPos, destPos + length, -1);
        } else {
            System.arraycopy(src, 0, dest, destPos, length);
        }
    }

    @Override
    public SuspendLog get() {
        return this.log;
    }
}

