/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.builders;

import org.qubership.profiler.analyzer.DelayTreeTillReady;
import org.qubership.profiler.analyzer.MergeTrees;
import org.qubership.profiler.dom.ProfiledTreeStreamVisitor;
import org.qubership.profiler.sax.builders.ProfiledTreeBuilder;
import org.qubership.profiler.sax.raw.MultiRepositoryVisitor;
import org.qubership.profiler.sax.raw.RepositoryVisitor;
import org.springframework.context.ApplicationContext;

public class ProfiledTreeBuilderMR
extends MultiRepositoryVisitor {
    private final ProfiledTreeStreamVisitor sv;
    private final int paramsTrimSize;
    private final ApplicationContext context;

    public ProfiledTreeBuilderMR(ProfiledTreeStreamVisitor sv, ApplicationContext context) {
        this(1, sv, Integer.MAX_VALUE, context);
    }

    public ProfiledTreeBuilderMR(ProfiledTreeStreamVisitor sv, int paramsTrimSize, ApplicationContext context) {
        this(1, sv, paramsTrimSize, context);
    }

    protected ProfiledTreeBuilderMR(int api, ProfiledTreeStreamVisitor sv, int paramsTrimSize, ApplicationContext context) {
        super(api);
        this.sv = sv;
        this.paramsTrimSize = paramsTrimSize;
        this.context = context;
    }

    @Override
    public RepositoryVisitor visitRepository(String rootReference) {
        ProfiledTreeStreamVisitor delay = new DelayTreeTillReady(this.sv.asSkipVisitEnd());
        if (this.sv instanceof MergeTrees) {
            delay = new MergeTrees(delay);
        }
        return new ProfiledTreeBuilder(delay, this.paramsTrimSize, this.context, rootReference);
    }

    @Override
    public void visitEnd() {
        this.sv.visitEnd();
    }
}

