/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.readers;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.io.ParamReader;
import org.qubership.profiler.io.ParamReaderFactory;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.sax.raw.ClobReaderFlyweight;
import org.qubership.profiler.sax.raw.ClobValueVisitor;
import org.qubership.profiler.sax.raw.DictionaryVisitor;
import org.qubership.profiler.sax.raw.RepositoryVisitor;
import org.qubership.profiler.sax.raw.SuspendLogVisitor;
import org.qubership.profiler.sax.raw.TraceVisitor;
import org.qubership.profiler.sax.raw.TreeRowid;
import org.qubership.profiler.sax.raw.TreeTraceVisitor;
import org.qubership.profiler.sax.readers.SuspendLogReader;
import org.qubership.profiler.sax.values.ClobValue;
import org.qubership.profiler.sax.values.StringValue;
import org.qubership.profiler.sax.values.ValueHolder;
import org.qubership.profiler.timeout.ProfilerTimeoutException;
import org.qubership.profiler.timeout.ProfilerTimeoutHandler;
import org.qubership.profiler.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class ProfilerTraceReader {
    public static final String TRACE_STREAM_NAME = "trace";
    private static final Logger log = LoggerFactory.getLogger(ProfilerTraceReader.class);
    protected final RepositoryVisitor rv;
    protected String rootReference;
    protected List<TreeRowid> treeRowids = new ArrayList<TreeRowid>();
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected ParamReaderFactory paramReaderFactory;

    public ProfilerTraceReader(RepositoryVisitor rv, String rootReference) {
        this.rv = rv;
        this.rootReference = rootReference;
    }

    public ProfilerTraceReader() {
        this(null, null);
        throw new RuntimeException("No-args not supported");
    }

    public abstract DataInputStreamEx reopenDataInputStream(DataInputStreamEx var1, String var2, int var3) throws IOException;

    public void read(List<TreeRowid> treeRowids) {
        this.read(treeRowids, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(List<TreeRowid> treeRowids, long begin, long end) {
        HashMap<ClobValue, ClobValue> uniqueClobs;
        BitSet ids;
        block43: {
            boolean isTraceEnabled = log.isTraceEnabled();
            Collections.sort(treeRowids);
            this.treeRowids.addAll(treeRowids);
            HashMap<Long, TreeTraceVisitor> threads = new HashMap<Long, TreeTraceVisitor>();
            DataInputStreamEx trace = null;
            this.readSuspendLog(begin, end);
            TraceVisitor tv = null;
            ids = new BitSet();
            uniqueClobs = new HashMap<ClobValue, ClobValue>();
            try {
                tv = this.rv.visitTrace();
                int traceFileIndex = treeRowids.get((int)0).traceFileIndex;
                int callPos = 0;
                trace = this.reopenDataInputStream(trace, TRACE_STREAM_NAME, traceFileIndex);
                long timerStartTime = trace.readLong();
                while (callPos < treeRowids.size() || !threads.isEmpty()) {
                    int header;
                    int typ;
                    Long currentThreadId;
                    int tracePos;
                    block44: {
                        ProfilerTimeoutHandler.checkTimeout();
                        tracePos = trace.position();
                        if (isTraceEnabled) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("New buffer. position: ").append(tracePos).append(", callPos: ").append(callPos);
                            if (callPos < treeRowids.size()) {
                                sb.append(", treeRowids[callPos].bufferOffset==").append(treeRowids.get((int)callPos).bufferOffset);
                            }
                            sb.append(", threads.size: ").append(threads.size());
                            log.trace(sb.toString());
                        }
                        if (threads.isEmpty() && callPos < treeRowids.size()) {
                            TreeRowid treeRowid = treeRowids.get(callPos);
                            if (traceFileIndex != treeRowid.traceFileIndex) {
                                traceFileIndex = treeRowid.traceFileIndex;
                                trace = this.reopenDataInputStream(trace, TRACE_STREAM_NAME, traceFileIndex);
                                timerStartTime = trace.readLong();
                                tracePos = trace.position();
                                if (isTraceEnabled) {
                                    log.trace("Opened new trace file " + this.rootReference + ", timerStartTime: " + timerStartTime + " (" + new Date(timerStartTime) + "), tracePos: " + tracePos);
                                }
                            }
                            if (tracePos < treeRowids.get((int)callPos).bufferOffset) {
                                if (isTraceEnabled) {
                                    log.trace("Current offset {}, is less than required {}", (Object)tracePos, (Object)treeRowids.get((int)callPos).bufferOffset);
                                }
                                trace.skipBytes(treeRowids.get((int)callPos).bufferOffset - tracePos);
                                tracePos = trace.position();
                            }
                        }
                        try {
                            currentThreadId = trace.readLong();
                            if (isTraceEnabled) {
                                log.trace("currentThreadId: {}", (Object)currentThreadId);
                            }
                        }
                        catch (EOFException eof) {
                            ++traceFileIndex;
                            try {
                                trace = this.reopenDataInputStream(trace, TRACE_STREAM_NAME, traceFileIndex);
                                if (trace == null) {
                                }
                            }
                            catch (FileNotFoundException e) {}
                            break;
                            timerStartTime = trace.readLong();
                            tracePos = trace.position();
                            currentThreadId = trace.readLong();
                            if (!isTraceEnabled) break block44;
                            log.trace("Opened new trace file " + this.rootReference + ", timerStartTime: " + timerStartTime + " (" + new Date(timerStartTime) + "), tracePos: " + tracePos + "currentThreadId: " + currentThreadId);
                        }
                    }
                    TreeTraceVisitor ttv = (TreeTraceVisitor)threads.get(currentThreadId);
                    boolean started = true;
                    int startIndex = 0;
                    if (ttv == null && callPos < treeRowids.size() && treeRowids.get((int)callPos).bufferOffset == tracePos && treeRowids.get((int)callPos).traceFileIndex == traceFileIndex) {
                        started = false;
                        TreeRowid treeRowid = treeRowids.get(callPos);
                        startIndex = treeRowid.recordIndex;
                        String fullRowId = treeRowid.fullRowId;
                        int folderId = treeRowid.folderId;
                        ++callPos;
                        TreeRowid rowid = new TreeRowid(folderId, fullRowId, traceFileIndex, tracePos, startIndex, 0, 0);
                        ttv = tv.visitTree(rowid);
                        threads.put(currentThreadId, ttv);
                    }
                    long realTime = trace.readLong();
                    int realTimeOffset = (int)(realTime - timerStartTime);
                    if (isTraceEnabled) {
                        log.trace("realTime: {}, realTimeOffset: {}", (Object)realTime, (Object)realTimeOffset);
                    }
                    int eventTime = -realTimeOffset;
                    int idx = 0;
                    while ((typ = (header = trace.read()) & 3) != 3) {
                        int time = (header & 0x7F) >> 2;
                        if ((header & 0x80) > 0) {
                            time |= trace.readVarInt() << 5;
                        }
                        eventTime += time;
                        int tagId = 0;
                        long lastAssemblyId = 0L;
                        long lastParentAssemblyId = 0L;
                        int reactorDuration = 0;
                        long reactorStartTime = 0L;
                        int blockingOperator = 0;
                        int prevOperation = 0;
                        int currentOperation = 0;
                        byte isReactorEndPoint = 0;
                        byte isReactorFrame = 0;
                        int emit = 0;
                        ValueHolder value = null;
                        if (typ != 1) {
                            tagId = trace.readVarInt();
                            if (typ == 2) {
                                int paramType = trace.read();
                                switch (paramType) {
                                    case 0: 
                                    case 2: {
                                        value = new StringValue(trace.readString());
                                        break;
                                    }
                                    case 1: 
                                    case 3: {
                                        int traceIndex = trace.readVarInt();
                                        int offs = trace.readVarInt();
                                        if (ttv == null || !started) break;
                                        String clobFolder = paramType == 3 ? "sql" : "xml";
                                        ClobValue newClob = new ClobValue(this.rootReference, clobFolder, traceIndex, offs);
                                        value = newClob;
                                        ClobValue existingClob = (ClobValue)uniqueClobs.get(newClob);
                                        if (existingClob != null) {
                                            value = existingClob;
                                            break;
                                        }
                                        uniqueClobs.put(newClob, newClob);
                                    }
                                }
                            }
                        }
                        if (ttv != null && (started || idx >= startIndex)) {
                            started = true;
                            long eventRealTime = (long)eventTime + realTime;
                            if (tagId == 1042) {
                                if (eventRealTime == 1405085865470L) break block43;
                                if (eventRealTime == 1405086718993L) {
                                    break block43;
                                }
                            }
                            ttv.visitTimeAdvance(eventRealTime - ttv.getTime());
                            ids.set(tagId);
                            switch (typ) {
                                case 0: {
                                    ttv.visitEnter(tagId, lastAssemblyId, lastParentAssemblyId, isReactorEndPoint, isReactorFrame, reactorStartTime, reactorDuration, blockingOperator, prevOperation, currentOperation, emit);
                                    if (!isTraceEnabled) break;
                                    log.trace("> idx: " + idx + ", eventTime: " + eventTime + ", eventRealTime: " + eventRealTime + ", tag: " + tagId + ", " + ttv.getSp());
                                    break;
                                }
                                case 1: {
                                    if (isTraceEnabled) {
                                        log.trace("< idx: " + idx + ", eventTime: " + eventTime + ", eventRealTime: " + eventRealTime + ", sp: " + ttv.getSp());
                                    }
                                    ttv.visitExit();
                                    if (ttv.getSp() != 0) break;
                                    ttv.visitEnd();
                                    if (callPos < treeRowids.size() && treeRowids.get((int)callPos).bufferOffset == tracePos && treeRowids.get((int)callPos).traceFileIndex == traceFileIndex) {
                                        started = false;
                                        TreeRowid treeRowid = treeRowids.get(callPos);
                                        startIndex = treeRowid.recordIndex;
                                        String fullRowId = treeRowid.fullRowId;
                                        int folderId = treeRowid.folderId;
                                        ++callPos;
                                        TreeRowid rowid = new TreeRowid(folderId, fullRowId, traceFileIndex, tracePos, startIndex, 0, 0);
                                        ttv = tv.visitTree(rowid);
                                        threads.put(currentThreadId, ttv);
                                        break;
                                    }
                                    threads.remove(currentThreadId);
                                    ttv = null;
                                    if (!threads.isEmpty() || callPos != treeRowids.size()) break;
                                    break block43;
                                }
                                default: {
                                    if (value == null || tagId == 0 && value instanceof StringValue && value.value.length() == 0) break;
                                    ttv.visitLabel(tagId, value, lastAssemblyId);
                                    if (!isTraceEnabled) break;
                                    log.trace("! idx: " + idx + ", eventTime: " + eventTime + ", eventRealTime: " + eventRealTime + ", tag: " + tagId + ", value: " + value);
                                }
                            }
                        }
                        ++idx;
                    }
                }
            }
            catch (Error | ProfilerTimeoutException e) {
                throw e;
            }
            catch (Throwable t) {
                ErrorSupervisor.getInstance().error("Error while reading profiling tree from folder " + this.rootReference + ", rowids " + treeRowids.toString(), t);
            }
            finally {
                for (TreeTraceVisitor tree : threads.values()) {
                    tree.visitTimeAdvance(System.currentTimeMillis() - tree.getTime());
                    tree.visitLabel(-4, new StringValue("HERE"));
                    while (tree.getSp() > 0) {
                        tree.visitExit();
                    }
                    tree.visitEnd();
                }
                if (tv != null) {
                    tv.visitEnd();
                }
            }
        }
        this.readDictionary(ids);
        this.readClobs(uniqueClobs.keySet());
    }

    public Set<ClobValue> readClobIds(File file, ClobReadMode mode, ClobReadTypes readTypes) {
        return ProfilerTraceReader.readClobIdsOnly(file, mode, readTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<ClobValue> readClobIdsOnly(File file, ClobReadMode mode, ClobReadTypes readTypes) {
        ClobValue lastClobId;
        HashSet<ClobValue> uniqueClobIds;
        block23: {
            if (mode == null) {
                mode = ClobReadMode.ALL_VALUES;
            }
            if (readTypes == null) {
                readTypes = ClobReadTypes.ALL_VALUES;
            }
            DataInputStreamEx trace = null;
            String dataFolderPath = file.getParentFile().getParent();
            uniqueClobIds = new HashSet<ClobValue>();
            lastClobId = null;
            boolean hasReadFirstValue = false;
            try {
                trace = DataInputStreamEx.openDataInputStream(file);
                trace.readLong();
                block12: while (true) {
                    trace.readLong();
                    trace.readLong();
                    int idx = 0;
                    while (true) {
                        int header;
                        int typ;
                        if ((typ = (header = trace.read()) & 3) == 3) continue block12;
                        if ((header & 0x80) > 0) {
                            trace.readVarInt();
                        }
                        int tagId = 0;
                        if (typ != 1) {
                            tagId = trace.readVarInt();
                            if (typ == 2) {
                                int paramType = trace.read();
                                switch (paramType) {
                                    case 0: 
                                    case 2: {
                                        trace.readString();
                                        break;
                                    }
                                    case 1: 
                                    case 3: {
                                        int traceIndex = trace.readVarInt();
                                        int offs = trace.readVarInt();
                                        if (!(readTypes == ClobReadTypes.XML_ONLY && paramType == 1 || readTypes == ClobReadTypes.SQL_ONLY && paramType == 3) && readTypes != ClobReadTypes.ALL_VALUES) break;
                                        String clobFolder = paramType == 3 ? "sql" : "xml";
                                        ClobValue newClob = new ClobValue(dataFolderPath, clobFolder, traceIndex, offs);
                                        if (mode == ClobReadMode.FIRST_ONLY) {
                                            uniqueClobIds.add(newClob);
                                            break block23;
                                        }
                                        if (mode == ClobReadMode.LAST_ONLY) {
                                            lastClobId = newClob;
                                            break;
                                        }
                                        if (mode != ClobReadMode.FIRST_AND_LAST) break;
                                        if (!hasReadFirstValue) {
                                            uniqueClobIds.add(newClob);
                                            hasReadFirstValue = true;
                                        }
                                        lastClobId = newClob;
                                    }
                                }
                            }
                        }
                        ++idx;
                    }
                    break;
                }
            }
            catch (EOFException idx) {
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                ErrorSupervisor.getInstance().warn("Error while reading clobIds from folder " + dataFolderPath, t);
            }
            finally {
                IOHelper.close(trace);
            }
        }
        if ((mode == ClobReadMode.LAST_ONLY || mode == ClobReadMode.FIRST_AND_LAST) && lastClobId != null) {
            uniqueClobIds.add(lastClobId);
        }
        return uniqueClobIds;
    }

    protected SuspendLogReader suspendLogReader(SuspendLogVisitor sv, long begin, long end) {
        return this.applicationContext.getBean(SuspendLogReader.class, sv, this.rootReference, begin, end);
    }

    protected SuspendLogReader suspendLogReader(SuspendLogVisitor sv) {
        return this.suspendLogReader(sv, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected void readSuspendLog(long begin, long end) {
        SuspendLogVisitor sv = this.rv.visitSuspendLog();
        if (sv == null) {
            return;
        }
        SuspendLogReader reader = this.suspendLogReader(sv, begin, end);
        reader.read();
    }

    protected void readSuspendLog() {
        this.readSuspendLog(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected ParamReader paramReader() {
        return this.paramReaderFactory.getInstance(this.rootReference);
    }

    protected void readDictionary(BitSet ids) {
        DictionaryVisitor dv = this.rv.visitDictionary();
        if (dv == null) {
            return;
        }
        boolean isTraceEnabled = log.isTraceEnabled();
        try {
            ParamReader paramReader = this.paramReader();
            ArrayList<Throwable> t = new ArrayList<Throwable>();
            List<String> tags = paramReader.fillTags(ids, t);
            int i = -1;
            while ((i = ids.nextSetBit(i + 1)) >= 0) {
                String s = tags.get(i);
                if (s == null) continue;
                if (isTraceEnabled) {
                    log.trace("Param: id={}, value={}", (Object)i, (Object)s);
                }
                dv.visitName(i, s);
            }
            Map<String, ParameterInfoDto> paramInfos = this.paramReader().fillParamInfo(t, this.rootReference);
            for (ParameterInfoDto info : paramInfos.values()) {
                if (isTraceEnabled) {
                    log.trace("ParamInfo: {}", (Object)info);
                }
                dv.visitParamInfo(info);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            ErrorSupervisor.getInstance().error("Unable to read dictionary from " + this.rootReference, t);
        }
        dv.visitEnd();
    }

    public abstract ClobReaderFlyweight clobReaderFlyweight();

    public void readClobs(Set<ClobValue> clobValueSet) {
        ClobValueVisitor cv = this.rv.visitClobValues();
        if (cv == null) {
            return;
        }
        try {
            Object[] clobs = clobValueSet.toArray(new ClobValue[clobValueSet.size()]);
            Arrays.sort(clobs);
            ClobReaderFlyweight fw = this.clobReaderFlyweight();
            for (Object clob : clobs) {
                fw.adaptTo((ClobValue)clob);
                cv.acceptValue((ClobValue)clob, fw);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            ErrorSupervisor.getInstance().error("Unable to read clobs from " + this.rootReference, t);
        }
        cv.visitEnd();
    }

    public static interface DumperConstants {
        public static final byte EVENT_EMPTY = -1;
        public static final byte EVENT_ENTER_RECORD = 0;
        public static final byte EVENT_EXIT_RECORD = 1;
        public static final byte EVENT_TAG_RECORD = 2;
        public static final byte EVENT_FINISH_RECORD = 3;
        public static final byte COMMAND_ROTATE_LOG = 1;
        public static final byte COMMAND_FLUSH_LOG = 2;
        public static final byte COMMAND_EXIT = 3;
        public static final int TAGS_ROOT = -1;
        public static final int TAGS_HOTSPOTS = -2;
        public static final int TAGS_PARAMETERS = -3;
        public static final int TAGS_CALL_ACTIVE = -4;
    }

    public static enum ClobReadMode {
        ALL_VALUES,
        FIRST_ONLY,
        LAST_ONLY,
        FIRST_AND_LAST;

    }

    public static enum ClobReadTypes {
        ALL_VALUES,
        XML_ONLY,
        SQL_ONLY;

    }
}

