/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class GenerateInjector {
    private final File root;
    private final File dst;
    private PrintWriter pw;
    int methodId;
    String className;
    long lastModified;

    private static long getLastModifiedTime(File file) {
        long fileLastModified = file.lastModified();
        if (fileLastModified == 0L) {
            fileLastModified = System.currentTimeMillis();
        }
        return fileLastModified;
    }

    public GenerateInjector(File root, File dst) {
        this.root = root;
        this.dst = dst;
    }

    public static void main(String[] args) {
        GenerateInjector task = new GenerateInjector(new File(args[0]), new File(args[1]));
        try {
            task.run();
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to process " + args[0] + ", " + args[1]);
            e.printStackTrace();
        }
    }

    private void run() throws FileNotFoundException {
        long lastRun = GenerateInjector.getLastModifiedTime(this.dst);
        File parent = this.dst.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.pw = new PrintWriter(baos, false);
        this.pw.print("package org.qubership.profiler.instrument.enhancement;\n");
        this.pw.print("import java.util.*;\n");
        this.pw.print("import org.objectweb.asm.*;\n");
        this.pw.print("import static org.objectweb.asm.Opcodes.*;\n");
        this.pw.print("import org.qubership.profiler.instrument.enhancement.ClassEnhancer;\n\n");
        String className = this.dst.getName();
        this.className = className = className.substring(0, className.indexOf(46));
        this.pw.print("public class " + className + " extends HashMap<String, ClassEnhancer> {\n\n");
        this.walk(this.root);
        this.pw.print("}\n");
        this.pw.close();
        if (this.dst.exists() && lastRun > this.lastModified) {
            System.out.println("Skipped processing " + this.root + " -> " + this.dst + " since source files are not modified");
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(this.dst);
            ((OutputStream)out).write(baos.toByteArray());
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write " + this.dst, e);
        }
    }

    private void walk(File root) {
        if (root.isDirectory()) {
            for (File file : root.listFiles()) {
                this.walk(file);
            }
            return;
        }
        if (!root.getName().endsWith(".class")) {
            return;
        }
        if (root.getName().startsWith("EnhancerPlugin_")) {
            return;
        }
        try {
            this.processClassFile(root);
        }
        catch (IOException e) {
            System.err.println("Unable to process file " + root.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void processClassFile(File root) throws IOException {
        System.out.println("Processing file " + root.getAbsolutePath());
        this.lastModified = Math.max(this.lastModified, GenerateInjector.getLastModifiedTime(root));
        FileInputStream is = new FileInputStream(root);
        ClassReader cr = new ClassReader(is);
        is.close();
        StringWriter sw = new StringWriter();
        ASMifier asmifier = new ASMifier();
        TraceClassVisitor printer = new TraceClassVisitor(null, asmifier, null);
        FilterProfiledEntities cv = new FilterProfiledEntities(printer);
        cr.accept(cv, 8);
        if (asmifier.getText().isEmpty()) {
            return;
        }
        this.pw.print("  {\n");
        this.pw.print("    put(\"" + cv.className + "\", new ReflectedEnhancerBridge(" + this.className + ".class, \"e" + this.methodId + "\"));\n");
        this.pw.print("  }\n\n");
        this.pw.print("  public static void e" + this.methodId + "(ClassVisitor classWriter) {\n");
        this.pw.print("    FieldVisitor fieldVisitor;\n");
        this.pw.print("    MethodVisitor methodVisitor;\n");
        asmifier.print(this.pw);
        this.pw.print("  }\n");
        ++this.methodId;
    }

    static class FilterProfiledEntities
    extends ClassVisitor {
        private String className;

        public FilterProfiledEntities(ClassVisitor cv) {
            super(589824, cv);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (!name.endsWith("$profiler")) {
                System.out.println("ignoring field " + name);
                return null;
            }
            System.out.println("adding field " + name);
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.contains("toCoreSubscriber")) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            if (!name.endsWith("$profiler") && !"<clinit>".equals(name)) {
                System.out.println("ignoring method " + name);
                return null;
            }
            if ("clinit$profiler".equals(name)) {
                System.out.println("converting method " + name + " to static initializer");
                name = "<clinit>";
            }
            System.out.println("adding method " + name);
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public void visitEnd() {
        }
    }
}

