/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.util.cache;

import java.util.Map;

public class ClockProCache<K, V> {
    Entry[] entries;
    int size;
    int coldCached;
    Map.Entry handHot;
    Map.Entry handTest;
    Map.Entry handCold;

    public ClockProCache(int cacheSize) {
        int capacity = (int)((double)cacheSize / 0.75);
        this.size = Integer.highestOneBit(capacity - 1) << 1;
        this.entries = new Entry[this.size];
        Entry<Object, Object> clock = new Entry<Object, Object>(0, null, null, null);
        clock.before = clock;
        clock.after = clock.before;
    }

    public synchronized Entry<K, V> get(Object key) {
        Object k;
        Entry[] tab = this.entries;
        int hash = key.hashCode();
        int idx = hash & tab.length - 1;
        Entry<Object, Object> e = tab[idx];
        while (e != null && (e.hash != hash || (k = e.key) != key && !key.equals(k))) {
            e = e.next;
        }
        if (e != null) {
            e.status |= 3;
            return e;
        }
        tab[idx] = e = new Entry<Object, Object>(hash, key, null, tab[idx]);
        return e;
    }

    protected void onEvict(Entry<K, V> entry) {
    }

    private int indexFor(int hashCode) {
        return hashCode & this.size - 1;
    }

    public static class Entry<K, V> {
        K key;
        V value;
        int hash;
        int status;
        static final int ACCESS_BIT = 1;
        static final int HOT_BIT = 2;
        Entry<K, V> before;
        Entry<K, V> after;
        Entry<K, V> next;

        public Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public K key() {
            return this.key;
        }

        public V value() {
            return this.value;
        }

        public V value(V newValue) {
            V old = this.value;
            this.value = newValue;
            return old;
        }
    }
}

