/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.boot.ExitCodeExceptionMapper;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.util.Assert;

class ExitCodeGenerators
implements Iterable<ExitCodeGenerator> {
    private List<ExitCodeGenerator> generators = new ArrayList<ExitCodeGenerator>();

    ExitCodeGenerators() {
    }

    public void addAll(Throwable exception, ExitCodeExceptionMapper ... mappers) {
        Assert.notNull(exception, "Exception must not be null");
        Assert.notNull(mappers, "Mappers must not be null");
        this.addAll(exception, Arrays.asList(mappers));
    }

    public void addAll(Throwable exception, Iterable<? extends ExitCodeExceptionMapper> mappers) {
        Assert.notNull(exception, "Exception must not be null");
        Assert.notNull(mappers, "Mappers must not be null");
        for (ExitCodeExceptionMapper exitCodeExceptionMapper : mappers) {
            this.add(exception, exitCodeExceptionMapper);
        }
    }

    public void add(Throwable exception, ExitCodeExceptionMapper mapper) {
        Assert.notNull(exception, "Exception must not be null");
        Assert.notNull(mapper, "Mapper must not be null");
        this.add(new MappedExitCodeGenerator(exception, mapper));
    }

    public void addAll(ExitCodeGenerator ... generators) {
        Assert.notNull(generators, "Generators must not be null");
        this.addAll(Arrays.asList(generators));
    }

    public void addAll(Iterable<? extends ExitCodeGenerator> generators) {
        Assert.notNull(generators, "Generators must not be null");
        for (ExitCodeGenerator exitCodeGenerator : generators) {
            this.add(exitCodeGenerator);
        }
    }

    public void add(ExitCodeGenerator generator) {
        Assert.notNull(generator, "Generator must not be null");
        this.generators.add(generator);
    }

    @Override
    public Iterator<ExitCodeGenerator> iterator() {
        return this.generators.iterator();
    }

    public int getExitCode() {
        int exitCode = 0;
        for (ExitCodeGenerator generator : this.generators) {
            try {
                int value = generator.getExitCode();
                if ((value <= 0 || value <= exitCode) && (value >= 0 || value >= exitCode)) continue;
                exitCode = value;
            }
            catch (Exception ex) {
                exitCode = exitCode != 0 ? exitCode : 1;
                ex.printStackTrace();
            }
        }
        return exitCode;
    }

    private static class MappedExitCodeGenerator
    implements ExitCodeGenerator {
        private final Throwable exception;
        private final ExitCodeExceptionMapper mapper;

        MappedExitCodeGenerator(Throwable exception, ExitCodeExceptionMapper mapper) {
            this.exception = exception;
            this.mapper = mapper;
        }

        @Override
        public int getExitCode() {
            return this.mapper.getExitCode(this.exception);
        }
    }
}

