/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.bind.YamlJavaBeanPropertyConstructor;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlConfigurationFactory<T>
implements FactoryBean<T>,
MessageSourceAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(YamlConfigurationFactory.class);
    private final Class<?> type;
    private boolean exceptionIfInvalid;
    private String yaml;
    private Resource resource;
    private T configuration;
    private Validator validator;
    private MessageSource messageSource;
    private Map<Class<?>, Map<String, String>> propertyAliases = Collections.emptyMap();

    public YamlConfigurationFactory(Class<?> type) {
        Assert.notNull(type, "type must not be null");
        this.type = type;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setPropertyAliases(Map<Class<?>, Map<String, String>> propertyAliases) {
        this.propertyAliases = new HashMap(propertyAliases);
    }

    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Deprecated
    public void setExceptionIfInvalid(boolean exceptionIfInvalid) {
        this.exceptionIfInvalid = exceptionIfInvalid;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.yaml == null) {
            Assert.state(this.resource != null, "Resource should not be null");
            this.yaml = StreamUtils.copyToString(this.resource.getInputStream(), Charset.defaultCharset());
        }
        Assert.state(this.yaml != null, "Yaml document should not be null: either set it directly or set the resource to load it from");
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Yaml document is %n%s", this.yaml));
            }
            YamlJavaBeanPropertyConstructor constructor = new YamlJavaBeanPropertyConstructor(this.type, this.propertyAliases);
            this.configuration = new Yaml((BaseConstructor)constructor).load(this.yaml);
            if (this.validator != null) {
                this.validate();
            }
        }
        catch (YAMLException ex) {
            if (this.exceptionIfInvalid) {
                throw ex;
            }
            logger.error("Failed to load YAML validation bean. Your YAML file may be invalid.", ex);
        }
    }

    private void validate() throws BindException {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(this.configuration, "configuration");
        this.validator.validate(this.configuration, errors);
        if (errors.hasErrors()) {
            logger.error("YAML configuration failed validation");
            for (ObjectError error : errors.getAllErrors()) {
                logger.error(this.getErrorMessage(error));
            }
            if (this.exceptionIfInvalid) {
                BindException summary = new BindException(errors);
                throw summary;
            }
        }
    }

    private Object getErrorMessage(ObjectError error) {
        if (this.messageSource != null) {
            Locale locale = Locale.getDefault();
            return this.messageSource.getMessage(error, locale) + " (" + error + ")";
        }
        return error;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.configuration == null) {
            return Object.class;
        }
        return this.configuration.getClass();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public T getObject() throws Exception {
        if (this.configuration == null) {
            this.afterPropertiesSet();
        }
        return this.configuration;
    }
}

