/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.tomcat.ConnectorStartFailedException;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedWebappClassLoader;
import org.springframework.util.Assert;

public class TomcatEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(TomcatEmbeddedServletContainer.class);
    private static final AtomicInteger containerCounter = new AtomicInteger(-1);
    private final Object monitor = new Object();
    private final Map<Service, Connector[]> serviceConnectors = new HashMap<Service, Connector[]>();
    private final Tomcat tomcat;
    private final boolean autoStart;
    private volatile boolean started;

    public TomcatEmbeddedServletContainer(Tomcat tomcat) {
        this(tomcat, true);
    }

    public TomcatEmbeddedServletContainer(Tomcat tomcat, boolean autoStart) {
        Assert.notNull(tomcat, "Tomcat Server must not be null");
        this.tomcat = tomcat;
        this.autoStart = autoStart;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws EmbeddedServletContainerException {
        logger.info("Tomcat initialized with port(s): " + this.getPortsDescription(false));
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.addInstanceIdToEngineName();
                try {
                    final Context context = this.findContext();
                    context.addLifecycleListener(new LifecycleListener(){

                        public void lifecycleEvent(LifecycleEvent event) {
                            if (context.equals(event.getSource()) && "start".equals(event.getType())) {
                                TomcatEmbeddedServletContainer.this.removeServiceConnectors();
                            }
                        }
                    });
                    this.tomcat.start();
                    this.rethrowDeferredStartupExceptions();
                    try {
                        ContextBindings.bindClassLoader((Object)context, (Object)this.getNamingToken(context), (ClassLoader)this.getClass().getClassLoader());
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                    this.startDaemonAwaitThread();
                }
                catch (Exception ex) {
                    containerCounter.decrementAndGet();
                    throw ex;
                }
            }
            catch (Exception ex) {
                this.stopSilently();
                throw new EmbeddedServletContainerException("Unable to start embedded Tomcat", ex);
            }
        }
    }

    private Context findContext() {
        for (Container child : this.tomcat.getHost().findChildren()) {
            if (!(child instanceof Context)) continue;
            return (Context)child;
        }
        throw new IllegalStateException("The host does not contain a Context");
    }

    private void addInstanceIdToEngineName() {
        int instanceId = containerCounter.incrementAndGet();
        if (instanceId > 0) {
            Engine engine = this.tomcat.getEngine();
            engine.setName(engine.getName() + "-" + instanceId);
        }
    }

    private void removeServiceConnectors() {
        for (Service service : this.tomcat.getServer().findServices()) {
            Connector[] connectors = (Connector[])service.findConnectors().clone();
            this.serviceConnectors.put(service, connectors);
            for (Connector connector : connectors) {
                service.removeConnector(connector);
            }
        }
    }

    private void rethrowDeferredStartupExceptions() throws Exception {
        Container[] children;
        for (Container container : children = this.tomcat.getHost().findChildren()) {
            Exception exception;
            if (container instanceof TomcatEmbeddedContext && (exception = ((TomcatEmbeddedContext)container).getStarter().getStartUpException()) != null) {
                throw exception;
            }
            if (LifecycleState.STARTED.equals((Object)container.getState())) continue;
            throw new IllegalStateException(container + " failed to start");
        }
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread("container-" + containerCounter.get()){

            @Override
            public void run() {
                TomcatEmbeddedServletContainer.this.tomcat.getServer().await();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                this.addPreviouslyRemovedConnectors();
                Connector connector = this.tomcat.getConnector();
                if (connector != null && this.autoStart) {
                    this.performDeferredLoadOnStartup();
                }
                this.checkThatConnectorsHaveStarted();
                this.started = true;
                logger.info("Tomcat started on port(s): " + this.getPortsDescription(true));
            }
            catch (ConnectorStartFailedException ex) {
                this.stopSilently();
                throw ex;
            }
            catch (Exception ex) {
                throw new EmbeddedServletContainerException("Unable to start embedded Tomcat servlet container", ex);
            }
            finally {
                Context context = this.findContext();
                ContextBindings.unbindClassLoader((Object)context, (Object)this.getNamingToken(context), (ClassLoader)this.getClass().getClassLoader());
            }
        }
    }

    private void checkThatConnectorsHaveStarted() {
        for (Connector connector : this.tomcat.getService().findConnectors()) {
            if (!LifecycleState.FAILED.equals((Object)connector.getState())) continue;
            throw new ConnectorStartFailedException(connector.getPort());
        }
    }

    private void stopSilently() {
        try {
            this.stopTomcat();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void stopTomcat() throws LifecycleException {
        if (Thread.currentThread().getContextClassLoader() instanceof TomcatEmbeddedWebappClassLoader) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        this.tomcat.stop();
    }

    private void addPreviouslyRemovedConnectors() {
        Service[] services;
        for (Service service : services = this.tomcat.getServer().findServices()) {
            Connector[] connectors = this.serviceConnectors.get(service);
            if (connectors == null) continue;
            for (Connector connector : connectors) {
                service.addConnector(connector);
                if (this.autoStart) continue;
                this.stopProtocolHandler(connector);
            }
            this.serviceConnectors.remove(service);
        }
    }

    private void stopProtocolHandler(Connector connector) {
        try {
            connector.getProtocolHandler().stop();
        }
        catch (Exception ex) {
            logger.error("Cannot pause connector: ", ex);
        }
    }

    private void performDeferredLoadOnStartup() {
        try {
            for (Container child : this.tomcat.getHost().findChildren()) {
                if (!(child instanceof TomcatEmbeddedContext)) continue;
                ((TomcatEmbeddedContext)child).deferredLoadOnStartup();
            }
        }
        catch (Exception ex) {
            logger.error("Cannot start connector: ", ex);
            throw new EmbeddedServletContainerException("Unable to start embedded Tomcat connectors", ex);
        }
    }

    Map<Service, Connector[]> getServiceConnectors() {
        return this.serviceConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws EmbeddedServletContainerException {
        Object object = this.monitor;
        synchronized (object) {
            boolean wasStarted = this.started;
            try {
                this.started = false;
                try {
                    this.stopTomcat();
                    this.tomcat.destroy();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                throw new EmbeddedServletContainerException("Unable to stop embedded Tomcat", ex);
            }
            finally {
                if (wasStarted) {
                    containerCounter.decrementAndGet();
                }
            }
        }
    }

    private String getPortsDescription(boolean localPort) {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.tomcat.getService().findConnectors()) {
            ports.append(ports.length() != 0 ? " " : "");
            int port = localPort ? connector.getLocalPort() : connector.getPort();
            ports.append(port + " (" + connector.getScheme() + ")");
        }
        return ports.toString();
    }

    @Override
    public int getPort() {
        Connector connector = this.tomcat.getConnector();
        if (connector != null) {
            return connector.getLocalPort();
        }
        return 0;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    private Object getNamingToken(Context context) {
        try {
            return context.getNamingToken();
        }
        catch (NoSuchMethodError ex) {
            return context;
        }
    }
}

