/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.Undertow;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.undertow.CompositeResourceManager;
import org.springframework.boot.context.embedded.undertow.FileSessionPersistence;
import org.springframework.boot.context.embedded.undertow.JarResourceManager;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainer;
import org.springframework.boot.web.servlet.ErrorPage;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private List<UndertowBuilderCustomizer> builderCustomizers = new ArrayList<UndertowBuilderCustomizer>();
    private List<UndertowDeploymentInfoCustomizer> deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>();
    private ResourceLoader resourceLoader;
    private Integer bufferSize;
    private Integer ioThreads;
    private Integer workerThreads;
    private Boolean directBuffers;
    private File accessLogDirectory;
    private String accessLogPattern;
    private String accessLogPrefix;
    private String accessLogSuffix;
    private boolean accessLogEnabled = false;
    private boolean accessLogRotate = true;
    private boolean useForwardHeaders;

    public UndertowEmbeddedServletContainerFactory() {
        this.getJspServlet().setRegistered(false);
    }

    public UndertowEmbeddedServletContainerFactory(int port) {
        super(port);
        this.getJspServlet().setRegistered(false);
    }

    public UndertowEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
        this.getJspServlet().setRegistered(false);
    }

    public void setBuilderCustomizers(Collection<? extends UndertowBuilderCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.builderCustomizers = new ArrayList<UndertowBuilderCustomizer>(customizers);
    }

    public Collection<UndertowBuilderCustomizer> getBuilderCustomizers() {
        return this.builderCustomizers;
    }

    public void addBuilderCustomizers(UndertowBuilderCustomizer ... customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.builderCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setDeploymentInfoCustomizers(Collection<? extends UndertowDeploymentInfoCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>(customizers);
    }

    public Collection<UndertowDeploymentInfoCustomizer> getDeploymentInfoCustomizers() {
        return this.deploymentInfoCustomizers;
    }

    public void addDeploymentInfoCustomizers(UndertowDeploymentInfoCustomizer ... customizers) {
        Assert.notNull(customizers, "UndertowDeploymentInfoCustomizers must not be null");
        this.deploymentInfoCustomizers.addAll(Arrays.asList(customizers));
    }

    @Override
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        DeploymentManager manager = this.createDeploymentManager(initializers);
        int port = this.getPort();
        Undertow.Builder builder = this.createBuilder(port);
        return this.getUndertowEmbeddedServletContainer(builder, manager, port);
    }

    private Undertow.Builder createBuilder(int port) {
        Undertow.Builder builder = Undertow.builder();
        if (this.bufferSize != null) {
            builder.setBufferSize(this.bufferSize.intValue());
        }
        if (this.ioThreads != null) {
            builder.setIoThreads(this.ioThreads.intValue());
        }
        if (this.workerThreads != null) {
            builder.setWorkerThreads(this.workerThreads.intValue());
        }
        if (this.directBuffers != null) {
            builder.setDirectBuffers(this.directBuffers.booleanValue());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.configureSsl(this.getSsl(), port, builder);
        } else {
            builder.addHttpListener(port, this.getListenAddress());
        }
        for (UndertowBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
        return builder;
    }

    private void configureSsl(Ssl ssl, int port, Undertow.Builder builder) {
        try {
            SSLContext sslContext = SSLContext.getInstance(ssl.getProtocol());
            sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
            builder.addHttpsListener(port, this.getListenAddress(), sslContext);
            builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)this.getSslClientAuthMode(ssl));
            if (ssl.getEnabledProtocols() != null) {
                builder.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of((Object[])ssl.getEnabledProtocols()));
            }
            if (ssl.getCiphers() != null) {
                builder.setSocketOption(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of((Object[])ssl.getCiphers()));
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        catch (KeyManagementException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String getListenAddress() {
        if (this.getAddress() == null) {
            return "0.0.0.0";
        }
        return this.getAddress().getHostAddress();
    }

    private SslClientAuthMode getSslClientAuthMode(Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            return SslClientAuthMode.REQUIRED;
        }
        if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            return SslClientAuthMode.REQUESTED;
        }
        return SslClientAuthMode.NOT_REQUESTED;
    }

    private KeyManager[] getKeyManagers() {
        try {
            char[] keyPassword;
            KeyStore keyStore = this.getKeyStore();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            Ssl ssl = this.getSsl();
            char[] cArray = keyPassword = ssl.getKeyPassword() != null ? ssl.getKeyPassword().toCharArray() : null;
            if (keyPassword == null && ssl.getKeyStorePassword() != null) {
                keyPassword = ssl.getKeyStorePassword().toCharArray();
            }
            keyManagerFactory.init(keyStore, keyPassword);
            if (ssl.getKeyAlias() != null) {
                return this.getConfigurableAliasKeyManagers(ssl, keyManagerFactory.getKeyManagers());
            }
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private KeyManager[] getConfigurableAliasKeyManagers(Ssl ssl, KeyManager[] keyManagers) {
        for (int i = 0; i < keyManagers.length; ++i) {
            if (!(keyManagers[i] instanceof X509ExtendedKeyManager)) continue;
            keyManagers[i] = new ConfigurableAliasKeyManager((X509ExtendedKeyManager)keyManagers[i], ssl.getKeyAlias());
        }
        return keyManagers;
    }

    private KeyStore getKeyStore() throws Exception {
        if (this.getSslStoreProvider() != null) {
            return this.getSslStoreProvider().getKeyStore();
        }
        Ssl ssl = this.getSsl();
        return this.loadKeyStore(ssl.getKeyStoreType(), ssl.getKeyStoreProvider(), ssl.getKeyStore(), ssl.getKeyStorePassword());
    }

    private TrustManager[] getTrustManagers() {
        try {
            KeyStore store = this.getTrustStore();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(store);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private KeyStore getTrustStore() throws Exception {
        if (this.getSslStoreProvider() != null) {
            return this.getSslStoreProvider().getTrustStore();
        }
        Ssl ssl = this.getSsl();
        return this.loadKeyStore(ssl.getTrustStoreType(), ssl.getTrustStoreProvider(), ssl.getTrustStore(), ssl.getTrustStorePassword());
    }

    private KeyStore loadKeyStore(String type, String provider, String resource, String password) throws Exception {
        String string = type = type != null ? type : "JKS";
        if (resource == null) {
            return null;
        }
        KeyStore store = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
        URL url = ResourceUtils.getURL(resource);
        store.load(url.openStream(), password != null ? password.toCharArray() : null);
        return store;
    }

    private DeploymentManager createDeploymentManager(ServletContextInitializer ... initializers) {
        DeploymentInfo deployment = Servlets.deployment();
        this.registerServletContainerInitializerToDriveServletContextInitializers(deployment, initializers);
        deployment.setClassLoader(this.getServletClassLoader());
        deployment.setContextPath(this.getContextPath());
        deployment.setDisplayName(this.getDisplayName());
        deployment.setDeploymentName("spring-boot");
        if (this.isRegisterDefaultServlet()) {
            deployment.addServlet(Servlets.servlet((String)"default", DefaultServlet.class));
        }
        this.configureErrorPages(deployment);
        deployment.setServletStackTraces(ServletStackTraces.NONE);
        deployment.setResourceManager(this.getDocumentRootResourceManager());
        this.configureMimeMappings(deployment);
        for (UndertowDeploymentInfoCustomizer customizer : this.deploymentInfoCustomizers) {
            customizer.customize(deployment);
        }
        if (this.isAccessLogEnabled()) {
            this.configureAccessLog(deployment);
        }
        if (this.isPersistSession()) {
            File dir = this.getValidSessionStoreDir();
            deployment.setSessionPersistenceManager((SessionPersistenceManager)new FileSessionPersistence(dir));
        }
        this.addLocaleMappings(deployment);
        DeploymentManager manager = Servlets.newContainer().addDeployment(deployment);
        manager.deploy();
        SessionManager sessionManager = manager.getDeployment().getSessionManager();
        int sessionTimeout = this.getSessionTimeout() > 0 ? this.getSessionTimeout() : -1;
        sessionManager.setDefaultSessionTimeout(sessionTimeout);
        return manager;
    }

    private void configureAccessLog(DeploymentInfo deploymentInfo) {
        try {
            this.createAccessLogDirectoryIfNecessary();
            XnioWorker worker = this.createWorker();
            String prefix = this.accessLogPrefix != null ? this.accessLogPrefix : "access_log.";
            final DefaultAccessLogReceiver accessLogReceiver = new DefaultAccessLogReceiver((Executor)worker, this.accessLogDirectory, prefix, this.accessLogSuffix, this.accessLogRotate);
            AccessLogShutdownListener listener = new AccessLogShutdownListener(worker, accessLogReceiver);
            deploymentInfo.addListener(new ListenerInfo(AccessLogShutdownListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)));
            deploymentInfo.addInitialHandlerChainWrapper(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return UndertowEmbeddedServletContainerFactory.this.createAccessLogHandler(handler, (AccessLogReceiver)accessLogReceiver);
                }
            });
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to create AccessLogHandler", ex);
        }
    }

    private AccessLogHandler createAccessLogHandler(HttpHandler handler, AccessLogReceiver accessLogReceiver) {
        this.createAccessLogDirectoryIfNecessary();
        String formatString = this.accessLogPattern != null ? this.accessLogPattern : "common";
        return new AccessLogHandler(handler, accessLogReceiver, formatString, Undertow.class.getClassLoader());
    }

    private void createAccessLogDirectoryIfNecessary() {
        Assert.state(this.accessLogDirectory != null, "Access log directory is not set");
        if (!this.accessLogDirectory.isDirectory() && !this.accessLogDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create access log directory '" + this.accessLogDirectory + "'");
        }
    }

    private XnioWorker createWorker() throws IOException {
        Xnio xnio = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader());
        return xnio.createWorker(OptionMap.builder().set(Options.THREAD_DAEMON, true).getMap());
    }

    private void addLocaleMappings(DeploymentInfo deployment) {
        for (Map.Entry<Locale, Charset> entry : this.getLocaleCharsetMappings().entrySet()) {
            Locale locale = entry.getKey();
            Charset charset = entry.getValue();
            deployment.addLocaleCharsetMapping(locale.toString(), charset.toString());
        }
    }

    private void registerServletContainerInitializerToDriveServletContextInitializers(DeploymentInfo deployment, ServletContextInitializer ... initializers) {
        ServletContextInitializer[] mergedInitializers = this.mergeInitializers(initializers);
        Initializer initializer = new Initializer(mergedInitializers);
        deployment.addServletContainerInitializer(new ServletContainerInitializerInfo(Initializer.class, (InstanceFactory)new ImmediateInstanceFactory((Object)initializer), NO_CLASSES));
    }

    private ClassLoader getServletClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    private ResourceManager getDocumentRootResourceManager() {
        File root = this.getCanonicalDocumentRoot();
        List<URL> metaInfResourceUrls = this.getUrlsOfJarsWithMetaInfResources();
        ArrayList<URL> resourceJarUrls = new ArrayList<URL>();
        ArrayList<Object> resourceManagers = new ArrayList<Object>();
        Object rootResourceManager = root.isDirectory() ? new FileResourceManager(root, 0L) : new JarResourceManager(root);
        resourceManagers.add(rootResourceManager);
        for (URL url : metaInfResourceUrls) {
            if ("file".equals(url.getProtocol())) {
                try {
                    File file = new File(url.toURI());
                    if (file.isFile()) {
                        resourceJarUrls.add(new URL("jar:" + url + "!/"));
                        continue;
                    }
                    resourceManagers.add(new FileResourceManager(new File(file, "META-INF/resources"), 0L));
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            resourceJarUrls.add(url);
        }
        resourceManagers.add(new MetaInfResourcesResourceManager(resourceJarUrls));
        return new CompositeResourceManager(resourceManagers.toArray(new ResourceManager[resourceManagers.size()]));
    }

    private File getCanonicalDocumentRoot() {
        try {
            File root = this.getValidDocumentRoot();
            root = root != null ? root : this.createTempDir("undertow-docbase");
            return root.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot get canonical document root", ex);
        }
    }

    private void configureErrorPages(DeploymentInfo servletBuilder) {
        for (ErrorPage errorPage : this.getErrorPages()) {
            servletBuilder.addErrorPage(this.getUndertowErrorPage(errorPage));
        }
    }

    private io.undertow.servlet.api.ErrorPage getUndertowErrorPage(ErrorPage errorPage) {
        if (errorPage.getStatus() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getStatusCode());
        }
        if (errorPage.getException() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getException());
        }
        return new io.undertow.servlet.api.ErrorPage(errorPage.getPath());
    }

    private void configureMimeMappings(DeploymentInfo servletBuilder) {
        for (MimeMappings.Mapping mimeMapping : this.getMimeMappings()) {
            servletBuilder.addMimeMapping(new MimeMapping(mimeMapping.getExtension(), mimeMapping.getMimeType()));
        }
    }

    protected UndertowEmbeddedServletContainer getUndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, int port) {
        return new UndertowEmbeddedServletContainer(builder, manager, this.getContextPath(), this.isUseForwardHeaders(), port >= 0, this.getCompression(), this.getServerHeader());
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Deprecated
    public void setBuffersPerRegion(Integer buffersPerRegion) {
    }

    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    public void setWorkerThreads(Integer workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setDirectBuffers(Boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    public void setAccessLogDirectory(File accessLogDirectory) {
        this.accessLogDirectory = accessLogDirectory;
    }

    public void setAccessLogPattern(String accessLogPattern) {
        this.accessLogPattern = accessLogPattern;
    }

    public String getAccessLogPrefix() {
        return this.accessLogPrefix;
    }

    public void setAccessLogPrefix(String accessLogPrefix) {
        this.accessLogPrefix = accessLogPrefix;
    }

    public void setAccessLogSuffix(String accessLogSuffix) {
        this.accessLogSuffix = accessLogSuffix;
    }

    public void setAccessLogEnabled(boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
    }

    public boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    public void setAccessLogRotate(boolean accessLogRotate) {
        this.accessLogRotate = accessLogRotate;
    }

    protected final boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    private static class AccessLogShutdownListener
    implements ServletContextListener {
        private final XnioWorker worker;
        private final DefaultAccessLogReceiver accessLogReceiver;

        AccessLogShutdownListener(XnioWorker worker, DefaultAccessLogReceiver accessLogReceiver) {
            this.worker = worker;
            this.accessLogReceiver = accessLogReceiver;
        }

        @Override
        public void contextInitialized(ServletContextEvent sce) {
        }

        @Override
        public void contextDestroyed(ServletContextEvent sce) {
            try {
                this.accessLogReceiver.close();
                this.worker.shutdown();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static class ConfigurableAliasKeyManager
    extends X509ExtendedKeyManager {
        private final X509ExtendedKeyManager keyManager;
        private final String alias;

        ConfigurableAliasKeyManager(X509ExtendedKeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
            return this.keyManager.chooseEngineClientAlias(strings, principals, sslEngine);
        }

        @Override
        public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
            if (this.alias == null) {
                return this.keyManager.chooseEngineServerAlias(s, principals, sslEngine);
            }
            return this.alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyManager.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.keyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }
    }

    private static class Initializer
    implements ServletContainerInitializer {
        private final ServletContextInitializer[] initializers;

        Initializer(ServletContextInitializer[] initializers) {
            this.initializers = initializers;
        }

        @Override
        public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
            for (ServletContextInitializer initializer : this.initializers) {
                initializer.onStartup(servletContext);
            }
        }
    }

    private static final class MetaInfResourcesResourceManager
    implements ResourceManager {
        private final List<URL> metaInfResourceJarUrls;

        private MetaInfResourcesResourceManager(List<URL> metaInfResourceJarUrls) {
            this.metaInfResourceJarUrls = metaInfResourceJarUrls;
        }

        public void close() throws IOException {
        }

        public Resource getResource(String path) {
            for (URL url : this.metaInfResourceJarUrls) {
                URLResource resource = this.getMetaInfResource(url, path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        public boolean isResourceChangeListenerSupported() {
            return false;
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
        }

        private URLResource getMetaInfResource(URL resourceJar, String path) {
            try {
                URL resourceUrl = new URL(resourceJar + "META-INF/resources" + path);
                URLResource resource = new URLResource(resourceUrl, path);
                if (resource.getContentLength() < 0L) {
                    return null;
                }
                return resource;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
    }
}

