/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument;

import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.qubership.profiler.instrument.enhancement.ClassInfo;
import org.qubership.profiler.instrument.enhancement.FilteredEnhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancingClassVisitor
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(EnhancingClassVisitor.class);
    private final List<FilteredEnhancer> enhancers;
    private final ClassInfo classInfo;

    public EnhancingClassVisitor(ClassVisitor cv, List<FilteredEnhancer> enhancers, ClassInfo classInfo) {
        super(589824, cv);
        this.enhancers = enhancers;
        this.classInfo = classInfo;
    }

    public void visitEnd() {
        log.trace("visitEnd class={}", (Object)this.classInfo.getClassName());
        for (FilteredEnhancer filter : this.enhancers) {
            if (filter.getFilter().accept(this.classInfo)) {
                if (log.isTraceEnabled()) {
                    log.trace("Applying enhancer {} to class {}, enhancer loaded in {}", new Object[]{filter, this.classInfo.getClassName(), filter.getFilter().getStackTraceAtCreate()});
                } else {
                    log.debug("Applying enhancer {} to class {}", (Object)filter, (Object)this.classInfo.getClassName());
                }
                filter.enhance(this.cv);
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace("Enhancer {} does not match class {}, enhancer loaded in {}", new Object[]{filter, this.classInfo.getClassName(), filter.getFilter().getStackTraceAtCreate()});
                continue;
            }
            log.debug("Enhancer {} does not match class {}", (Object)filter, (Object)this.classInfo.getClassName());
        }
        super.visitEnd();
    }
}

