/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument;

import java.util.Arrays;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.StringUtils;
import org.qubership.profiler.agent.TimerCache;
import org.qubership.profiler.configuration.Rule;
import org.qubership.profiler.instrument.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMethodAdapter
extends AdviceAdapter {
    private static final Logger log = LoggerFactory.getLogger(ProfileMethodAdapter.class);
    private static final Object[] EMPTY_STACK = new Object[0];
    private Label startTry = new Label();
    private Label catchThrowable = new Label();
    private final String fullName;
    private final Rule rule;
    private Type[] argumentTypes;
    private Type returnType;
    private final boolean constructor;
    public static final Type C_PROFILER = Type.getType(Profiler.class);
    public static final Method M_ENTER_RETURNING = Method.getMethod((String)(LocalState.class.getName() + " enterReturning(int)"));
    public static final Method M_EVENT = Method.getMethod((String)"void event(Object,String)");
    public static final Method M_EVENT_ID = Method.getMethod((String)"void event(Object,int)");
    public static final Method M_PLUGIN_EXCEPTION = Method.getMethod((String)"void pluginException(Throwable)");
    public static final Method M_EXIT = Method.getMethod((String)"void exit()");
    public static final Type C_OBJECT = Type.getType(Object.class);
    public static final Method M_TO_STRING = Method.getMethod((String)"String toString()");
    public static final Type C_STRINGUTILS = Type.getType(StringUtils.class);
    public static final Method M_CONVERT = Method.getMethod((String)"Object convert(Object)");
    public static final Type C_LOCAL_STATE = Type.getType(LocalState.class);
    public static final Type C_THROWABLE = Type.getType(Throwable.class);
    public static final Type C_TIMER_CACHE = Type.getType(TimerCache.class);
    private final String className;
    private int classVersion;
    private int throwable = -1;
    private int localState;
    private int startTime;
    private int resultVariableNumber = -1;
    private int thisArgIndex;
    private int[] savedLocals;

    public ProfileMethodAdapter(MethodVisitor mv, int access, String className, String name, String desc, String fullName, Rule rule, int classVersion) {
        super(589824, mv, access, name, desc);
        if (rule.shouldNotProfile()) {
            if (log.isTraceEnabled()) {
                log.trace("Transforming method {} with do-not-profile rule loaded in {}", (Object)fullName, (Object)rule.getStackTraceAtCreate());
            } else {
                log.debug("Transforming method {} with do-not-profile rule", (Object)fullName);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Profiling method {} with rule loaded in {}", (Object)fullName, (Object)rule.getStackTraceAtCreate());
        } else {
            log.debug("Profiling method {}", (Object)fullName);
        }
        this.className = className;
        this.fullName = fullName;
        this.rule = rule;
        this.constructor = "<init>".equals(name);
        this.classVersion = classVersion;
    }

    private void doDeclareLocals() {
        if (!this.constructor && !this.rule.shouldNotProfile()) {
            this.localState = this.newLocal(C_LOCAL_STATE);
            this.logEnter(this.fullName);
        }
        this.rule.declareLocals(this);
        if (!this.constructor) {
            this.visitLabel(this.startTry);
        }
    }

    public void visitCode() {
        super.visitCode();
        if (this.constructor) {
            this.doDeclareLocals();
        }
    }

    protected void onMethodEnter() {
        if (!this.constructor) {
            this.doDeclareLocals();
        }
        this.rule.onMethodEnter(this);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.constructor) {
            super.visitMaxs(maxStack, maxLocals);
            return;
        }
        this.visitTryCatchBlock(this.startTry, this.catchThrowable, this.catchThrowable, "java/lang/Throwable");
        this.visitLabel(this.catchThrowable);
        this.visitFrame(-1, 0, null, 1, new Object[]{"java/lang/Throwable"});
        this.throwable = this.newLocal(C_THROWABLE);
        this.storeLocal(this.throwable);
        this.rule.onMethodException(this);
        if (!this.rule.shouldNotProfile()) {
            this.logExit();
        }
        this.loadLocal(this.throwable);
        this.throwException();
        super.visitMaxs(maxStack, maxLocals);
    }

    public int saveArg(int args) {
        int prev;
        int[] savedLocals = this.savedLocals;
        Type[] argumentTypes = this.getArgumentTypes();
        if (savedLocals == null) {
            this.savedLocals = savedLocals = new int[argumentTypes.length];
        }
        if ((prev = savedLocals[args]) == 0) {
            savedLocals[args] = prev = this.newLocal(argumentTypes[args]);
            this.loadArg(args);
            this.storeLocal(prev);
        }
        return prev;
    }

    public Object[] getMethodArgsAsLocals() {
        int isNotStatic = (this.methodAccess & 8) == 0 ? 1 : 0;
        Type[] argTypes = this.getArgumentTypes();
        Object[] locals = new Object[isNotStatic + argTypes.length];
        Arrays.fill(locals, 0, locals.length, Opcodes.TOP);
        if ((this.methodAccess & 8) == 0) {
            locals[0] = this.getClassName();
        }
        int index = isNotStatic;
        int i = 0;
        while (i < argTypes.length) {
            Type type = argTypes[i];
            locals[index] = TypeUtils.typeToFrameType((Type)type);
            ++i;
            ++index;
        }
        return locals;
    }

    protected void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.rule.onMethodExit(this);
            if (!this.constructor && !this.rule.shouldNotProfile()) {
                this.logExit();
            }
        } else if (this.constructor) {
            // empty if block
        }
    }

    public Type[] getArgumentTypes() {
        if (this.argumentTypes != null) {
            return this.argumentTypes;
        }
        this.argumentTypes = Type.getArgumentTypes((String)this.methodDesc);
        return this.argumentTypes;
    }

    public Type getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        this.returnType = Type.getReturnType((String)this.methodDesc);
        return this.returnType;
    }

    public String getMethodFullName() {
        return this.fullName;
    }

    public String getClassName() {
        return this.className;
    }

    public void logEnter(String methodName) {
        this.push(ProfilerData.resolveTag((String)methodName) | 0x1000000);
        this.invokeStatic(C_PROFILER, M_ENTER_RETURNING);
        this.storeLocal(this.localState);
    }

    public void logEvent(String eventName, Type type, boolean convert) {
        if (type.getSort() != 10 || !"java/lang/String".equals(type.getInternalName())) {
            this.invokeStatic(C_STRINGUTILS, M_CONVERT);
        }
        this.push(eventName);
        this.invokeStatic(C_PROFILER, M_EVENT);
    }

    public void logExit() {
        this.loadLocal(this.localState);
        this.invokeVirtual(C_LOCAL_STATE, M_EXIT);
    }

    public void getIntTime() {
        this.getStatic(C_TIMER_CACHE, "timer", Type.INT_TYPE);
    }

    public int getThrowableVariableNumber() {
        return this.throwable;
    }

    public int getLocalStateVariableNumber() {
        return this.localState;
    }

    public int getStartTimeVariableNumber() {
        return this.startTime;
    }

    public void setStartTimeVariableNumber(int startTime) {
        this.startTime = startTime;
    }

    public void declareResultVariable() {
        if (this.resultVariableNumber != -1) {
            return;
        }
        Type returnType = this.getReturnType();
        this.resultVariableNumber = this.newLocal(returnType);
        if (returnType.getSort() == 0) {
            throw new IllegalArgumentException("Unable to get result since method " + this.fullName + " returns VOID");
        }
        TypeUtils.pushDefaultValue((GeneratorAdapter)this, (Type)returnType);
        this.storeLocal(this.resultVariableNumber, returnType);
    }

    public void declareThisVariable() {
        if (this.thisArgIndex != 0) {
            return;
        }
        this.thisArgIndex = this.newLocal(Type.getObjectType((String)this.getClassName()));
        this.loadThis();
        this.storeLocal(this.thisArgIndex);
    }

    public int getSavedThisVariableNumber() {
        if (this.thisArgIndex == 0) {
            throw new IllegalStateException("thisArgIndex is not initialized. #declareThisVariable should be called to initialize it");
        }
        return this.thisArgIndex;
    }

    public void loadSavedThis() {
        this.loadLocal(this.getSavedThisVariableNumber());
    }

    public void stashResult() {
        if (this.resultVariableNumber == -1) {
            throw new IllegalStateException(" resultVariableNumber is not initialized. #declareResultVariable should be called to initialize it");
        }
        Type returnType = this.getReturnType();
        if (returnType.getSize() == 1) {
            this.dup();
        } else {
            this.dup2();
        }
        this.storeLocal(this.resultVariableNumber, returnType);
    }

    public int getResultVariableNumber() {
        if (this.resultVariableNumber == -1) {
            throw new IllegalStateException("resultVariableNumber is not initialized. #declareResultVariable should be called to initialize it");
        }
        return this.resultVariableNumber;
    }

    public int getClassVersion() {
        return this.classVersion;
    }
}

