/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.custom.util;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.qubership.profiler.agent.Configuration_01;
import org.qubership.profiler.instrument.ProfileMethodAdapter;
import org.qubership.profiler.instrument.TypeUtils;
import org.qubership.profiler.instrument.custom.MethodAcceptor;
import org.qubership.profiler.instrument.custom.MethodInstrumenter;
import org.qubership.profiler.instrument.custom.util.ExecuteMethodAfter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class GuardedAction
extends MethodInstrumenter {
    public static final Logger log = LoggerFactory.getLogger(GuardedAction.class);
    private int minTime = Integer.MAX_VALUE;
    boolean exceptionOnly;
    boolean exception;
    protected final MethodAcceptor delegate;

    public GuardedAction(MethodAcceptor delegate) {
        this.delegate = delegate;
    }

    @Override
    public MethodInstrumenter init(Element e, Configuration_01 configuration) {
        super.init(e, configuration);
        String minDuration = e.getAttribute("duration-exceeds");
        if (minDuration.length() == 0) {
            minDuration = e.getAttribute("duration-exeeds");
        }
        if (minDuration.length() > 0) {
            int minTime;
            try {
                minTime = Integer.parseInt(minDuration);
            }
            catch (NumberFormatException exception) {
                log.error("Unable to parse duration-exceeds attribute: {}, assuming 1000 (1 second)", (Object)minDuration, (Object)exception);
                minTime = 1000;
            }
            this.minTime = minTime;
        }
        String exceptionOnlyVal = e.getAttribute("exception-only");
        this.exceptionOnly = Boolean.parseBoolean(exceptionOnlyVal);
        String exceptionVal = e.getAttribute("exception");
        this.exception = Boolean.parseBoolean(exceptionVal);
        if (exceptionOnlyVal.length() == 0 && exceptionVal.length() == 0 && this.minTime != Integer.MAX_VALUE) {
            this.exception = true;
        }
        return this;
    }

    @Override
    public void declareLocals(ProfileMethodAdapter ma) {
        this.delegate.declareLocals(ma);
        if (this.minTime == Integer.MAX_VALUE) {
            return;
        }
        int startTime = ma.newLocal(Type.INT_TYPE);
        ma.setStartTimeVariableNumber(startTime);
        ma.getIntTime();
        ma.storeLocal(startTime);
    }

    private Label verifyExecutionDuration(ProfileMethodAdapter ma) {
        if (this.minTime == Integer.MAX_VALUE) {
            return null;
        }
        ma.getIntTime();
        ma.loadLocal(ma.getStartTimeVariableNumber());
        ma.math(100, Type.INT_TYPE);
        ma.push(this.minTime);
        Label skipExecute = ma.newLabel();
        ma.ifICmp(155, skipExecute);
        return skipExecute;
    }

    @Override
    public void onMethodExit(ProfileMethodAdapter ma) {
        if (this.exceptionOnly) {
            return;
        }
        Label skipExecute = this.verifyExecutionDuration(ma);
        this.delegate.onMethodEnter(ma);
        this.delegate.onMethodExit(ma);
        if (skipExecute != null) {
            ma.visitLabel(skipExecute);
            Type returnType = ma.getReturnType();
            if (returnType == Type.VOID_TYPE) {
                if (this.delegate.getClass() != ExecuteMethodAfter.class || !((ExecuteMethodAfter)this.delegate).shouldAddPlainTryCatchBlocks(ma.getClassVersion())) {
                    ma.visitFrame(-1, 0, null, 0, EMPTY_STACK);
                }
            } else {
                Object[] stack = new Object[]{TypeUtils.typeToFrameType((Type)returnType)};
                ma.visitFrame(-1, 0, null, stack.length, stack);
            }
        }
    }

    @Override
    public void onMethodException(ProfileMethodAdapter ma) {
        if (!this.exception && !this.exceptionOnly) {
            return;
        }
        Label skipExecute = this.verifyExecutionDuration(ma);
        this.delegate.onMethodEnter(ma);
        this.delegate.onMethodException(ma);
        if (skipExecute != null) {
            ma.visitLabel(skipExecute);
            if (this.delegate.getClass() != ExecuteMethodAfter.class || !((ExecuteMethodAfter)this.delegate).shouldAddPlainTryCatchBlocks(ma.getClassVersion())) {
                ma.visitFrame(-1, 0, null, 0, null);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GuardedAction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GuardedAction that = (GuardedAction)o;
        if (this.minTime != that.minTime) {
            return false;
        }
        if (this.exception != that.exception) {
            return false;
        }
        return this.exceptionOnly == that.exceptionOnly;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minTime;
        result = 31 * result + (this.exception ? 1 : 0);
        result = 31 * result + (this.exceptionOnly ? 1 : 0);
        return result;
    }
}

