/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.instrument.custom.util;

import java.util.Objects;
import org.qubership.profiler.agent.Configuration_01;
import org.qubership.profiler.agent.StringUtils;
import org.qubership.profiler.instrument.ProfileMethodAdapter;
import org.qubership.profiler.instrument.custom.MethodAcceptor;
import org.qubership.profiler.instrument.custom.MethodInstrumenter;
import org.qubership.profiler.instrument.custom.util.ExecuteMethodAfter;
import org.qubership.profiler.instrument.custom.util.GuardedAction;
import org.w3c.dom.Element;

public class LogException
extends MethodInstrumenter {
    private MethodAcceptor dumpExceptionDelegate;
    private MethodAcceptor logExceptionDelegate;
    private MethodAcceptor callRedDelegate;

    @Override
    public MethodInstrumenter init(Element e, Configuration_01 configuration) {
        boolean callRed;
        String executeMethodSuffix;
        boolean self = Boolean.valueOf(e.getAttribute("self"));
        if (self) {
            executeMethodSuffix = "(java.lang.Throwable this)";
        } else {
            executeMethodSuffix = "";
            e.setAttribute("exception-only", "true");
        }
        e.setAttribute("static", "true");
        e.setAttribute("class", "org.qubership.profiler.agent.ExceptionLogger");
        String dump = e.getAttribute("dump");
        String log = e.getAttribute("log");
        if (!StringUtils.isBlank((CharSequence)dump)) {
            switch (dump) {
                default: {
                    e.setTextContent("dumpExceptionClass" + executeMethodSuffix);
                    break;
                }
                case "message": {
                    e.setTextContent("dumpExceptionWithMessage" + executeMethodSuffix);
                    break;
                }
                case "stacktrace": {
                    e.setTextContent("dumpExceptionWithMessageAndStacktrace" + executeMethodSuffix);
                }
            }
            this.dumpExceptionDelegate = this.newDelegate(e, configuration, self);
        }
        if (!StringUtils.isBlank((CharSequence)log)) {
            switch (log) {
                default: {
                    e.setTextContent("logExceptionClass" + executeMethodSuffix);
                    break;
                }
                case "message": {
                    e.setTextContent("logExceptionWithMessage" + executeMethodSuffix);
                    break;
                }
                case "stacktrace": {
                    e.setTextContent("logExceptionWithMessageAndStacktrace" + executeMethodSuffix);
                }
            }
            this.logExceptionDelegate = this.newDelegate(e, configuration, self);
        }
        if (callRed = Boolean.valueOf(e.getAttribute("call-red")).booleanValue()) {
            e.setTextContent("callRed" + executeMethodSuffix);
            this.callRedDelegate = this.newDelegate(e, configuration, self);
        }
        return super.init(e, configuration);
    }

    private MethodAcceptor newDelegate(Element e, Configuration_01 configuration, boolean self) {
        MethodInstrumenter methodAcceptor = new ExecuteMethodAfter().init(e, configuration);
        if (!self) {
            methodAcceptor = new GuardedAction(methodAcceptor).init(e, configuration);
        }
        return methodAcceptor;
    }

    @Override
    public void declareLocals(ProfileMethodAdapter ma) {
        if (this.dumpExceptionDelegate != null) {
            this.dumpExceptionDelegate.declareLocals(ma);
        }
        if (this.logExceptionDelegate != null) {
            this.logExceptionDelegate.declareLocals(ma);
        }
        if (this.callRedDelegate != null) {
            this.callRedDelegate.declareLocals(ma);
        }
    }

    @Override
    public void onMethodExit(ProfileMethodAdapter ma) {
        if (this.dumpExceptionDelegate != null) {
            this.dumpExceptionDelegate.onMethodExit(ma);
        }
        if (this.logExceptionDelegate != null) {
            this.logExceptionDelegate.onMethodExit(ma);
        }
        if (this.callRedDelegate != null) {
            this.callRedDelegate.onMethodExit(ma);
        }
    }

    @Override
    public void onMethodException(ProfileMethodAdapter ma) {
        if (this.dumpExceptionDelegate != null) {
            this.dumpExceptionDelegate.onMethodException(ma);
        }
        if (this.logExceptionDelegate != null) {
            this.logExceptionDelegate.onMethodException(ma);
        }
        if (this.callRedDelegate != null) {
            this.callRedDelegate.onMethodException(ma);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogException)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogException that = (LogException)o;
        if (!Objects.equals(this.dumpExceptionDelegate, that.dumpExceptionDelegate)) {
            return false;
        }
        if (!Objects.equals(this.logExceptionDelegate, that.logExceptionDelegate)) {
            return false;
        }
        return Objects.equals(this.callRedDelegate, that.callRedDelegate);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dumpExceptionDelegate != null ? this.dumpExceptionDelegate.hashCode() : 0);
        result = 31 * result + (this.logExceptionDelegate != null ? this.logExceptionDelegate.hashCode() : 0);
        result = 31 * result + (this.callRedDelegate != null ? this.callRedDelegate.hashCode() : 0);
        return result;
    }
}

