/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.ReloadStatusMutable;
import org.qubership.profiler.agent.plugins.ConfigurationSPI;
import org.qubership.profiler.configuration.Rule;
import org.qubership.profiler.instrument.TypeUtils;
import org.qubership.profiler.util.IOHelper;

public class ConfigurationReloader
implements Runnable {
    private static final ESCLogger logger = ESCLogger.getLogger((String)ConfigurationReloader.class.getName());
    private static boolean NEED_REFLECTION_WA = !System.getProperty("java.vendor").startsWith("Oracle") && !System.getProperty("java.vendor").startsWith("Sun");
    private final ConfigurationSPI conf;
    private final ConfigurationSPI newConf;
    private final Set<String> classNames;
    private final Instrumentation inst;
    private final ReloadStatusMutable reloadStatus;
    private final Semaphore reloadingSemaphore;
    private final ArrayList<String> firstReloadedClasses = new ArrayList();

    public ConfigurationReloader(ConfigurationSPI conf, ConfigurationSPI newConf, Set<String> classNames, Instrumentation inst, ReloadStatusMutable reloadStatus, Semaphore reloadingSemaphore) {
        this.conf = conf;
        this.newConf = newConf;
        this.classNames = classNames;
        this.inst = inst;
        this.reloadStatus = reloadStatus;
        this.reloadingSemaphore = reloadingSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ReloadStatusMutable reloadStatus = this.reloadStatus;
        Instrumentation inst = this.inst;
        try {
            reloadStatus.setMessage("Calculating classes to be reloaded");
            ArrayList<Rule> rules = new ArrayList<Rule>();
            ArrayList<Rule> newRules = new ArrayList<Rule>();
            Class[] allClasses = inst.getAllLoadedClasses();
            HashMap<String, Collection<Class>> jarToClasses = new HashMap<String, Collection<Class>>();
            ArrayList<Class> classesWithUnknownSource = new ArrayList<Class>();
            jarToClasses.put(null, classesWithUnknownSource);
            reloadStatus.setTotalCount(allClasses.length);
            int classesToReload = 0;
            Set<String> classNames = this.classNames;
            ConfigurationSPI newConf = this.newConf;
            ConfigurationSPI conf = this.conf;
            int allClassesLength = allClasses.length;
            for (int i1 = 0; i1 < allClassesLength; ++i1) {
                reloadStatus.setSuccessCount(i1);
                Class clazz = allClasses[i1];
                String className = clazz.getName();
                if (className == null || classNames != null && !classNames.contains(className)) continue;
                if (newConf != null) {
                    if (conf == null && clazz.getClassLoader() != null) continue;
                    String nativeClassName = className.replace('.', '/');
                    newConf.getRulesForClass(nativeClassName, newRules);
                    if (conf != null) {
                        conf.getRulesForClass(nativeClassName, rules);
                        if (rules.equals(newRules)) {
                            continue;
                        }
                    } else if (newRules.isEmpty()) continue;
                }
                ++classesToReload;
                String fullJarName = TypeUtils.getFullJarName((ProtectionDomain)clazz.getProtectionDomain());
                ArrayList<Class> classes = (ArrayList<Class>)jarToClasses.get(fullJarName);
                if (classes == null) {
                    classes = new ArrayList<Class>();
                    jarToClasses.put(fullJarName, classes);
                }
                classes.add(clazz);
            }
            this.performReload(jarToClasses, classesWithUnknownSource, classesToReload);
        }
        catch (Throwable t) {
            reloadStatus.setMessage("Error while reloading classes: " + t.getMessage() + ". Please, refer to the profiler.log for the details.");
            logger.log(Level.WARNING, "Error while reloading classes", t);
        }
        finally {
            reloadStatus.setDone(true);
            this.reloadingSemaphore.release();
        }
    }

    private void performReload(Map<String, Collection<Class>> jarToClasses, ArrayList<Class> classesWithUnknownSource, int classesToReload) {
        logger.info("About to reload " + classesToReload + " classes in " + jarToClasses.size() + " different locations");
        if (NEED_REFLECTION_WA) {
            logger.info("Will call clazz.getMethods() for each class before reload to workaround issue https://github.com/eclipse/openj9/issues/1950");
        }
        ReloadStatusMutable reloadStatus = this.reloadStatus;
        reloadStatus.setMessage("Reloading");
        reloadStatus.setSuccessCount(0);
        reloadStatus.setErrorCount(0);
        reloadStatus.setTotalCount(classesToReload);
        for (Map.Entry<String, Collection<Class>> entry : jarToClasses.entrySet()) {
            int successCount;
            String jarLocation = entry.getKey();
            if (jarLocation != null) {
                reloadStatus.setMessage("Processing " + jarLocation);
                File location = new File(jarLocation);
                if (!location.exists()) {
                    classesWithUnknownSource.addAll(entry.getValue());
                    continue;
                }
                logger.info("About to process " + entry.getValue().size() + " classes from " + location.getAbsolutePath());
                if (location.isFile()) {
                    this.reloadClassesFromJar(classesWithUnknownSource, entry, location);
                    continue;
                }
                if (location.isDirectory()) {
                    this.reloadClassesFromDirectory(classesWithUnknownSource, entry, location);
                    continue;
                }
                classesWithUnknownSource.addAll(entry.getValue());
            }
            if ((successCount = reloadStatus.getSuccessCount()) % 50 != 0 || successCount <= 0) continue;
            logger.info("Processed " + successCount + reloadStatus.getErrorCount() + " of " + classesToReload + " classes");
        }
        logger.fine("Processing " + classesWithUnknownSource.size() + " classes with unknown location");
        reloadStatus.setMessage("Processing classes with unknown class file location");
        int classesWithUnknownSourceSize = classesWithUnknownSource.size();
        for (int i = 0; i < classesWithUnknownSourceSize; ++i) {
            InputStream is;
            Class clazz = classesWithUnknownSource.get(i);
            String originalClassName = clazz.getName();
            String nativeClassName = originalClassName.replace('.', '/');
            URL resource = clazz.getResource("/" + nativeClassName + ".class");
            if (resource == null) {
                logger.warning("Unable to find class file for " + originalClassName);
                continue;
            }
            try {
                is = resource.openStream();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to find class " + originalClassName + " in classpath", (Throwable)e);
                continue;
            }
            if (is != null) {
                this.reloadClassFromStream(clazz, is, resource.toString());
            } else {
                logger.warning("Unable to find class file for class " + clazz.getName() + " using getResourceAsStream");
                reloadStatus.setErrorCount(reloadStatus.getErrorCount() + 1);
            }
            if (i % 50 != 0 || i <= 0) continue;
            logger.info("Processed " + i + " of " + classesWithUnknownSourceSize + " classes");
            reloadStatus.setMessage("Processed " + originalClassName);
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Reload complete. Reloaded ");
        msg.append(reloadStatus.getSuccessCount()).append(" class");
        if (reloadStatus.getSuccessCount() != 1) {
            msg.append("es");
        }
        if (reloadStatus.getErrorCount() > 0) {
            msg.append(" (").append(reloadStatus.getErrorCount()).append(" more failed to reload). ");
        }
        if (!this.firstReloadedClasses.isEmpty()) {
            msg.append(this.firstReloadedClasses.get(0));
            int firstReloadedClassesSize = this.firstReloadedClasses.size();
            for (int i = 1; i < firstReloadedClassesSize; ++i) {
                msg.append(", ").append(this.firstReloadedClasses.get(i));
            }
        }
        reloadStatus.setMessage(msg.toString());
    }

    private void reloadClassesFromDirectory(ArrayList<Class> classesWithUnknownSource, Map.Entry<String, Collection<Class>> entry, File location) {
        String locationAbsolutePath = location.getAbsolutePath();
        for (Class clazz : entry.getValue()) {
            String nativeClassName = clazz.getName().replace('.', '/');
            FileInputStream is = null;
            try {
                is = new FileInputStream(new File(location, nativeClassName + ".class"));
            }
            catch (FileNotFoundException e) {
                logger.log(Level.WARNING, "Unable to find class " + clazz.getName() + " in folder " + entry.getKey(), (Throwable)e);
            }
            if (is != null && this.reloadClassFromStream(clazz, is, locationAbsolutePath)) continue;
            classesWithUnknownSource.add(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadClassesFromJar(ArrayList<Class> classesWithUnknownSource, Map.Entry<String, Collection<Class>> entry, File location) {
        ZipFile zip;
        String locationAbsolutePath = location.getAbsolutePath();
        if (locationAbsolutePath.endsWith(".class")) {
            for (Class clazz : entry.getValue()) {
                try {
                    FileInputStream is = new FileInputStream(location);
                    if (this.reloadClassFromStream(clazz, is, locationAbsolutePath)) continue;
                    logger.warning("Unable to reload class " + clazz.getName() + " from file {} " + locationAbsolutePath);
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.WARNING, "Unable to open input stream", (Throwable)e);
                }
            }
            return;
        }
        try {
            zip = new ZipFile(location);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to reload classes from  " + locationAbsolutePath, (Throwable)e);
            classesWithUnknownSource.addAll(entry.getValue());
            return;
        }
        try {
            for (Class clazz : entry.getValue()) {
                String nativeClassName = clazz.getName().replace('.', '/');
                ZipEntry ze = zip.getEntry(nativeClassName + ".class");
                InputStream is = null;
                if (ze != null) {
                    try {
                        is = zip.getInputStream(ze);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Unable to open entry " + ze.getName() + " in file " + entry.getKey(), (Throwable)e);
                    }
                }
                if (is != null && this.reloadClassFromStream(clazz, is, locationAbsolutePath)) continue;
                classesWithUnknownSource.add(clazz);
            }
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reloadClassFromStream(Class clazz, InputStream is, String source) {
        ReloadStatusMutable reloadStatus = this.reloadStatus;
        try {
            logger.info("Reloading class " + clazz.getName() + " from " + source);
            if (NEED_REFLECTION_WA) {
                try {
                    clazz.getMethods();
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Problem during preloading methods via reflection for class " + clazz.getName(), t);
                }
            }
            byte[] bytes = IOHelper.readFully((InputStream)is);
            this.inst.redefineClasses(new ClassDefinition(clazz, bytes));
            logger.fine("Successfully reloaded " + clazz.getName());
            if (this.firstReloadedClasses.size() < 20) {
                this.firstReloadedClasses.add(clazz.getName());
            }
            reloadStatus.setSuccessCount(reloadStatus.getSuccessCount() + 1);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to reload class  " + clazz.getName(), t);
            reloadStatus.setErrorCount(reloadStatus.getErrorCount() + 1);
            if (this.firstReloadedClasses.size() < 20) {
                this.firstReloadedClasses.add(clazz.getName() + " - fail");
            }
        }
        finally {
            IOHelper.close((InputStream)is);
        }
        return false;
    }
}

