/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.configuration;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.agent.AggregationParameterDescriptor;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.Configuration;
import org.qubership.profiler.agent.Configuration_01;
import org.qubership.profiler.agent.DefaultMethodImplInfo;
import org.qubership.profiler.agent.EnhancementRegistry;
import org.qubership.profiler.agent.EnhancerRegistryPlugin;
import org.qubership.profiler.agent.FilterOperator;
import org.qubership.profiler.agent.MetricsConfiguration;
import org.qubership.profiler.agent.MetricsDescription;
import org.qubership.profiler.agent.NetworkExportParams;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ProfilerProperty;
import org.qubership.profiler.agent.PropertyFacadeBoot;
import org.qubership.profiler.agent.plugins.ConfigurationSPI;
import org.qubership.profiler.configuration.CallType;
import org.qubership.profiler.configuration.ConfigStackElement;
import org.qubership.profiler.configuration.NetworkExportParamsImpl;
import org.qubership.profiler.configuration.ProfilerPropertyImpl;
import org.qubership.profiler.configuration.Rule;
import org.qubership.profiler.configuration.RuleGroup;
import org.qubership.profiler.configuration.RuleListGroup;
import org.qubership.profiler.configuration.callfilters.FilterOperatorAnd;
import org.qubership.profiler.configuration.callfilters.FilterOperatorClassMethod;
import org.qubership.profiler.configuration.callfilters.FilterOperatorLogical;
import org.qubership.profiler.configuration.callfilters.FilterOperatorNot;
import org.qubership.profiler.configuration.callfilters.FilterOperatorOr;
import org.qubership.profiler.configuration.callfilters.metrics.FilterOperatorCpu;
import org.qubership.profiler.configuration.callfilters.metrics.FilterOperatorDiskIO;
import org.qubership.profiler.configuration.callfilters.metrics.FilterOperatorDuration;
import org.qubership.profiler.configuration.callfilters.metrics.FilterOperatorMemory;
import org.qubership.profiler.configuration.callfilters.metrics.FilterOperatorNetworkIO;
import org.qubership.profiler.configuration.callfilters.metrics.FilterOperatorQueueWaitTime;
import org.qubership.profiler.configuration.callfilters.metrics.FilterOperatorTransactions;
import org.qubership.profiler.configuration.callfilters.metrics.condition.EqCondition;
import org.qubership.profiler.configuration.callfilters.metrics.condition.GtCondition;
import org.qubership.profiler.configuration.callfilters.metrics.condition.GtOrEqCondition;
import org.qubership.profiler.configuration.callfilters.metrics.condition.LtCondition;
import org.qubership.profiler.configuration.callfilters.metrics.condition.LtOrEqCondition;
import org.qubership.profiler.configuration.callfilters.metrics.condition.MathCondition;
import org.qubership.profiler.configuration.callfilters.params.FilterOperatorContains;
import org.qubership.profiler.configuration.callfilters.params.FilterOperatorEndsWith;
import org.qubership.profiler.configuration.callfilters.params.FilterOperatorExact;
import org.qubership.profiler.configuration.callfilters.params.FilterOperatorStartsWith;
import org.qubership.profiler.dump.DumpRootResolver;
import org.qubership.profiler.instrument.custom.MethodAcceptor;
import org.qubership.profiler.instrument.custom.MethodAcceptorsList;
import org.qubership.profiler.instrument.custom.MethodInstrumenter;
import org.qubership.profiler.instrument.custom.util.ExecuteMethodAfter;
import org.qubership.profiler.instrument.custom.util.ExecuteMethodBefore;
import org.qubership.profiler.instrument.custom.util.ExecuteMethodInstead;
import org.qubership.profiler.instrument.custom.util.GuardedAction;
import org.qubership.profiler.instrument.custom.util.LogException;
import org.qubership.profiler.instrument.custom.util.LogParameter;
import org.qubership.profiler.instrument.custom.util.LogReturn;
import org.qubership.profiler.instrument.custom.util.LogThis;
import org.qubership.profiler.instrument.enhancement.EnhancementRegistryImpl;
import org.qubership.profiler.instrument.enhancement.EnhancerPlugin;
import org.qubership.profiler.io.DurationParser;
import org.qubership.profiler.io.SizeParser;
import org.qubership.profiler.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationImpl
implements ConfigurationSPI {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationImpl.class);
    private static final Pattern FILTER_XML = Pattern.compile("_config.filters.(\\w+).xml");
    private final Map<String, EnhancerPlugin> enhancerPlugins;
    final List<RuleGroup> rules = new ArrayList<RuleGroup>();
    final Set<String> includedFiles = new HashSet<String>();
    final Stack<File> includeStack = new Stack();
    private ConfigStackElement currentStack;
    String storeTransformedClassesPath;
    private boolean verifyClasses;
    private Map<String, ParameterInfo> paramInfo = new HashMap<String, ParameterInfo>();
    private Set<String> enhancers = new HashSet<String>();
    private Map<String, List<DefaultMethodImplInfo>> defaultMethods = new HashMap<String, List<DefaultMethodImplInfo>>();
    private EnhancementRegistry enhancements = new EnhancementRegistryImpl();
    private long maxAge = 691200000L;
    private long maxSize = 0x80000000L;
    private final String configFile;
    private NetworkExportParams networkExportParams;
    private Map<String, ProfilerProperty> properties = new HashMap<String, ProfilerProperty>();
    private final List<MetricsConfiguration> metrics = new ArrayList<MetricsConfiguration>();
    private final List<MetricsDescription> systemMetrics = new ArrayList<MetricsDescription>();

    public ConfigurationImpl(String configFile) throws ParserConfigurationException, IOException, SAXException {
        this.getParameterInfo("common.started");
        this.getParameterInfo("java.thread");
        this.enhancerPlugins = ((EnhancerRegistryPlugin)Bootstrap.getPlugin(EnhancerRegistryPlugin.class)).getEnhancersMap();
        this.configFile = configFile;
        this.parseFile(configFile);
        String verifyClassesProp = PropertyFacadeBoot.getProperty((String)(Profiler.class.getName() + ".verify-classes"), null);
        if (verifyClassesProp != null) {
            this.verifyClasses = Boolean.parseBoolean(verifyClassesProp);
            log.debug("Overriding verify classes property with {}", (Object)this.verifyClasses);
        }
        this.includedFiles.clear();
        this.includeStack.clear();
        Bootstrap.registerPlugin(Configuration.class, (Object)this);
    }

    private void parseFile(String configFile) throws ParserConfigurationException, IOException, SAXException {
        this.parseFile(new File(configFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file) throws ParserConfigurationException, IOException, SAXException {
        File realFile2;
        String overrideFileName;
        log.debug("Loading configuration from {}", (Object)file.getAbsolutePath());
        String fileName = file.getName();
        if ("super".equalsIgnoreCase(fileName)) {
            File lastIncluded = this.includeStack.peek();
            overrideFileName = lastIncluded.getName();
            if (!overrideFileName.contains(".override")) {
                log.warn("Unable to include 'super' file for {} since its name does not contain '.override'", (Object)lastIncluded.getAbsolutePath());
                return;
            }
            overrideFileName = overrideFileName.replace(".override", "");
        } else {
            int lastDot = fileName.lastIndexOf(46);
            overrideFileName = lastDot >= 0 ? fileName.substring(0, lastDot) + ".override" + fileName.substring(lastDot) : fileName + ".override";
        }
        File realFile = new File(file.getParentFile(), overrideFileName);
        if (realFile.exists()) {
            file = realFile;
        } else if (!this.includeStack.isEmpty() && (realFile2 = new File(((File)this.includeStack.get(0)).getParentFile(), overrideFileName)).exists()) {
            log.debug("Found override for {} in {}. Please put into {}", new Object[]{file.getAbsolutePath(), realFile2.getAbsolutePath(), realFile.getAbsolutePath()});
            file = realFile2;
        }
        Matcher m = FILTER_XML.matcher(file.getName());
        if (m.matches() && !this.includeStack.isEmpty()) {
            String dir = m.group(1);
            File realFile22 = new File(((File)this.includeStack.get(0)).getParentFile(), dir);
            if (realFile22.exists()) {
                log.debug("Found override for {} in {}. Please put into {}", new Object[]{file.getAbsolutePath(), realFile22.getAbsolutePath(), realFile.getAbsolutePath()});
                file = realFile22;
            }
        }
        if (!this.includedFiles.add(file.getAbsolutePath())) {
            return;
        }
        log.debug("Parsing {} {}", (Object)(file.isDirectory() ? "directory" : "file"), (Object)file.getAbsolutePath());
        this.includeStack.push(file);
        try {
            if (file.isDirectory()) {
                this.parseDirectory(file);
                return;
            }
            DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = bf.newDocumentBuilder();
            Document doc = db.parse(file);
            this.parseFile(doc.getDocumentElement());
        }
        finally {
            this.includeStack.pop();
        }
    }

    private void parseDirectory(File file) throws IOException, SAXException, ParserConfigurationException {
        File[] files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".xml");
            }
        });
        if (files == null || files.length == 0) {
            log.debug("Directory {} is empty", (Object)file);
            return;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
        for (File configFile : files) {
            this.parseFile(configFile);
        }
    }

    private void parseFile(Element doc) throws IOException, SAXException, ParserConfigurationException {
        int tagPosition = 1;
        String tagName = null;
        ConfigStackElement parentStack = this.currentStack;
        try {
            if (!this.tagIsRequired(doc)) {
                log.debug("Ignoring file " + this.includeStack.peek().getAbsolutePath() + " since condition did not match");
                return;
            }
            HashMap<String, Integer> tagsCount = new HashMap<String, Integer>();
            for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                tagName = e.getTagName().toLowerCase();
                Integer pos = (Integer)tagsCount.get(tagName);
                if (pos == null) {
                    pos = 1;
                    tagsCount.put(tagName, pos);
                }
                tagPosition = pos;
                if (!this.tagIsRequired(e)) {
                    log.debug("Ignoring tag #" + tagPosition + " (" + tagName + ") in file " + this.includeStack.peek().getAbsolutePath() + " since condition did not match");
                    continue;
                }
                this.currentStack = new ConfigStackElement(tagName, tagPosition, this.includeStack.peek().getName(), parentStack);
                if ("ruleset".equals(tagName)) {
                    this.parseRuleset(e);
                    continue;
                }
                if ("enhancer".equals(tagName)) {
                    this.parseEnhancer(e);
                    continue;
                }
                if ("parameters".equals(tagName)) {
                    this.parseParameters(e);
                    continue;
                }
                if ("log-retention".equals(tagName)) {
                    this.parseRetention(e);
                    continue;
                }
                if ("verify-classes".equals(tagName)) {
                    this.parseVerifyClasses(e);
                    continue;
                }
                if ("store-transformed-classes".equals(tagName)) {
                    String storePath = XMLHelper.getTextContent(node);
                    if (storePath.length() == 0) {
                        storePath = DumpRootResolver.dumpRoot + "/classes";
                    }
                    this.storeTransformedClassesPath = storePath;
                    continue;
                }
                if ("add-default-implementation".equals(tagName)) {
                    this.parseAddDefaultImplementation(e);
                    continue;
                }
                if ("metrics-collection".equals(tagName)) {
                    this.parseMetricsCollection(e);
                    continue;
                }
                if ("call-export".equals(tagName)) {
                    this.parseCallExport(e);
                    continue;
                }
                if (!"properties".equals(tagName)) continue;
                this.parseProperties(e);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unable to parse tag #" + tagPosition + " (" + tagName + ") in file " + this.includeStack.peek().getAbsolutePath(), t);
        }
        finally {
            this.currentStack = parentStack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCallExport(Element callExportXml) {
        NetworkExportParamsImpl exportParams = new NetworkExportParamsImpl();
        exportParams.setIncludedParams(new LinkedList());
        exportParams.setExcludedParams(new LinkedList());
        exportParams.setSystemProperties(new LinkedList());
        ConfigStackElement parentStack = this.currentStack;
        try {
            int position = 0;
            for (Node node = callExportXml.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                String tagName = e.getTagName().toLowerCase();
                this.currentStack = new ConfigStackElement(tagName, ++position, this.includeStack.peek().getName(), parentStack);
                try {
                    if ("host".equals(tagName)) {
                        exportParams.setHost(XMLHelper.getTextContent(e));
                        continue;
                    }
                    if ("port".equals(tagName)) {
                        try {
                            exportParams.setPort(Integer.parseInt(XMLHelper.getTextContent(e)));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("socket-timeout".equals(tagName)) {
                        try {
                            exportParams.setSocketTimeout(Integer.parseInt(XMLHelper.getTextContent(e)));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("include-params".equals(tagName)) {
                        this.parseCallExportIncludeParams(e, (NetworkExportParams)exportParams);
                        continue;
                    }
                    if ("exclude-params".equals(tagName)) {
                        this.parseCallExportExcludeParams(e, (NetworkExportParams)exportParams);
                        continue;
                    }
                    if ("system-properties".equals(tagName)) {
                        this.parseCallExportSystemProperties(e, (NetworkExportParams)exportParams);
                        continue;
                    }
                    if (!"filters".equals(tagName)) continue;
                    this.parseCallFilter(e, (FilterOperatorLogical)exportParams.getFilter());
                    continue;
                }
                catch (Throwable t) {
                    int lastWs;
                    StringWriter buffer = new StringWriter(200);
                    buffer.write("Unable to parse callExport");
                    this.currentStack.toString(buffer.getBuffer());
                    buffer.write(" in ");
                    try {
                        TransformerFactory transFactory = TransformerFactory.newInstance();
                        Transformer transformer = transFactory.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.transform(new DOMSource(callExportXml), new StreamResult(buffer));
                    }
                    catch (Throwable transFactory) {
                        // empty catch block
                    }
                    String text = buffer.toString();
                    for (lastWs = text.length() - 1; lastWs > 0 && Character.isWhitespace(text.charAt(lastWs)); --lastWs) {
                    }
                    if (lastWs > 0) {
                        text = text.substring(0, lastWs + 1);
                    }
                    throw new IllegalArgumentException(text, t);
                }
            }
        }
        finally {
            this.currentStack = parentStack;
        }
        if (StringUtils.isEmpty((String)exportParams.getHost())) {
            log.error("Host is required in {}", (Object)this.currentStack);
            return;
        }
        if (exportParams.getPort() == 0) {
            log.error("Port is required in {}", (Object)this.currentStack);
            return;
        }
        this.networkExportParams = exportParams;
    }

    private void parseCallExportIncludeParams(Element e, NetworkExportParams exportParams) {
        ConfigStackElement parentStack = this.currentStack;
        NodeList includeParams = e.getElementsByTagName("include-param");
        for (int i = 0; i < includeParams.getLength(); ++i) {
            Node includeParam = includeParams.item(i);
            try {
                if (!(includeParam instanceof Element)) continue;
                this.currentStack = new ConfigStackElement("include-params", i + 1, this.includeStack.peek().getName(), parentStack);
                String content = XMLHelper.getTextContent(includeParam);
                if (StringUtils.isNotEmpty((String)content)) {
                    exportParams.getIncludedParams().add(content);
                    continue;
                }
                log.error("Ignoring tag {} since condition did not match", (Object)this.currentStack);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse include-params " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
    }

    private void parseCallExportExcludeParams(Element e, NetworkExportParams exportParams) {
        ConfigStackElement parentStack = this.currentStack;
        NodeList excludeParams = e.getElementsByTagName("exclude-param");
        for (int i = 0; i < excludeParams.getLength(); ++i) {
            Node excludeParam = excludeParams.item(i);
            try {
                if (!(excludeParam instanceof Element)) continue;
                this.currentStack = new ConfigStackElement("exclude-params", i + 1, this.includeStack.peek().getName(), parentStack);
                String content = XMLHelper.getTextContent(excludeParam);
                if (StringUtils.isNotEmpty((String)content)) {
                    exportParams.getExcludedParams().add(content);
                    continue;
                }
                log.error("Ignoring tag {} since condition did not match", (Object)this.currentStack);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse exclude-params " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
    }

    private void parseCallExportSystemProperties(Element e, NetworkExportParams exportParams) {
        ConfigStackElement parentStack = this.currentStack;
        NodeList properties = e.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            Node property = properties.item(i);
            try {
                if (!(property instanceof Element)) continue;
                this.currentStack = new ConfigStackElement("system-properties", i + 1, this.includeStack.peek().getName(), parentStack);
                String content = XMLHelper.getTextContent(property);
                if (StringUtils.isNotEmpty((String)content)) {
                    exportParams.getSystemProperties().add(content);
                    continue;
                }
                log.error("Ignoring tag {} since condition did not match", (Object)this.currentStack);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse system-properties " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseProperties(Element propertiesXml) {
        ConfigStackElement parentStack = this.currentStack;
        try {
            int position = 0;
            for (Node node = propertiesXml.getFirstChild(); node != null; node = node.getNextSibling()) {
                String curValue;
                String key;
                Element e;
                block15: {
                    if (!(node instanceof Element)) continue;
                    e = (Element)node;
                    String tagName = e.getTagName().toLowerCase();
                    this.currentStack = new ConfigStackElement(tagName, ++position, this.includeStack.peek().getName(), parentStack);
                    try {
                        if (!"property".equals(tagName)) continue;
                        key = e.getAttribute("name");
                        if (!StringUtils.isEmpty((String)key)) break block15;
                        log.error("{} in {}", (Object)"Attribute key is required", (Object)this.currentStack.toString());
                        return;
                    }
                    catch (Throwable t) {
                        int lastWs;
                        StringWriter buffer = new StringWriter(200);
                        buffer.write("Unable to parse properties");
                        this.currentStack.toString(buffer.getBuffer());
                        buffer.write(" in ");
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("indent", "yes");
                            transformer.transform(new DOMSource(propertiesXml), new StreamResult(buffer));
                        }
                        catch (Throwable transFactory) {
                            // empty catch block
                        }
                        String text = buffer.toString();
                        for (lastWs = text.length() - 1; lastWs > 0 && Character.isWhitespace(text.charAt(lastWs)); --lastWs) {
                        }
                        if (lastWs > 0) {
                            text = text.substring(0, lastWs + 1);
                        }
                        throw new IllegalArgumentException(text, t);
                    }
                }
                ProfilerProperty property = this.properties.get(key);
                if (property == null) {
                    property = new ProfilerPropertyImpl();
                }
                if (StringUtils.isEmpty((String)(curValue = e.getAttribute("value")))) {
                    property.addValues(this.parsePropertyValues(e));
                } else {
                    property.addValue(curValue);
                }
                this.properties.put(key, property);
                continue;
            }
        }
        finally {
            this.currentStack = parentStack;
        }
    }

    private List<String> parsePropertyValues(Element property) {
        ConfigStackElement parentStack = this.currentStack;
        ArrayList<String> result = new ArrayList<String>();
        NodeList values = property.getElementsByTagName("value");
        for (int i = 0; i < values.getLength(); ++i) {
            Node value = values.item(i);
            try {
                this.currentStack = new ConfigStackElement("value", i + 1, this.includeStack.peek().getName(), parentStack);
                String valueStr = XMLHelper.getTextContent(value);
                result.add(valueStr);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse value " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
        return result;
    }

    private void parseAddDefaultImplementation(Element element) {
        String skipSuper;
        String ifEnhancer;
        int accessInt;
        String access;
        String methodDescr;
        boolean argsOk = true;
        String className = element.getAttribute("class");
        if (className == null || className.length() == 0) {
            argsOk = false;
            log.warn("Please specify class name (in java native format like java/lang/Throwable) via class attribute for tag {}", (Object)this.currentStack);
        } else if (className.indexOf(47) == -1 && className.indexOf(46) != -1) {
            log.debug("Converting . to / in class name {} of tag {}", (Object)className, (Object)this.currentStack);
            className = className.replace('.', '/');
        }
        String methodName = element.getAttribute("methodName");
        if (methodName == null || methodName.length() == 0) {
            argsOk = false;
            log.warn("Please specify @methodName for tag {}", (Object)this.currentStack);
        }
        if ((methodDescr = element.getAttribute("methodDescr")) == null || methodDescr.length() == 0) {
            argsOk = false;
            log.warn("Please specify @methodDescr descriptor (in java native format like getCause()V ) for tag {}", (Object)this.currentStack);
        }
        if ((access = element.getAttribute("access")) == null || access.length() == 0) {
            accessInt = 1;
        } else {
            try {
                accessInt = Integer.parseInt(access);
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse access attribute {} for tag {}. Will use just 'public'", (Object)access, (Object)this.currentStack);
                accessInt = 1;
            }
        }
        if (!argsOk) {
            return;
        }
        List<DefaultMethodImplInfo> methods = this.defaultMethods.get(className);
        if (methods == null) {
            methods = new ArrayList<DefaultMethodImplInfo>();
            this.defaultMethods.put(className, methods);
        }
        if ((ifEnhancer = element.getAttribute("if-enhancer")).length() == 0) {
            ifEnhancer = null;
        }
        if ((skipSuper = element.getAttribute("skip-super")).length() == 0) {
            skipSuper = "false";
        }
        methods.add(new DefaultMethodImplInfo(className, methodName, methodDescr, ifEnhancer, accessInt, Boolean.valueOf(skipSuper).booleanValue()));
    }

    private boolean tagIsRequired(Element tag) {
        if (!tag.hasAttributes()) {
            return true;
        }
        String property = tag.getAttribute("if");
        if (property != null && property.length() > 0) {
            String value = System.getProperty(property);
            boolean result = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "1".equals(value);
            log.debug("Resulting value for 'if' of property {} with value {} is {}", new Object[]{property, value, result});
            return result;
        }
        property = tag.getAttribute("unless");
        if (property != null && property.length() > 0) {
            String value = System.getProperty(property);
            boolean result = value == null || "false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "n".equalsIgnoreCase(value) || "0".equals(value);
            log.debug("Resulting value for 'unless' of property {} with value {} is {}", new Object[]{property, value, result});
            return result;
        }
        property = tag.getAttribute("if-exists");
        if (property != null && property.length() > 0) {
            boolean result = System.getProperty(property) != null;
            log.debug("Resulting value for 'if-exists' of property {} is {}", (Object)property, (Object)result);
            return result;
        }
        property = tag.getAttribute("unless-exists");
        if (property != null && property.length() > 0) {
            boolean result = System.getProperty(property) == null;
            log.debug("Resulting value for 'unles-exists' of property {} is {}", (Object)property, (Object)result);
            return result;
        }
        return true;
    }

    private void parseEnhancer(Element element) {
        String enhancerName = XMLHelper.getTextContent(element);
        if (enhancerName.length() == 0) {
            log.warn("Please specify enhancer name in file {}", (Object)this.includeStack.peek().getAbsolutePath());
            return;
        }
        if (!this.enhancers.add(enhancerName)) {
            log.debug("Skipping second loading of enhancer {}, the second appearance is in file {}", (Object)enhancerName, (Object)this.includeStack.peek().getAbsolutePath());
            return;
        }
        EnhancerPlugin plugin = this.enhancerPlugins.get(enhancerName);
        if (plugin == null) {
            log.warn("Unable to find enhancer {}", (Object)enhancerName);
            return;
        }
        plugin.init(element, (Configuration_01)this);
        plugin.setStackTraceAtCreate(this.currentStack);
        this.getEnhancementRegistry().addFilter(enhancerName, (Object)plugin);
    }

    private void parseRuleset(Element ruleset) throws IOException, SAXException, ParserConfigurationException {
        ConfigStackElement parentStack = this.currentStack;
        String ifEnhancer = ruleset.getAttribute("if-enhancer");
        if (ifEnhancer.length() == 0) {
            ifEnhancer = null;
        }
        NodeList rules = ruleset.getElementsByTagName("rule");
        for (int i = 0; i < rules.getLength(); ++i) {
            Node rule = rules.item(i);
            try {
                if (!(rule instanceof Element)) continue;
                if (!this.tagIsRequired((Element)rule)) {
                    log.debug("Ignoring ruleset tag #" + i + " in file " + this.includeStack.peek().getAbsolutePath() + " since condition did not match");
                    continue;
                }
                this.currentStack = new ConfigStackElement("rule", i + 1, this.includeStack.peek().getName(), parentStack);
                this.parseRule((Element)rule, ifEnhancer);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse rule " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRule(Element ruleXml, String rulesetIfEnhancer) throws IOException, SAXException, ParserConfigurationException {
        String src = ruleXml.getAttribute("src");
        if (src.length() > 0) {
            this.parseFile(new File(this.includeStack.peek().getParent(), src));
            return;
        }
        Rule rule = new Rule();
        rule.setStackTraceAtCreate(this.currentStack);
        String ifEnhancer = ruleXml.getAttribute("if-enhancer");
        if (ifEnhancer.length() == 0) {
            ifEnhancer = rulesetIfEnhancer;
        }
        rule.setIfEnhancer(ifEnhancer);
        ConfigStackElement parentStack = this.currentStack;
        try {
            int position = 0;
            for (Node node = ruleXml.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                String tagName = e.getTagName().toLowerCase();
                this.currentStack = new ConfigStackElement(tagName, ++position, this.includeStack.peek().getName(), parentStack);
                if (!this.tagIsRequired(e)) {
                    log.debug("Ignoring tag {} since condition did not match", (Object)this.currentStack);
                    continue;
                }
                String content = XMLHelper.getTextContent(e);
                try {
                    if (content == null) {
                        content = "";
                    }
                    if ("class".equals(tagName)) {
                        rule.addClass(content);
                        continue;
                    }
                    if ("extends".equals(tagName) || "implements".equals(tagName)) {
                        rule.addSuperclass(content);
                        continue;
                    }
                    if ("method".equals(tagName)) {
                        rule.addIncludedMethod(content);
                        continue;
                    }
                    if ("start-endpoint".equals(tagName)) {
                        rule.turnStartEndPoint();
                        continue;
                    }
                    if ("reactor-point".equals(tagName)) {
                        rule.turnReactorPoint();
                        continue;
                    }
                    if ("include-method".equals(tagName)) {
                        rule.addIncludedMethod(content);
                        continue;
                    }
                    if ("exclude-method".equals(tagName)) {
                        rule.addExcludedMethod(content);
                        continue;
                    }
                    if ("method-modifier".equals(tagName)) {
                        rule.methodModifier(content);
                        continue;
                    }
                    if ("do-not-profile".equals(tagName)) {
                        rule.doNotProfile();
                        continue;
                    }
                    if ("minimum-method-size".equals(tagName)) {
                        try {
                            rule.setMinimumMethodSize(Integer.parseInt(content));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("minimum-method-lines".equals(tagName)) {
                        try {
                            rule.setMinimumMethodLines(Integer.parseInt(content));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("minimum-method-loops".equals(tagName)) {
                        try {
                            rule.setMinimumMethodBackJumps(Integer.parseInt(content));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("class-modifier".equals(tagName)) {
                        rule.classModifier(content);
                        continue;
                    }
                    MethodInstrumenter mi = this.parseMethodAcceptor(e, tagName, content);
                    if (mi == null) continue;
                    mi.init(e, (Configuration_01)this);
                    rule.addMethodEditor(mi);
                    continue;
                }
                catch (Throwable t) {
                    int lastWs;
                    StringWriter buffer = new StringWriter(200);
                    buffer.write("Unable to parse rule ");
                    this.currentStack.toString(buffer.getBuffer());
                    buffer.write(" in ");
                    try {
                        TransformerFactory transFactory = TransformerFactory.newInstance();
                        Transformer transformer = transFactory.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.transform(new DOMSource(ruleXml), new StreamResult(buffer));
                    }
                    catch (Throwable transFactory) {
                        // empty catch block
                    }
                    String text = buffer.toString();
                    for (lastWs = text.length() - 1; lastWs > 0 && Character.isWhitespace(text.charAt(lastWs)); --lastWs) {
                    }
                    if (lastWs > 0) {
                        text = text.substring(0, lastWs + 1);
                    }
                    throw new IllegalArgumentException(text, t);
                }
            }
        }
        finally {
            this.currentStack = parentStack;
        }
        if (!this.rules.isEmpty()) {
            RuleGroup group = this.rules.get(this.rules.size() - 1);
            if (group.add(rule)) {
                return;
            }
            if (group instanceof RuleListGroup && this.rules.size() > 1 && !rule.getClassNames().isEmpty()) {
                RuleGroup prev;
                boolean canMoveUp = true;
                block15: for (String className : rule.getClassNames()) {
                    List<Rule> rulesForClass = group.getRulesForClass(className);
                    for (Rule ruleForClass : rulesForClass) {
                        if (!ruleForClass.classNameMatches(className)) continue;
                        canMoveUp = false;
                        break block15;
                    }
                }
                if (canMoveUp && (prev = this.rules.get(this.rules.size() - 2)).add(rule)) {
                    return;
                }
            }
        }
        this.rules.add(RuleGroup.of(rule));
    }

    private MethodInstrumenter parseMethodAcceptor(Element e, String tagName, String content) {
        if (tagName.startsWith("execute-")) {
            if (tagName.equals("execute-before") && !e.hasAttribute("exception-only") && !e.hasAttribute("exception")) {
                return new ExecuteMethodBefore();
            }
            if (tagName.equals("execute-instead")) {
                return new ExecuteMethodInstead();
            }
            return new GuardedAction(new ExecuteMethodAfter().init(e, (Configuration_01)this));
        }
        if (tagName.startsWith("log-parameter")) {
            if (!this.parseParamType(e)) {
                return null;
            }
            LogParameter res = new LogParameter();
            if (!tagName.endsWith("-when")) {
                return res;
            }
            return new GuardedAction(((MethodInstrumenter)res).init(e, (Configuration_01)this));
        }
        if (tagName.startsWith("process-argument")) {
            String argument = e.getAttribute("argument");
            if (argument.length() == 0) {
                log.warn("Please, specify 'argument' attribute for tag {}", (Object)this.currentStack);
                return null;
            }
            e.setAttribute("store-result-to-argument", argument);
            return new ExecuteMethodBefore();
        }
        if (tagName.startsWith("log-return")) {
            if (!this.parseParamType(e)) {
                return null;
            }
            LogReturn res = new LogReturn();
            if (!tagName.endsWith("-when")) {
                return res;
            }
            return new GuardedAction(((MethodInstrumenter)res).init(e, (Configuration_01)this));
        }
        if (tagName.startsWith("log-this")) {
            if (!this.parseParamType(e)) {
                return null;
            }
            LogThis res = new LogThis();
            if (!tagName.endsWith("-when")) {
                return res;
            }
            return new GuardedAction(((MethodInstrumenter)res).init(e, (Configuration_01)this));
        }
        if (tagName.startsWith("log-exception")) {
            return new LogException();
        }
        if ("method-editor".equals(tagName)) {
            if (content.length() == 0) {
                log.error("log-after requires class name to be specified in content (without org.qubership.profiler.instrument.custom.impl package)");
                return null;
            }
            try {
                Class<?> aClass = Class.forName("org.qubership.profiler.instrument.custom.impl." + content);
                return (MethodInstrumenter)aClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                log.error("Unable to load custom implementation {}", (Object)content, (Object)ex);
            }
            catch (InstantiationException ex) {
                log.error("Unable to instantiate {}", (Object)content, (Object)ex);
            }
            catch (IllegalAccessException ex) {
                log.error("Unable to instantiate {}", (Object)content, (Object)ex);
            }
            catch (ClassCastException ex) {
                log.error("Unable to instantiate {}", (Object)content, (Object)ex);
            }
        }
        if ("when".equals(tagName)) {
            return new GuardedAction(this.parseActions(e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodAcceptor parseActions(Element root) {
        ConfigStackElement parentStack = this.currentStack;
        MethodInstrumenter result = null;
        MethodAcceptor list = null;
        try {
            int position = 0;
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                ++position;
                Element e = (Element)node;
                String tagName = e.getTagName().toLowerCase();
                String content = XMLHelper.getTextContent(e);
                if (content == null) {
                    content = "";
                }
                this.currentStack = new ConfigStackElement(tagName, position, this.includeStack.peek().getName(), parentStack);
                MethodInstrumenter mi = this.parseMethodAcceptor(e, tagName, content);
                if (mi == null) continue;
                mi.init(e, (Configuration_01)this);
                if (result == null) {
                    result = mi;
                    continue;
                }
                if (list != null) {
                    ((MethodAcceptorsList)list).add(mi);
                    continue;
                }
                list = new MethodAcceptorsList();
                ((MethodAcceptorsList)list).add(result);
                ((MethodAcceptorsList)list).add(mi);
            }
        }
        finally {
            this.currentStack = parentStack;
        }
        return list == null ? result : list;
    }

    private void parseRetention(Element e) {
        String maxSize;
        String maxAge = e.getAttribute("max-age");
        if (maxAge.length() > 0) {
            this.maxAge = DurationParser.parseDuration((String)maxAge, (long)this.maxAge);
        }
        if ((maxSize = e.getAttribute("max-size")).length() > 0) {
            this.maxSize = SizeParser.parseSize((String)maxSize, (long)this.maxSize);
        }
        log.debug("Dumper will erase profiler logs when they are older than {} days or they consume more than {} mb", (Object)((double)this.maxAge / 1000.0 / 3600.0 / 24.0), (Object)(this.maxSize / 1024L / 1024L));
    }

    private void parseVerifyClasses(Element e) {
        String content = XMLHelper.getTextContent(e);
        boolean bl = this.verifyClasses = content == null || content.trim().length() == 0 || Boolean.valueOf(content) != false;
        if (this.verifyClasses) {
            log.debug("Class verification is enabled");
        }
    }

    public boolean isVerifyClassEnabled() {
        return this.verifyClasses;
    }

    private void parseParameters(Element params) {
        for (Node node = params.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element e;
            String tagName;
            if (!(node instanceof Element) || !"parameter".equals(tagName = (e = (Element)node).getTagName().toLowerCase())) continue;
            this.parseParamType(e);
        }
    }

    private boolean parseParamType(Element e) {
        String eventName = e.getAttribute("name");
        if (eventName.length() == 0) {
            log.error("Please, specify name attribute for tag {}", (Object)this.currentStack);
            return false;
        }
        ParameterInfo info = this.getParameterInfo(eventName);
        info.parse(e);
        return true;
    }

    public void setParamType(String eventName, int paramType) {
        ParameterInfo info = this.getParameterInfo(eventName);
        if (paramType != -1) {
            info.paramType(paramType);
        }
    }

    public Map<String, ParameterInfo> getParametersInfo() {
        return this.paramInfo;
    }

    public ParameterInfo getParameterInfo(String name) {
        ParameterInfo info = this.paramInfo.get(name);
        if (info == null) {
            info = new ParameterInfo(name);
            this.paramInfo.put(name, info);
        }
        return info;
    }

    @Override
    public Collection<Rule> getRulesForClass(String className, Collection<Rule> rules) {
        if (className == null) {
            return Collections.emptyList();
        }
        if (rules != null) {
            rules.clear();
        }
        List<RuleGroup> groups = this.rules;
        block0: for (int i = 0; i < groups.size(); ++i) {
            RuleGroup group = groups.get(i);
            List<Rule> ruleList = group.getRulesForClass(className);
            if (ruleList == null) continue;
            boolean needRecheck = group instanceof RuleListGroup;
            for (int j = 0; j < ruleList.size(); ++j) {
                boolean allMethodsMatch;
                Rule rule = ruleList.get(j);
                if (needRecheck && !rule.classNameMatches(className)) continue;
                boolean bl = allMethodsMatch = rule.allMethodsMatch() && !rule.hasSuperclassCriteria();
                if (!allMethodsMatch || !rule.doesNotChangeClass()) {
                    if (rules == null) {
                        rules = new ArrayList<Rule>();
                    }
                    rules.add(rule);
                }
                if (allMethodsMatch && rule.getIfEnhancer() == null) break block0;
            }
        }
        if (rules == null) {
            return Collections.emptyList();
        }
        for (Rule rule : rules) {
            if (rule.doesNotChangeClass()) continue;
            return rules;
        }
        rules.clear();
        return Collections.emptyList();
    }

    private void parseMetricsCollection(Element metricsCollection) {
        log.debug("metrics collection");
        ConfigStackElement parentStack = this.currentStack;
        int outputVersion = ProfilerData.METRICS_OUTPUT_VERSION;
        try {
            outputVersion = Integer.parseInt(metricsCollection.getAttribute("outputVersion"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        NodeList callTypes = metricsCollection.getElementsByTagName("call-type");
        for (int i = 0; i < callTypes.getLength(); ++i) {
            Node callType = callTypes.item(i);
            try {
                if (!(callType instanceof Element)) continue;
                this.currentStack = new ConfigStackElement("call-type", i + 1, this.includeStack.peek().getName(), parentStack);
                log.info("parse call type #{}", (Object)(i + 1));
                this.parseCallType((Element)callType, outputVersion);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse callType " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
        NodeList systemMetrics = metricsCollection.getElementsByTagName("system-metrics");
        for (int i = 0; i < systemMetrics.getLength(); ++i) {
            Node systemMetric = systemMetrics.item(i);
            try {
                if (!(systemMetric instanceof Element)) continue;
                this.currentStack = new ConfigStackElement("system-metrics", i + 1, this.includeStack.peek().getName(), parentStack);
                log.info("parse system metric #{}", (Object)(i + 1));
                this.systemMetrics.addAll(this.parseMetrics((Element)systemMetric));
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse callType " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCallType(Element callTypeXml, int outputVersion) {
        CallType callType = new CallType();
        String name = callTypeXml.getAttribute("name");
        if (StringUtils.isEmpty((String)name)) {
            name = callTypeXml.getAttribute("output-type");
        }
        if (StringUtils.isEmpty((String)name)) {
            log.error("{} in {}", (Object)"Attribute name is required", (Object)this.currentStack.toString());
            return;
        }
        callType.getMetricsConfigurationImpl().setName(name);
        String isCustom = callTypeXml.getAttribute("is-custom");
        callType.getMetricsConfigurationImpl().setIsCustom(isCustom);
        try {
            outputVersion = Integer.parseInt(callTypeXml.getAttribute("outputVersion"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        callType.getMetricsConfigurationImpl().setOutputVersion(outputVersion);
        ConfigStackElement parentStack = this.currentStack;
        try {
            int position = 0;
            for (Node node = callTypeXml.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                String tagName = e.getTagName().toLowerCase();
                this.currentStack = new ConfigStackElement(tagName, ++position, this.includeStack.peek().getName(), parentStack);
                try {
                    if ("matching".equals(tagName)) {
                        this.parseCallTypeMatching(e, callType);
                        continue;
                    }
                    if ("aggregation-params".equals(tagName)) {
                        this.parseCallTypeAggregationParameters(e, callType);
                        continue;
                    }
                    if ("metrics".equals(tagName)) {
                        callType.getMetricsConfigurationImpl().getMetrics().addAll(this.parseMetrics(e));
                        continue;
                    }
                    if (!"filters".equals(tagName)) continue;
                    this.parseCallFilter(e, (FilterOperatorLogical)callType.getMetricsConfigurationImpl().getFilter());
                    continue;
                }
                catch (Throwable t) {
                    int lastWs;
                    StringWriter buffer = new StringWriter(200);
                    buffer.write("Unable to parse callType");
                    this.currentStack.toString(buffer.getBuffer());
                    buffer.write(" in ");
                    try {
                        TransformerFactory transFactory = TransformerFactory.newInstance();
                        Transformer transformer = transFactory.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.transform(new DOMSource(callTypeXml), new StreamResult(buffer));
                    }
                    catch (Throwable transFactory) {
                        // empty catch block
                    }
                    String text = buffer.toString();
                    for (lastWs = text.length() - 1; lastWs > 0 && Character.isWhitespace(text.charAt(lastWs)); --lastWs) {
                    }
                    if (lastWs > 0) {
                        text = text.substring(0, lastWs + 1);
                    }
                    throw new IllegalArgumentException(text, t);
                }
            }
        }
        finally {
            this.currentStack = parentStack;
        }
        if (callType.getMetricsConfigurationImpl().getMetrics().size() != 0 && callType.getMetricsConfigurationImpl().getMatchingClass() != null) {
            this.metrics.add((MetricsConfiguration)callType.getMetricsConfigurationImpl());
        } else if (callType.getMetricsConfigurationImpl().getMetrics().size() == 0) {
            log.error("{} in {}", (Object)"Metrics is required", (Object)this.currentStack.toString());
        } else if (callType.getMetricsConfigurationImpl().getMatchingClass() == null) {
            log.error("{} in {}", (Object)"Matching class is required", (Object)this.currentStack.toString());
        }
    }

    private void parseCallTypeMatching(Element matching, CallType callType) {
        if (StringUtils.isNotEmpty((String)matching.getAttribute("class"))) {
            callType.getMetricsConfigurationImpl().setMatchingClass(matching.getAttribute("class"));
        }
        if (StringUtils.isNotEmpty((String)matching.getAttribute("method"))) {
            callType.getMetricsConfigurationImpl().setMatchingMethod(matching.getAttribute("method"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MetricsDescription> parseMetrics(Element metrics) {
        ConfigStackElement parentStack = this.currentStack;
        try {
            int position = 0;
            ArrayList<MetricsDescription> metricsDescriptions = new ArrayList<MetricsDescription>();
            for (Node node = metrics.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                ++position;
                Element e = (Element)node;
                String tagName = e.getTagName().toLowerCase();
                if ("counts".equals(tagName)) {
                    tagName = "count";
                } else if ("durations".equals(tagName)) {
                    tagName = "duration";
                }
                this.currentStack = new ConfigStackElement(tagName, position, this.includeStack.peek().getName(), parentStack);
                NamedNodeMap attributesMap = e.getAttributes();
                MetricsDescription md = new MetricsDescription(tagName);
                metricsDescriptions.add(md);
                for (int i = 0; i < attributesMap.getLength(); ++i) {
                    Node attr = attributesMap.item(i);
                    md.setParameter(attr.getNodeName(), attr.getNodeValue());
                }
            }
            ArrayList<MetricsDescription> arrayList = metricsDescriptions;
            return arrayList;
        }
        finally {
            this.currentStack = parentStack;
        }
    }

    private void parseCallTypeAggregationParameters(Element params, CallType callType) {
        ConfigStackElement parentStack = this.currentStack;
        NodeList inputParams = params.getElementsByTagName("input-param");
        for (int i = 0; i < inputParams.getLength(); ++i) {
            Node inputParam = inputParams.item(i);
            try {
                if (!(inputParam instanceof Element)) continue;
                this.currentStack = new ConfigStackElement("input-params", i + 1, this.includeStack.peek().getName(), parentStack);
                String parameterName = ((Element)inputParam).getAttribute("name");
                if (StringUtils.isNotEmpty((String)parameterName)) {
                    String parameterDisplayName = ((Element)inputParam).getAttribute("display-name");
                    if (StringUtils.isEmpty((String)parameterDisplayName)) {
                        callType.getMetricsConfigurationImpl().getAggregationParameters().add(new AggregationParameterDescriptor(parameterName));
                        continue;
                    }
                    callType.getMetricsConfigurationImpl().getAggregationParameters().add(new AggregationParameterDescriptor(parameterName, parameterDisplayName));
                    continue;
                }
                log.error("Ignoring tag {} since condition did not match", (Object)this.currentStack);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof IllegalArgumentException && i == 0) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException("Unable to parse input-params " + (i + 1), t);
            }
            finally {
                this.currentStack = parentStack;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCallFilter(Element operator, FilterOperatorLogical filterElement) {
        ConfigStackElement parentStack = this.currentStack;
        try {
            int position = 0;
            for (Node node = operator.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                String tagName = e.getTagName().toLowerCase();
                this.currentStack = new ConfigStackElement(tagName, ++position, this.includeStack.peek().getName(), parentStack);
                try {
                    FilterOperatorAnd child;
                    if ("and".equals(tagName)) {
                        child = new FilterOperatorAnd();
                        filterElement.addChild((FilterOperator)child);
                        this.parseCallFilter(e, (FilterOperatorLogical)child);
                        continue;
                    }
                    if ("or".equals(tagName)) {
                        child = new FilterOperatorOr();
                        filterElement.addChild((FilterOperator)child);
                        this.parseCallFilter(e, (FilterOperatorLogical)child);
                        continue;
                    }
                    if ("not".equals(tagName)) {
                        child = new FilterOperatorNot();
                        filterElement.addChild((FilterOperator)child);
                        this.parseCallFilter(e, (FilterOperatorLogical)child);
                        continue;
                    }
                    this.parseCallFilterCondition(e, filterElement);
                    continue;
                }
                catch (Throwable t) {
                    int lastWs;
                    StringWriter buffer = new StringWriter(200);
                    buffer.write("Unable to parse callType ");
                    this.currentStack.toString(buffer.getBuffer());
                    buffer.write(" in ");
                    try {
                        TransformerFactory transFactory = TransformerFactory.newInstance();
                        Transformer transformer = transFactory.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.transform(new DOMSource(operator), new StreamResult(buffer));
                    }
                    catch (Throwable transFactory) {
                        // empty catch block
                    }
                    String text = buffer.toString();
                    for (lastWs = text.length() - 1; lastWs > 0 && Character.isWhitespace(text.charAt(lastWs)); --lastWs) {
                    }
                    if (lastWs > 0) {
                        text = text.substring(0, lastWs + 1);
                    }
                    throw new IllegalArgumentException(text, t);
                }
            }
        }
        finally {
            this.currentStack = parentStack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCallFilterCondition(Element e, FilterOperatorLogical filterElement) {
        ConfigStackElement parentStack = this.currentStack;
        try {
            String tagName = e.getTagName().toLowerCase();
            this.currentStack = new ConfigStackElement(tagName, 0, this.includeStack.peek().getName(), parentStack);
            if ("input-param".equals(tagName)) {
                this.parseCallParamsFilterCondition(e, filterElement);
            } else if ("matching".equals(tagName)) {
                this.parseCallMatchingFilterCondition(e, filterElement);
            } else {
                this.parseCallMetricsFilterCondition(e, filterElement);
            }
        }
        finally {
            this.currentStack = parentStack;
        }
    }

    private void parseCallParamsFilterCondition(Element e, FilterOperatorLogical filterElement) {
        String name = e.getAttribute("name");
        String exact = e.getAttribute("exact");
        String startsWith = e.getAttribute("startsWith");
        String contains = e.getAttribute("contains");
        String endsWith = e.getAttribute("endsWith");
        boolean noConditions = true;
        if (StringUtils.isEmpty((String)name)) {
            log.error("Ignoring tag {} since condition did not match", (Object)this.currentStack);
            return;
        }
        if (StringUtils.isNotEmpty((String)exact)) {
            filterElement.addChild((FilterOperator)new FilterOperatorExact(name, exact));
            noConditions = false;
        }
        if (StringUtils.isNotEmpty((String)startsWith)) {
            filterElement.addChild((FilterOperator)new FilterOperatorStartsWith(name, startsWith));
            noConditions = false;
        }
        if (StringUtils.isNotEmpty((String)contains)) {
            filterElement.addChild((FilterOperator)new FilterOperatorContains(name, contains));
            noConditions = false;
        }
        if (StringUtils.isNotEmpty((String)endsWith)) {
            filterElement.addChild((FilterOperator)new FilterOperatorEndsWith(name, endsWith));
            noConditions = false;
        }
        if (noConditions) {
            log.error("Ignoring tag {} since condition did not match", (Object)this.currentStack);
        }
    }

    private void parseCallMetricsFilterCondition(Element e, FilterOperatorLogical filterElement) {
        FilterOperatorCpu metricsFilter;
        String tagName;
        switch (tagName = e.getTagName().toLowerCase()) {
            case "cpu": {
                metricsFilter = new FilterOperatorCpu();
                break;
            }
            case "disk-io": {
                metricsFilter = new FilterOperatorDiskIO();
                break;
            }
            case "duration": {
                metricsFilter = new FilterOperatorDuration();
                break;
            }
            case "memory": {
                metricsFilter = new FilterOperatorMemory();
                break;
            }
            case "network-io": {
                metricsFilter = new FilterOperatorNetworkIO();
                break;
            }
            case "queue-wait-time": {
                metricsFilter = new FilterOperatorQueueWaitTime();
                break;
            }
            case "transactions": {
                metricsFilter = new FilterOperatorTransactions();
                break;
            }
            default: {
                return;
            }
        }
        try {
            metricsFilter.setConstraintValue(Long.parseLong(e.getAttribute("value")));
        }
        catch (NumberFormatException nfe) {
            log.error("Ignoring tag {} since mandatory attribute 'value' isn't specified", (Object)this.currentStack);
            return;
        }
        String condition = e.getAttribute("condition");
        if (StringUtils.isEmpty((String)condition)) {
            log.error("Ignoring tag {} since mandatory attribute 'condition' isn't specified", (Object)this.currentStack);
            return;
        }
        switch (condition) {
            case "=": {
                metricsFilter.setCondition((MathCondition)EqCondition.getInstance());
                break;
            }
            case ">": {
                metricsFilter.setCondition((MathCondition)GtCondition.getInstance());
                break;
            }
            case ">=": {
                metricsFilter.setCondition((MathCondition)GtOrEqCondition.getInstance());
                break;
            }
            case "<": {
                metricsFilter.setCondition((MathCondition)LtCondition.getInstance());
                break;
            }
            case "<=": {
                metricsFilter.setCondition((MathCondition)LtOrEqCondition.getInstance());
                break;
            }
            default: {
                log.error("Ignoring tag {} since mandatory attribute 'condition' isn't set to valid value", (Object)this.currentStack);
                return;
            }
        }
        filterElement.addChild((FilterOperator)metricsFilter);
    }

    private void parseCallMatchingFilterCondition(Element e, FilterOperatorLogical filterElement) {
        String className = e.getAttribute("class");
        String methodName = e.getAttribute("method");
        if (StringUtils.isEmpty((String)className)) {
            log.error("Ignoring tag {} since mandatory attribute 'class' isn't specified", (Object)this.currentStack);
            return;
        }
        filterElement.addChild((FilterOperator)new FilterOperatorClassMethod(className, methodName));
    }

    public String getStoreTransformedClassesPath() {
        return this.storeTransformedClassesPath;
    }

    public Map<String, Integer> getParamTypes() {
        return Collections.emptyMap();
    }

    public EnhancementRegistry getEnhancementRegistry() {
        return this.enhancements;
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    public long getLogMaxAge() {
        return this.maxAge;
    }

    public long getLogMaxSize() {
        return this.maxSize;
    }

    public NetworkExportParams getNetworkExportParams() {
        return this.networkExportParams;
    }

    @Override
    public List<DefaultMethodImplInfo> getDefaultMethods(String className) {
        List<DefaultMethodImplInfo> methods = this.defaultMethods.get(className);
        if (methods == null) {
            return Collections.emptyList();
        }
        return methods;
    }

    public void addEnhancerPlugin(String name, Object plugin) {
    }

    public Object getEnhancerPlugin(String name) {
        return null;
    }

    public List<MetricsConfiguration> getMetricsConfig() {
        return this.metrics;
    }

    public List<MetricsDescription> getSystemMetricsConfig() {
        return this.systemMetrics;
    }

    public Map<String, ProfilerProperty> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationImpl that = (ConfigurationImpl)o;
        if (this.verifyClasses != that.verifyClasses) {
            return false;
        }
        if (this.maxAge != that.maxAge) {
            return false;
        }
        if (this.maxSize != that.maxSize) {
            return false;
        }
        if (this.enhancerPlugins != null ? !this.enhancerPlugins.equals(that.enhancerPlugins) : that.enhancerPlugins != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        if (this.includedFiles != null ? !this.includedFiles.equals(that.includedFiles) : that.includedFiles != null) {
            return false;
        }
        if (this.includeStack != null ? !this.includeStack.equals(that.includeStack) : that.includeStack != null) {
            return false;
        }
        if (this.currentStack != null ? !this.currentStack.equals(that.currentStack) : that.currentStack != null) {
            return false;
        }
        if (this.storeTransformedClassesPath != null ? !this.storeTransformedClassesPath.equals(that.storeTransformedClassesPath) : that.storeTransformedClassesPath != null) {
            return false;
        }
        if (this.paramInfo != null ? !this.paramInfo.equals(that.paramInfo) : that.paramInfo != null) {
            return false;
        }
        if (this.enhancers != null ? !this.enhancers.equals(that.enhancers) : that.enhancers != null) {
            return false;
        }
        if (this.defaultMethods != null ? !this.defaultMethods.equals(that.defaultMethods) : that.defaultMethods != null) {
            return false;
        }
        if (this.enhancements != null ? !this.enhancements.equals(that.enhancements) : that.enhancements != null) {
            return false;
        }
        if (this.configFile != null ? !this.configFile.equals(that.configFile) : that.configFile != null) {
            return false;
        }
        if (this.networkExportParams != null ? !this.networkExportParams.equals(that.networkExportParams) : that.networkExportParams != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        return this.systemMetrics != null ? this.systemMetrics.equals(that.systemMetrics) : that.systemMetrics == null;
    }

    public int hashCode() {
        int result = this.enhancerPlugins != null ? this.enhancerPlugins.hashCode() : 0;
        result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
        result = 31 * result + (this.includedFiles != null ? this.includedFiles.hashCode() : 0);
        result = 31 * result + (this.includeStack != null ? this.includeStack.hashCode() : 0);
        result = 31 * result + (this.currentStack != null ? this.currentStack.hashCode() : 0);
        result = 31 * result + (this.storeTransformedClassesPath != null ? this.storeTransformedClassesPath.hashCode() : 0);
        result = 31 * result + (this.verifyClasses ? 1 : 0);
        result = 31 * result + (this.paramInfo != null ? this.paramInfo.hashCode() : 0);
        result = 31 * result + (this.enhancers != null ? this.enhancers.hashCode() : 0);
        result = 31 * result + (this.defaultMethods != null ? this.defaultMethods.hashCode() : 0);
        result = 31 * result + (this.enhancements != null ? this.enhancements.hashCode() : 0);
        result = 31 * result + (int)(this.maxAge ^ this.maxAge >>> 32);
        result = 31 * result + (int)(this.maxSize ^ this.maxSize >>> 32);
        result = 31 * result + (this.configFile != null ? this.configFile.hashCode() : 0);
        result = 31 * result + (this.networkExportParams != null ? this.networkExportParams.hashCode() : 0);
        result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
        result = 31 * result + (this.systemMetrics != null ? this.systemMetrics.hashCode() : 0);
        return result;
    }
}

