/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.instrument;

import com.netcracker.profiler.configuration.Rule;
import com.netcracker.profiler.util.MethodInstrumentationInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.CodeSizeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatherRulesForMethodVisitor
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(GatherRulesForMethodVisitor.class);
    private final Map<String, MethodInstrumentationInfo> selectedRules;
    private final Collection<Rule> rules;
    private final Collection<Rule> methodRules = new ArrayList<Rule>();
    private boolean isInterface = false;
    private String methodName;
    private int methodAccess;
    private int firstLineNumber;
    private int numberOfLines;
    private int numberOfBackJumps;
    HashSet<Label> seenLabels = new HashSet();
    CodeSizeEvaluator codeSize;
    private final MethodVisitor METHOD_END = new MethodVisitor(589824){

        public void visitLineNumber(int line, Label start) {
            if (GatherRulesForMethodVisitor.this.firstLineNumber == 0) {
                GatherRulesForMethodVisitor.this.firstLineNumber = line;
            }
            GatherRulesForMethodVisitor.this.numberOfLines++;
        }

        public void visitLabel(Label label) {
            GatherRulesForMethodVisitor.this.seenLabels.add(label);
        }

        public void visitJumpInsn(int opcode, Label label) {
            if (GatherRulesForMethodVisitor.this.seenLabels.remove(label)) {
                GatherRulesForMethodVisitor.this.numberOfBackJumps++;
            }
        }

        public void visitEnd() {
            CodeSizeEvaluator sizeEvaluator = GatherRulesForMethodVisitor.this.codeSize;
            int codeSize = sizeEvaluator.getMinSize() + sizeEvaluator.getMaxSize() >> 1;
            if (GatherRulesForMethodVisitor.this.numberOfLines == 0) {
                GatherRulesForMethodVisitor.this.numberOfLines = (codeSize + 4) / 8;
            }
            for (Rule rule : GatherRulesForMethodVisitor.this.methodRules) {
                if (!rule.matches(GatherRulesForMethodVisitor.this.methodAccess, GatherRulesForMethodVisitor.this.methodName, codeSize, GatherRulesForMethodVisitor.this.numberOfLines, GatherRulesForMethodVisitor.this.numberOfBackJumps)) continue;
                GatherRulesForMethodVisitor.this.selectedRules.put(GatherRulesForMethodVisitor.this.methodName, new MethodInstrumentationInfo(rule, GatherRulesForMethodVisitor.this.firstLineNumber));
                break;
            }
        }
    };

    public GatherRulesForMethodVisitor(Map<String, MethodInstrumentationInfo> selectedRules, Collection<Rule> rules) {
        super(589824);
        this.selectedRules = selectedRules;
        this.rules = rules;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isInterface = (access & 0x200) > 0;
        this.methodRules.clear();
        if (this.isInterface || superName == null) {
            return;
        }
        if ((access & 7) == 0) {
            access |= 0x80;
        }
        for (Rule rule : this.rules) {
            if (!rule.matches(access, name, superName, interfaces)) continue;
            this.methodRules.add(rule);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x400) > 0 || this.methodRules.isEmpty()) {
            return null;
        }
        if ((access & 7) == 0) {
            access |= 0x80;
        }
        this.firstLineNumber = 0;
        this.numberOfLines = 0;
        this.numberOfBackJumps = 0;
        this.seenLabels.clear();
        this.methodAccess = access;
        this.methodName = name + desc;
        this.codeSize = new CodeSizeEvaluator(this.METHOD_END);
        return this.codeSize;
    }
}

