/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.instrument;

import com.netcracker.profiler.instrument.ProfileMethodAdapter;
import com.netcracker.profiler.instrument.TypeUtils;
import com.netcracker.profiler.util.MethodInstrumentationInfo;
import java.util.HashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileClassAdapter
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(ProfileClassAdapter.class);
    private final String className;
    private String sourceFileName;
    private final HashMap<String, MethodInstrumentationInfo> selectedRules;
    private final String jarName;
    private int classVersion;

    public ProfileClassAdapter(ClassVisitor cv, String className, HashMap<String, MethodInstrumentationInfo> selectedRules, String jarName) {
        super(589824, cv);
        this.className = className;
        this.selectedRules = selectedRules;
        this.jarName = jarName;
        log.debug("Transforming class {}, {} rules match this class name", (Object)className, (Object)selectedRules.size());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classVersion = version & 0xFFFF;
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.sourceFileName = source;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodInstrumentationInfo info = this.selectedRules.get(name + desc);
        Object mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (info != null) {
            String fullName = TypeUtils.getMethodFullname((String)name, (String)desc, (String)this.className, (String)this.sourceFileName, (int)info.firstLineNumber, (String)this.jarName);
            mv = new ProfileMethodAdapter((MethodVisitor)mv, access, this.className, name, desc, fullName, info.rule, this.classVersion);
        }
        return mv;
    }

    public void visitEnd() {
        for (MethodInstrumentationInfo info : this.selectedRules.values()) {
            info.rule.onClassEnd(this, this.className);
        }
        super.visitEnd();
    }

    public int getClassVersion() {
        return this.classVersion;
    }
}

