/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.instrument.custom.impl;

import com.netcracker.profiler.agent.Configuration_01;
import com.netcracker.profiler.agent.EnhancementRegistry;
import com.netcracker.profiler.instrument.ProfileMethodAdapter;
import com.netcracker.profiler.instrument.custom.MethodInstrumenter;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Tomcat10RequestHandler
extends MethodInstrumenter
implements Opcodes {
    public static final Logger log = LoggerFactory.getLogger(Tomcat10RequestHandler.class);
    private static final Type c_StandardEngineValve = Type.getObjectType((String)"org/apache/catalina/core/StandardEngineValve");
    protected static final Method m_dumpRequest = Method.getMethod((String)"void dumpRequest$profiler(jakarta.servlet.ServletRequest)");
    protected static final Method m_afterRequest = Method.getMethod((String)"void afterRequest$profiler(jakarta.servlet.ServletRequest)");

    @Override
    public MethodInstrumenter init(Element e, Configuration_01 configuration) {
        EnhancementRegistry er = configuration.getEnhancementRegistry();
        List def = er.getEnhancers("com/netcracker/profiler/instrument/enhancement/Tomcat10HTTPEnhancer");
        if (def.isEmpty()) {
            log.warn("Looks like http enhancer is not loaded. The profiling of {} would not be performed", (Object)this.getTargetClass().getClassName());
        } else {
            er.addEnhancer(this.getTargetClass().getInternalName(), def.get(0));
        }
        return this;
    }

    public void loadRequestObject(ProfileMethodAdapter ma) {
        ma.loadLocal(ma.saveArg(0));
    }

    protected Type getTargetClass() {
        return c_StandardEngineValve;
    }

    @Override
    public void declareLocals(ProfileMethodAdapter ma) {
        ma.saveArg(0);
    }

    @Override
    public void onMethodEnter(ProfileMethodAdapter ma) {
        this.loadRequestObject(ma);
        ma.invokeStatic(this.getTargetClass(), m_dumpRequest);
    }

    @Override
    public void onMethodExit(ProfileMethodAdapter ma) {
        this.loadRequestObject(ma);
        ma.invokeStatic(this.getTargetClass(), m_afterRequest);
    }

    @Override
    public void onMethodException(ProfileMethodAdapter ma) {
        this.onMethodExit(ma);
    }
}

