/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.agent;

import com.netcracker.profiler.agent.DefaultMethodImplInfo;
import com.netcracker.profiler.agent.EnhancementRegistry;
import com.netcracker.profiler.agent.StaticInitMerger;
import com.netcracker.profiler.agent.StringUtils;
import com.netcracker.profiler.agent.plugins.ConfigurationSPI;
import com.netcracker.profiler.configuration.Rule;
import com.netcracker.profiler.instrument.EnhancingClassVisitor;
import com.netcracker.profiler.instrument.GatherRulesForMethodVisitor;
import com.netcracker.profiler.instrument.ProfileClassAdapter;
import com.netcracker.profiler.instrument.TypeUtils;
import com.netcracker.profiler.instrument.custom.util.DefaultMethodAdder;
import com.netcracker.profiler.instrument.enhancement.ClassInfo;
import com.netcracker.profiler.instrument.enhancement.ClassInfoImpl;
import com.netcracker.profiler.instrument.enhancement.EnhancerPlugin;
import com.netcracker.profiler.util.MethodInstrumentationInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.objectweb.asm.util.CheckClassAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingTransformer
implements ClassFileTransformer {
    private static final Logger log = LoggerFactory.getLogger(ProfilingTransformer.class);
    private volatile ConfigurationSPI conf;

    public ProfilingTransformer(ConfigurationSPI conf) {
        this.conf = conf;
    }

    public ConfigurationSPI getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(ConfigurationSPI conf) {
        this.conf = conf;
    }

    public boolean transformRequired(String className) {
        Collection<Rule> rules = this.conf.getRulesForClass(className, null);
        EnhancementRegistry enhancementRegistry = this.conf.getEnhancementRegistry();
        List enhancers = enhancementRegistry.getEnhancers(className);
        return !rules.isEmpty() || !enhancers.isEmpty();
    }

    @Override
    public byte[] transform(ClassLoader loader, String name, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassWriter cw;
            log.trace("Transformer called for class {}", (Object)name);
            Collection<Rule> rules = this.conf.getRulesForClass(name, null);
            EnhancementRegistry enhancementRegistry = this.conf.getEnhancementRegistry();
            List enhancers = enhancementRegistry.getEnhancers(name);
            List<DefaultMethodImplInfo> defaultMethods = this.conf.getDefaultMethods(name);
            if (rules.isEmpty() && enhancers.isEmpty() && defaultMethods.isEmpty()) {
                return null;
            }
            ClassInfoImpl classInfo = new ClassInfoImpl();
            classInfo.setClassName(name);
            classInfo.setProtectionDomain(protectionDomain);
            Iterator<Rule> it = rules.iterator();
            while (it.hasNext()) {
                Rule rule = it.next();
                String ifEnhancer = rule.getIfEnhancer();
                if (ifEnhancer == null) continue;
                EnhancerPlugin filter = (EnhancerPlugin)enhancementRegistry.getFilter(ifEnhancer);
                if (filter == null) {
                    log.warn("Filter {} is not found. Please check if-enhancer attributes", (Object)ifEnhancer);
                    continue;
                }
                if (filter.accept((ClassInfo)classInfo)) continue;
                log.trace("Skipping rule {} since filter {} does not match class {}", new Object[]{rule, ifEnhancer, classInfo.getClassName()});
                it.remove();
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            HashMap<String, MethodInstrumentationInfo> selectedRules = new HashMap<String, MethodInstrumentationInfo>();
            if (!rules.isEmpty()) {
                GatherRulesForMethodVisitor gatherVisitor = new GatherRulesForMethodVisitor(selectedRules, rules);
                gatherVisitor = ProfilingTransformer.addDefaultMethods(gatherVisitor, defaultMethods, enhancementRegistry, (ClassInfo)classInfo);
                cr.accept((ClassVisitor)gatherVisitor, 4);
            }
            Object cv = cw = new ClassWriter(cr, 1);
            if (!enhancers.isEmpty()) {
                cv = new StaticInitMerger("clinit$merger$profiler", (ClassVisitor)cv);
                log.debug("Class {} will be updated by {} enhancers", (Object)name, (Object)enhancers.size());
                cv = new EnhancingClassVisitor((ClassVisitor)cv, enhancers, (ClassInfo)classInfo);
            }
            if (selectedRules.isEmpty()) {
                log.debug("No profiling rules match class {}", (Object)name);
            } else {
                cv = new ProfileClassAdapter((ClassVisitor)cv, name, selectedRules, TypeUtils.getJarName((ProtectionDomain)protectionDomain));
            }
            cv = ProfilingTransformer.addDefaultMethods((ClassVisitor)cv, defaultMethods, enhancementRegistry, (ClassInfo)classInfo);
            if (!enhancers.isEmpty()) {
                log.debug("Adding serialVersionUID to class {}", (Object)name);
                cv = new SerialVersionUIDAdder((ClassVisitor)cv);
            }
            cr.accept((ClassVisitor)cv, 8);
            byte[] bytes = cw.toByteArray();
            String path = this.conf.getStoreTransformedClassesPath();
            if (path != null) {
                this.storeTransformationResult(name, bytes, path);
                this.storeTransformationResult(name + "$$ESC$$ORIGINAL", classfileBuffer, path);
            }
            if (this.conf.isVerifyClassEnabled()) {
                CheckClassAdapter checker = new CheckClassAdapter(new ClassVisitor(589824){

                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        return new MethodVisitor(589824){};
                    }
                });
                ClassReader reader = new ClassReader(bytes);
                reader.accept((ClassVisitor)checker, 0);
            }
            return bytes;
        }
        catch (RuntimeException e) {
            log.warn("Unable to instrument class {}, {}", (Object)name, (Object)StringUtils.throwableToString((Throwable)e));
            throw e;
        }
    }

    private static ClassVisitor addDefaultMethods(ClassVisitor cv, List<DefaultMethodImplInfo> defaultMethods, EnhancementRegistry enhancementRegistry, ClassInfo classInfo) {
        if (defaultMethods.isEmpty()) {
            return cv;
        }
        for (DefaultMethodImplInfo defaultMethod : defaultMethods) {
            String ifEnhancer = defaultMethod.ifEnhancer;
            if (ifEnhancer != null) {
                EnhancerPlugin filter = (EnhancerPlugin)enhancementRegistry.getFilter(ifEnhancer);
                if (filter == null) {
                    log.warn("Filter {} is not found. Please check if-enhancer attributes", (Object)ifEnhancer);
                } else if (!filter.accept(classInfo)) {
                    log.debug("Skipped adding method {}{} to class {} since filter {} does not match", new Object[]{defaultMethod.methodName, defaultMethod.methodDescr, classInfo.getClassName(), ifEnhancer});
                    continue;
                }
            }
            cv = new DefaultMethodAdder(cv, defaultMethod);
        }
        return cv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTransformationResult(String name, byte[] bytes, String path) {
        File out = new File(path, name + ".class");
        if (!out.toPath().normalize().startsWith(new File(path).toPath())) {
            throw new IllegalArgumentException("Bad class name: " + name);
        }
        log.trace("Storing class {} to {}", (Object)name, (Object)out);
        File parentFile = out.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            log.warn("Unable to create folders for class {}", (Object)name);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(out);
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            log.error("Unable to save class {}", (Object)name, (Object)e);
        }
        catch (IOException e) {
            log.error("Unable to save class {}", (Object)name, (Object)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

