/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.configuration;

import com.netcracker.profiler.configuration.ConfigStackElement;
import com.netcracker.profiler.instrument.ProfileClassAdapter;
import com.netcracker.profiler.instrument.ProfileMethodAdapter;
import com.netcracker.profiler.instrument.custom.ClassAcceptor;
import com.netcracker.profiler.instrument.custom.ClassAcceptorsList;
import com.netcracker.profiler.instrument.custom.MethodAcceptor;
import com.netcracker.profiler.instrument.custom.MethodAcceptorsList;
import com.netcracker.profiler.tools.ListOfRegExps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rule
implements MethodAcceptor {
    private ArrayList<Pattern> classNames;
    private ArrayList<Matcher> classNameMatchers;
    private Boolean classNameHashable;
    private ArrayList<String> classNamesRaw;
    private ArrayList<Pattern> methodNames;
    private ArrayList<Pattern> excludedMethods;
    private ArrayList<Pattern> superClasses;
    private String ifEnhancer;
    private MethodAcceptorsList editors = null;
    private ClassAcceptorsList classEditors = null;
    private int methodModifiers = 0xFFFFFF;
    private int classModifiers = 0xFFFFFF;
    private int minimumMethodSize = 0;
    private int minimumMethodLines = 0;
    private int minimumMethodBackJumps = 0;
    private boolean doNotProfile = false;
    private ConfigStackElement stack;
    public static Pattern METHOD_PATTERN = Pattern.compile("^([^( ]+)\\s*(\\(\\s*([^),]+(?:,[^),]+)*)?\\s*\\)?)?");
    public static Pattern SPECIALS = Pattern.compile("\\*\\*|\\*|\\.|\\$");
    public static Pattern METHOD_NAME_SPECIALS = Pattern.compile("\\*");
    public static final Logger log = LoggerFactory.getLogger(Rule.class);
    public static final Map<String, String> DESCRIPTORS = new HashMap<String, String>();

    public void doNotProfile() {
        this.doNotProfile = true;
    }

    public boolean shouldNotProfile() {
        return this.doNotProfile;
    }

    public boolean doesNotChangeClass() {
        return this.doNotProfile && this.editors == null && this.classEditors == null;
    }

    public boolean allMethodsMatch() {
        return this.minimumMethodSize == 0 && this.minimumMethodLines == 0 && this.minimumMethodBackJumps == 0 && this.methodModifiers == 0xFFFFFF && this.classModifiers == 0xFFFFFF && this.methodNames == null && this.excludedMethods == null;
    }

    public boolean hasSuperclassCriteria() {
        return this.superClasses != null;
    }

    public void setMinimumMethodSize(int minimumMethodSize) {
        this.minimumMethodSize = minimumMethodSize;
    }

    public void setMinimumMethodLines(int minimumMethodLines) {
        this.minimumMethodLines = minimumMethodLines;
    }

    public void setMinimumMethodBackJumps(int minimumMethodBackJumps) {
        this.minimumMethodBackJumps = minimumMethodBackJumps;
    }

    public boolean matches(int access, String className, String superClass, String[] interfaces) {
        if (this.classModifiers != 0xFFFFFF && (access & this.classModifiers) == 0) {
            return false;
        }
        if (this.superClasses == null) {
            return true;
        }
        for (Pattern superClassPattern : this.superClasses) {
            if (!superClassPattern.matcher(superClass).matches()) continue;
            return true;
        }
        if (interfaces != null) {
            for (String _interface : interfaces) {
                for (Pattern superClazz : this.superClasses) {
                    if (!superClazz.matcher(_interface).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean matches(int access, String fullName, int methodCodeSize, int numberOfLines, int numberOfBackJumps) {
        if (this.methodModifiers != 0xFFFFFF && (access & this.methodModifiers) == 0) {
            return false;
        }
        if (methodCodeSize < this.minimumMethodSize) {
            return false;
        }
        if (numberOfLines < this.minimumMethodLines) {
            return false;
        }
        if (numberOfBackJumps < this.minimumMethodBackJumps) {
            return false;
        }
        if (this.excludedMethods != null) {
            for (Pattern methodName : this.excludedMethods) {
                if (!methodName.matcher(fullName).matches()) continue;
                return false;
            }
        }
        if (this.methodNames == null) {
            return true;
        }
        for (Pattern methodName : this.methodNames) {
            if (!methodName.matcher(fullName).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void declareLocals(ProfileMethodAdapter ma) {
        if (this.editors == null) {
            return;
        }
        this.editors.declareLocals(ma);
    }

    @Override
    public void onMethodEnter(ProfileMethodAdapter ma) {
        if (this.editors == null) {
            return;
        }
        this.editors.onMethodEnter(ma);
    }

    @Override
    public void onMethodExit(ProfileMethodAdapter ma) {
        if (this.editors == null) {
            return;
        }
        this.editors.onMethodExit(ma);
    }

    @Override
    public void onMethodException(ProfileMethodAdapter ma) {
        if (this.editors == null) {
            return;
        }
        this.editors.onMethodException(ma);
    }

    public void onClassEnd(ProfileClassAdapter ca, String className) {
        if (this.classEditors == null) {
            return;
        }
        this.classEditors.onClass(ca, className);
    }

    public ArrayList<Pattern> append(ArrayList<Pattern> list, String expr) {
        if (list == null) {
            list = new ArrayList();
        }
        StringBuffer sb = new StringBuffer(expr.length() + 20);
        Rule.argumentPatternToRegexp(sb, expr, false);
        log.debug("Class rule: {}", (Object)sb);
        list.add(Pattern.compile(sb.toString()));
        return list;
    }

    public void addClass(String className) {
        if (!Boolean.FALSE.equals(this.classNameHashable) && className.indexOf(46) > -1 && className.indexOf(42) == -1) {
            this.classNameHashable = true;
            if (this.classNamesRaw == null) {
                this.classNamesRaw = new ArrayList();
            }
            this.classNamesRaw.add(className);
        } else {
            this.classNameHashable = false;
            this.classNamesRaw = null;
        }
        this.classNames = this.append(this.classNames, className);
        if (this.classNameMatchers == null) {
            this.classNameMatchers = new ArrayList();
        }
        this.classNameMatchers.add(this.classNames.get(this.classNames.size() - 1).matcher(""));
    }

    public void setIfEnhancer(String ifEnhancer) {
        this.ifEnhancer = ifEnhancer;
    }

    public String getIfEnhancer() {
        return this.ifEnhancer;
    }

    public static StringBuffer argumentPatternToRegexp(StringBuffer sb, String p, boolean convertAsJavaDescriptor) {
        String simpleType;
        if (p.charAt(0) == '^') {
            sb.append(p, 1, p.length());
            return sb;
        }
        log.debug("Converting pattern {}", (Object)p);
        int isArray = p.indexOf(91);
        if (isArray >= 0) {
            int i = isArray;
            while (i >= 0) {
                sb.append('\\').append('[');
                i = p.indexOf(91, isArray + 1);
            }
            while (Character.isSpaceChar(p.charAt(isArray - 1))) {
                --isArray;
            }
            p = p.substring(0, isArray);
        }
        if ((simpleType = DESCRIPTORS.get(p)) != null) {
            sb.append(simpleType);
            return sb;
        }
        if ("*".equals(p)) {
            if (convertAsJavaDescriptor) {
                sb.append("(?:L[^;]++;|[VBCDFIJSZ])");
            } else {
                sb.append("[^;/]*");
            }
            return sb;
        }
        if (convertAsJavaDescriptor) {
            sb.append('L');
        }
        if (p.indexOf(46) == -1) {
            sb.append("(?:[^;]+/)?");
        }
        Matcher m = SPECIALS.matcher(p);
        while (m.find()) {
            String s = m.group();
            if ("**".equals(s)) {
                s = "[^;]*";
            } else if ("*".equals(s)) {
                s = "[^;/]*";
            } else if (".".equals(s)) {
                s = "/";
            } else if ("$".equals(s)) {
                s = "\\\\\\$";
            }
            m.appendReplacement(sb, s);
        }
        m.appendTail(sb);
        if (convertAsJavaDescriptor) {
            sb.append(';');
        }
        return sb;
    }

    public static StringBuffer methodNamePatternToRegexp(StringBuffer sb, String p) {
        if (p.charAt(0) == '^') {
            sb.append(p);
            return sb;
        }
        log.debug("Converting method name pattern {}", (Object)p);
        Matcher m = METHOD_NAME_SPECIALS.matcher(p);
        while (m.find()) {
            m.appendReplacement(sb, "[^()]*");
        }
        m.appendTail(sb);
        return sb;
    }

    protected ArrayList<Pattern> addMethod(ArrayList<Pattern> r, String methodName) {
        if (r == null) {
            r = new ArrayList();
        }
        if (methodName.charAt(0) != '^') {
            Matcher m = METHOD_PATTERN.matcher(methodName);
            if (!m.matches()) {
                throw new IllegalArgumentException("Unable to parse method name " + methodName);
            }
            StringBuffer sb = new StringBuffer(methodName.length() + 20);
            sb.append("^");
            Rule.methodNamePatternToRegexp(sb, m.group(1));
            sb.append("\\(");
            if (m.group(2) == null) {
                sb.append(".*");
            } else if (m.group(3) != null) {
                for (String p : m.group(3).split("\\s*,\\s*")) {
                    Rule.argumentPatternToRegexp(sb, p, true);
                }
            }
            sb.append("\\).*");
            methodName = sb.toString();
        }
        log.debug("Method rule: {}", (Object)methodName);
        r.add(Pattern.compile(methodName));
        return r;
    }

    public void addIncludedMethod(String methodPattern) {
        this.methodNames = this.addMethod(this.methodNames, methodPattern);
    }

    public void addExcludedMethod(String methodPattern) {
        this.excludedMethods = this.addMethod(this.excludedMethods, methodPattern);
    }

    public void addSuperclass(String superClassName) {
        this.superClasses = this.append(this.superClasses, superClassName);
    }

    public void methodModifier(String modifier) {
        if (this.methodModifiers == 0xFFFFFF) {
            this.methodModifiers = 0;
        }
        if (modifier == null) {
            return;
        }
        if (modifier.contains("public")) {
            this.methodModifiers |= 1;
        }
        if (modifier.contains("protected")) {
            this.methodModifiers |= 4;
        }
        if (modifier.contains("private")) {
            this.methodModifiers |= 2;
        }
        if (modifier.contains("default")) {
            this.methodModifiers |= 0x80;
        }
        if (modifier.contains("package protected")) {
            this.methodModifiers |= 0x80;
        }
        if (modifier.contains("final")) {
            this.methodModifiers |= 0x10;
        }
        if (modifier.contains("static")) {
            this.methodModifiers |= 8;
        }
    }

    public void classModifier(String modifier) {
        if (this.classModifiers == 0xFFFFFF) {
            this.classModifiers = 0;
        }
        if (modifier == null) {
            return;
        }
        if (modifier.contains("public")) {
            this.classModifiers |= 1;
        }
        if (modifier.contains("protected")) {
            this.classModifiers |= 4;
        }
        if (modifier.contains("private")) {
            this.classModifiers |= 2;
        }
        if (modifier.contains("default")) {
            this.classModifiers |= 0x80;
        }
        if (modifier.contains("package protected")) {
            this.classModifiers |= 0x80;
        }
        if (modifier.contains("final")) {
            this.classModifiers |= 0x10;
        }
        if (modifier.contains("static")) {
            this.classModifiers |= 8;
        }
    }

    public void addMethodEditor(MethodAcceptor ma) {
        if (this.editors == null) {
            this.editors = new MethodAcceptorsList();
        }
        this.editors.add(ma);
    }

    public void editClass(ClassAcceptor ca) {
        if (this.classEditors == null) {
            this.classEditors = new ClassAcceptorsList();
        }
        this.classEditors.add(ca);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean classNameMatches(String className) {
        if (this.classNames == null) {
            return true;
        }
        for (int i = 0; i < this.classNameMatchers.size(); ++i) {
            Matcher matcher;
            Matcher matcher2 = matcher = this.classNameMatchers.get(i);
            synchronized (matcher2) {
                matcher.reset(className);
                if (matcher.matches()) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    public Collection<String> getClassNames() {
        if (!this.classNameHashable.booleanValue()) {
            return Collections.emptyList();
        }
        return this.classNamesRaw;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Rule");
        if (this.classNames != null) {
            sb.append(", names:[");
            for (Pattern className : this.classNames) {
                sb.append(className).append(',');
            }
            sb.append("]");
        }
        if (this.superClasses != null) {
            sb.append(",super:[");
            for (Pattern superClass : this.superClasses) {
                sb.append(superClass).append(',');
            }
            sb.append("]");
        }
        if (this.minimumMethodSize != 0) {
            sb.append(',').append("min_method_size: ").append(this.minimumMethodSize);
        }
        if (this.minimumMethodLines != 0) {
            sb.append(',').append("min_method_lines: ").append(this.minimumMethodLines);
        }
        if (this.minimumMethodBackJumps != 0) {
            sb.append(',').append("min_method_back_jumps: ").append(this.minimumMethodBackJumps);
        }
        if (this.methodNames != null) {
            sb.append(", method:[");
            for (Pattern methodName : this.methodNames) {
                sb.append(methodName).append(',');
            }
            sb.append("]");
        }
        if (this.excludedMethods != null) {
            sb.append(", exclude_method:[");
            for (Pattern methodName : this.excludedMethods) {
                sb.append(methodName).append(',');
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public void setStackTraceAtCreate(ConfigStackElement currentStack) {
        this.stack = currentStack;
    }

    public ConfigStackElement getStackTraceAtCreate() {
        return this.stack;
    }

    public int hashCode() {
        int result = ListOfRegExps.hashCode(this.classNames);
        result = 31 * result + ListOfRegExps.hashCode(this.methodNames);
        result = 31 * result + ListOfRegExps.hashCode(this.excludedMethods);
        result = 31 * result + ListOfRegExps.hashCode(this.superClasses);
        result = 31 * result + (this.editors != null ? this.editors.hashCode() : 0);
        result = 31 * result + (this.ifEnhancer != null ? this.ifEnhancer.hashCode() : 0);
        result = 31 * result + this.methodModifiers;
        result = 31 * result + this.classModifiers;
        result = 31 * result + this.minimumMethodSize;
        result = 31 * result + this.minimumMethodLines;
        result = 31 * result + this.minimumMethodBackJumps;
        result = 31 * result + (this.doNotProfile ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.doNotProfile != rule.doNotProfile) {
            return false;
        }
        if (this.methodModifiers != rule.methodModifiers) {
            return false;
        }
        if (this.classModifiers != rule.classModifiers) {
            return false;
        }
        if (this.minimumMethodSize != rule.minimumMethodSize) {
            return false;
        }
        if (this.minimumMethodLines != rule.minimumMethodLines) {
            return false;
        }
        if (this.minimumMethodBackJumps != rule.minimumMethodBackJumps) {
            return false;
        }
        if (!ListOfRegExps.equals(this.classNames, rule.classNames)) {
            return false;
        }
        if (!ListOfRegExps.equals(this.excludedMethods, rule.excludedMethods)) {
            return false;
        }
        if (this.editors != null ? !this.editors.equals(rule.editors) : rule.editors != null) {
            return false;
        }
        if (this.ifEnhancer != null ? !this.ifEnhancer.equals(rule.ifEnhancer) : rule.ifEnhancer != null) {
            return false;
        }
        if (!ListOfRegExps.equals(this.methodNames, rule.methodNames)) {
            return false;
        }
        return ListOfRegExps.equals(this.superClasses, rule.superClasses);
    }

    static {
        DESCRIPTORS.put("void", "V");
        DESCRIPTORS.put("byte", "B");
        DESCRIPTORS.put("char", "C");
        DESCRIPTORS.put("double", "D");
        DESCRIPTORS.put("float", "F");
        DESCRIPTORS.put("int", "I");
        DESCRIPTORS.put("long", "J");
        DESCRIPTORS.put("short", "S");
        DESCRIPTORS.put("boolean", "Z");
        DESCRIPTORS.put("...", "(?:\\[*(?:L[^;]++;|[VBCDFIJSZ]))*");
        DESCRIPTORS.put("any", "\\[*(?:L[^;]++;|[VBCDFIJSZ])");
    }
}

