/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.configuration;

import com.netcracker.profiler.configuration.Rule;
import com.netcracker.profiler.configuration.RuleGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleHashGroup
extends RuleGroup {
    private final Map<String, List<Rule>> rules = new HashMap<String, List<Rule>>();

    @Override
    public boolean add(Rule rule) {
        if (rule.getClassNames().isEmpty()) {
            return false;
        }
        for (String className : rule.getClassNames()) {
            List<Rule> rules = this.rules.get(className = className.replace('.', '/'));
            if (rules == null) {
                rules = new ArrayList<Rule>();
                this.rules.put(className, rules);
            }
            rules.add(rule);
        }
        return true;
    }

    @Override
    public List<Rule> getRulesForClass(String className) {
        return this.rules.get(className);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleHashGroup)) {
            return false;
        }
        RuleHashGroup that = (RuleHashGroup)o;
        return this.rules.equals(that.rules);
    }

    public int hashCode() {
        return this.rules.hashCode();
    }

    public String toString() {
        return "RuleHashGroup{rules=" + this.rules + '}';
    }
}

