/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.instrument.custom.util;

import com.netcracker.profiler.agent.Configuration_01;
import com.netcracker.profiler.agent.LocalState;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.instrument.ProfileMethodAdapter;
import com.netcracker.profiler.instrument.custom.MethodInstrumenter;
import com.netcracker.profiler.instrument.custom.util.TryCatchData;
import com.netcracker.profiler.util.XMLHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class ExecuteMethod
extends MethodInstrumenter
implements Opcodes {
    public static final Logger log = LoggerFactory.getLogger(ExecuteMethod.class);
    private static final Handle PROFILER_METAFACTORY_HANDLE = new Handle(6, "com/netcracker/profiler/agent/ProfilerMetafactory", "catchPluginException", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;)Ljava/lang/invoke/CallSite;", false);
    static int JAVA_7_VERSION = 51;
    protected String methodName;
    protected String className;
    protected List<Integer> args = Collections.emptyList();
    protected List<Type> argTypes = Collections.emptyList();
    protected Type returnType;
    protected boolean isStatic;
    protected boolean isPrivate;
    protected boolean getsResult;
    boolean addTryCatchBlocks = ProfilerData.ADD_TRY_CATCH_BLOCKS;
    public static final int RESULT_ARG_UNDEFINED = Integer.MIN_VALUE;
    protected int storeResultArg = Integer.MIN_VALUE;
    public static final Pattern METHOD_NAME_PATTERN = Pattern.compile("([^,) ]*?)\\s*(p\\d+|duration|startTime|state|result|this|throwable)\\s*[,)]", 2);
    private static final Type C_LOCAL_STATE = Type.getType(LocalState.class);
    private static final Type C_THROWABLE = Type.getType(Throwable.class);
    public static final int ARG_START_TIME = -1;
    public static final int ARG_DURATION = -2;
    public static final int ARG_LOCAL_STATE = -3;
    public static final int ARG_RESULT = -4;
    public static final int ARG_THIS = -5;
    public static final int ARG_THROWABLE = -6;
    public static final Map<String, String> DESCRIPTORS = new HashMap<String, String>();

    @Override
    public MethodInstrumenter init(Element e, Configuration_01 configuration) {
        String methodName = XMLHelper.getTextContent(e);
        if (methodName.length() == 0) {
            log.warn("Please, specify method name to call");
            return this;
        }
        String returnTypeStr = e.getAttribute("return");
        this.returnType = this.getType(returnTypeStr);
        methodName = this.parseMethodArgs(methodName);
        this.isStatic = Boolean.valueOf(e.getAttribute("static"));
        this.isPrivate = Boolean.valueOf(e.getAttribute("private"));
        this.className = this.extractTargetClassName(e);
        if (this.className == null) {
            log.debug("Class name was not specified (via class or type argument) while parsing for method {}, assuming it is the same as the modified one", (Object)methodName);
        }
        this.methodName = methodName;
        String storeResultArg = e.getAttribute("store-result-to-argument");
        if (storeResultArg.length() > 0) {
            try {
                this.storeResultArg = Integer.parseInt(storeResultArg);
                this.addTryCatchBlocks = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.storeResultArg != Integer.MIN_VALUE && Type.VOID_TYPE.equals((Object)this.returnType)) {
            log.warn("store-result-to-argument is {}, however method {} return type is VOID", (Object)storeResultArg, (Object)this.returnType);
            this.storeResultArg = Integer.MIN_VALUE;
        }
        return this;
    }

    protected String parseMethodArgs(String methodName) {
        int argsStartPos = methodName.indexOf(40);
        if (argsStartPos != -1) {
            Matcher m = METHOD_NAME_PATTERN.matcher(methodName.substring(argsStartPos + 1));
            methodName = methodName.substring(0, argsStartPos);
            this.args = new ArrayList<Integer>();
            this.argTypes = new ArrayList<Type>();
            while (m.find()) {
                String argType = m.group(1);
                String paramName = m.group(2);
                Type dstArgType = this.getType(argType);
                this.parseArgument(paramName, dstArgType);
            }
            if (this.args.isEmpty()) {
                this.args = Collections.emptyList();
            }
        }
        return methodName;
    }

    private Type getType(String argType) {
        if (argType == null || argType.length() == 0) {
            return null;
        }
        StringBuilder typeDescriptor = new StringBuilder();
        if (argType.charAt(0) == '[' || argType.indexOf(46) < 0 && argType.indexOf(91) < 0) {
            String primitive = DESCRIPTORS.get(argType);
            if (primitive != null) {
                argType = primitive;
            }
            typeDescriptor.append(argType);
        } else {
            String primitive;
            int isArray = argType.indexOf(91);
            if (isArray >= 0) {
                int i = isArray;
                while (i >= 0) {
                    typeDescriptor.append('[');
                    i = argType.indexOf(91, isArray + 1);
                }
                while (Character.isSpaceChar(argType.charAt(isArray - 1))) {
                    --isArray;
                }
                argType = argType.substring(0, isArray);
            }
            if ((primitive = DESCRIPTORS.get(argType)) != null) {
                typeDescriptor.append(primitive);
            } else {
                typeDescriptor.append('L').append(argType.replace('.', '/')).append(';');
            }
        }
        return Type.getType((String)typeDescriptor.toString());
    }

    private void parseArgument(String paramName, Type dstArgType) {
        if ("duration".equalsIgnoreCase(paramName)) {
            this.args.add(-2);
            this.argTypes.add(Type.INT_TYPE);
            return;
        }
        if ("startTime".equalsIgnoreCase(paramName)) {
            this.args.add(-1);
            this.argTypes.add(Type.INT_TYPE);
            return;
        }
        if ("state".equalsIgnoreCase(paramName)) {
            this.args.add(-3);
            this.argTypes.add(C_LOCAL_STATE);
            return;
        }
        if ("throwable".equalsIgnoreCase(paramName)) {
            this.args.add(-6);
            this.argTypes.add(C_THROWABLE);
            return;
        }
        this.argTypes.add(dstArgType);
        if ("result".equalsIgnoreCase(paramName)) {
            this.args.add(-4);
            this.getsResult = true;
            return;
        }
        if ("this".equalsIgnoreCase(paramName)) {
            this.args.add(-5);
            return;
        }
        this.args.add(Integer.parseInt(paramName.substring(1)) - 1);
    }

    private String extractTargetClassName(Element e) {
        String className = e.getAttribute("type");
        if (className.length() == 0) {
            className = e.getAttribute("class");
        }
        if (className.length() == 0) {
            return null;
        }
        return className.replace('.', '/');
    }

    protected void appendCall(ProfileMethodAdapter ma) {
        this.appendCall(ma, null, null);
    }

    @Override
    public void declareLocals(ProfileMethodAdapter ma) {
        if (this.getsResult) {
            ma.declareResultVariable();
        }
        if (!this.isStatic) {
            ma.declareThisVariable();
        }
        for (Integer arg : this.args) {
            if (arg >= 0) {
                ma.saveArg(arg);
                continue;
            }
            if (arg != -5) continue;
            ma.declareThisVariable();
        }
    }

    protected Type getReturnType(ProfileMethodAdapter ma) {
        if (this.returnType != null) {
            return this.returnType;
        }
        if (this.storeResultArg == Integer.MIN_VALUE) {
            return Type.VOID_TYPE;
        }
        return ma.getArgumentTypes()[this.storeResultArg];
    }

    protected void appendCall(ProfileMethodAdapter ma, Type[] additionalParams, int[] vars) {
        if (this.methodName == null) {
            return;
        }
        Type targetClass = Type.getObjectType((String)(this.className != null ? this.className : ma.getClassName()));
        MethodCallInfo targetMethod = this.getTargetMethod(ma, additionalParams);
        if (!this.isStatic) {
            ma.loadSavedThis();
        }
        int argsSize = this.args.size();
        for (int i = 0; i < argsSize; ++i) {
            Integer arg = this.args.get(i);
            this.generateLoadVar(ma, arg);
            if (targetMethod.castFrom == null) continue;
            this.generateCast(ma, targetMethod.castFrom[i], this.argTypes.get(i));
        }
        if (vars != null) {
            for (int var : vars) {
                ma.loadLocal(var);
            }
        }
        if (this.isStatic) {
            if (this.shouldAddIndyTryCatchBlocks(ma.getClassVersion())) {
                this.invokeDynamicWithTryCatch(ma, 6, targetClass.getInternalName(), targetMethod.method.getDescriptor());
            } else {
                ma.invokeStatic(targetClass, targetMethod.method);
            }
        } else if (this.isPrivate) {
            if (this.shouldAddIndyTryCatchBlocks(ma.getClassVersion())) {
                this.invokeDynamicWithTryCatch(ma, 7, targetClass.getInternalName(), targetMethod.method.getDescriptor());
            } else {
                ma.invokeConstructor(targetClass, targetMethod.method);
            }
        } else if (this.shouldAddIndyTryCatchBlocks(ma.getClassVersion())) {
            this.invokeDynamicWithTryCatch(ma, 5, targetClass.getInternalName(), targetMethod.method.getDescriptor());
        } else {
            ma.invokeVirtual(targetClass, targetMethod.method);
        }
        Type returnType = targetMethod.method.getReturnType();
        this.storeResult(ma, returnType);
    }

    private void invokeDynamicWithTryCatch(ProfileMethodAdapter ma, int tag, String className, String methodDesc) {
        String hMethodDesc = methodDesc;
        if (tag != 6) {
            methodDesc = "(L" + className + ";" + methodDesc.substring(1);
        }
        ma.invokeDynamic(this.methodName, methodDesc, PROFILER_METAFACTORY_HANDLE, new Object[]{new Handle(tag, className, this.methodName, hMethodDesc, tag == 9)});
    }

    boolean shouldAddPlainTryCatchBlocks(int classVersion) {
        return this.addTryCatchBlocks && ProfilerData.ADD_PLAIN_TRY_CATCH_BLOCKS && !this.shouldAddIndyTryCatchBlocks(classVersion);
    }

    boolean shouldAddIndyTryCatchBlocks(int classVersion) {
        return this.addTryCatchBlocks && ProfilerData.ADD_INDY_TRY_CATCH_BLOCKS && classVersion >= JAVA_7_VERSION;
    }

    protected void storeResult(ProfileMethodAdapter ma, Type returnType) {
        if (Type.VOID_TYPE.equals((Object)returnType)) {
            return;
        }
        if (this.storeResultArg == Integer.MIN_VALUE) {
            ma.visitInsn(87 + returnType.getSize() - 1);
        } else {
            ma.storeArg(this.storeResultArg);
        }
    }

    protected TryCatchData appendTry(ProfileMethodAdapter ma) {
        TryCatchData tryCatchData = new TryCatchData();
        ma.visitTryCatchBlock(tryCatchData.getStartTry(), tryCatchData.getEndTry(), tryCatchData.getStartCatch(), "java/lang/Throwable");
        ma.visitLabel(tryCatchData.getStartTry());
        return tryCatchData;
    }

    protected void appendCatch(ProfileMethodAdapter ma, Object[] locals, TryCatchData tryCatchData) {
        int localsLength = locals == null ? 0 : locals.length;
        ma.visitLabel(tryCatchData.getEndTry());
        ma.visitJumpInsn(167, tryCatchData.getEndCatch());
        ma.visitLabel(tryCatchData.getStartCatch());
        ma.visitFrame(-1, localsLength, locals, 1, new Object[]{"java/lang/Throwable"});
        ma.invokeStatic(ProfileMethodAdapter.C_PROFILER, ProfileMethodAdapter.M_PLUGIN_EXCEPTION);
        ma.visitLabel(tryCatchData.getEndCatch());
        ma.visitFrame(-1, localsLength, locals, 0, null);
    }

    private MethodCallInfo getTargetMethod(ProfileMethodAdapter ma, Type[] additionalParams) {
        Type[] requiredArgTypes = new Type[this.args.size() + (additionalParams != null ? additionalParams.length : 0)];
        Type[] argTypes = ma.getArgumentTypes();
        Type[] castFrom = new Type[this.args.size()];
        int argsSize = this.args.size();
        for (int i = 0; i < argsSize; ++i) {
            Integer arg = this.args.get(i);
            Type argType = null;
            if (arg >= 0) {
                argType = argTypes[arg];
            } else {
                switch (arg) {
                    case -3: {
                        argType = C_LOCAL_STATE;
                        break;
                    }
                    case -4: {
                        argType = ma.getReturnType();
                        break;
                    }
                    case -5: {
                        argType = Type.getObjectType((String)ma.getClassName());
                        break;
                    }
                    case -6: {
                        argType = C_THROWABLE;
                    }
                }
            }
            Type overrideType = this.argTypes.get(i);
            if (overrideType != null) {
                castFrom[i] = argType;
                argType = overrideType;
            }
            requiredArgTypes[i] = argType;
        }
        if (additionalParams != null) {
            System.arraycopy(additionalParams, 0, requiredArgTypes, this.args.size(), additionalParams.length);
        }
        Method targetMethod = new Method(this.methodName, this.getReturnType(ma), requiredArgTypes);
        return new MethodCallInfo(targetMethod, castFrom);
    }

    private void generateLoadVar(ProfileMethodAdapter ma, int arg) {
        if (arg >= 0) {
            ma.loadLocal(ma.saveArg(arg));
            return;
        }
        switch (arg) {
            case -1: {
                ma.loadLocal(ma.getStartTimeVariableNumber());
                break;
            }
            case -2: {
                ma.getIntTime();
                ma.loadLocal(ma.getStartTimeVariableNumber());
                ma.math(100, Type.INT_TYPE);
                break;
            }
            case -3: {
                ma.loadLocal(ma.getLocalStateVariableNumber());
                break;
            }
            case -4: {
                ma.loadLocal(ma.getResultVariableNumber());
                break;
            }
            case -5: {
                ma.loadSavedThis();
                break;
            }
            case -6: {
                if (ma.getThrowableVariableNumber() < 0) {
                    ma.visitInsn(1);
                    break;
                }
                ma.loadLocal(ma.getThrowableVariableNumber());
            }
        }
    }

    private void generateCast(ProfileMethodAdapter ma, Type fromType, Type toType) {
        if (fromType != null && toType != null) {
            if (fromType.getSort() != 9 && fromType.getSort() != 10 && fromType.getSort() != 11) {
                ma.cast(fromType, toType);
            } else {
                ma.checkCast(toType);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecuteMethod)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecuteMethod that = (ExecuteMethod)o;
        if (this.isStatic != that.isStatic) {
            return false;
        }
        if (this.isPrivate != that.isPrivate) {
            return false;
        }
        if (this.storeResultArg != that.storeResultArg) {
            return false;
        }
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.argTypes != null ? !this.argTypes.equals(that.argTypes) : that.argTypes != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return !(this.returnType != null ? !this.returnType.equals((Object)that.returnType) : that.returnType != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
        result = 31 * result + (this.argTypes != null ? this.argTypes.hashCode() : 0);
        result = 31 * result + this.storeResultArg;
        return result;
    }

    static {
        DESCRIPTORS.put("void", "V");
        DESCRIPTORS.put("byte", "B");
        DESCRIPTORS.put("char", "C");
        DESCRIPTORS.put("double", "D");
        DESCRIPTORS.put("float", "F");
        DESCRIPTORS.put("int", "I");
        DESCRIPTORS.put("long", "J");
        DESCRIPTORS.put("short", "S");
        DESCRIPTORS.put("boolean", "Z");
    }

    protected static class MethodCallInfo {
        public final Method method;
        public final Type[] castFrom;

        public MethodCallInfo(Method method, Type[] castFrom) {
            this.method = method;
            this.castFrom = castFrom;
        }
    }
}

