/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.tools.preloader;

import com.netcracker.profiler.tools.preloader.GatherClassNamesFromClass;
import com.netcracker.profiler.util.IOHelper;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class GeneratePreloader {
    HashSet<String> classNames = new HashSet();
    private final String jarName;
    private final String destName;

    public GeneratePreloader(String jarName, String destName) {
        this.jarName = jarName;
        this.destName = destName;
    }

    public static void main(String[] args) throws FileNotFoundException {
        GeneratePreloader preloader = new GeneratePreloader(args[0], args[1]);
        preloader.run();
    }

    public void run() {
        this.gatherClassNames();
        this.generatePreloader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePreloader() {
        Object[] classes = this.classNames.toArray(new String[this.classNames.size()]);
        Arrays.sort(classes);
        PrintWriter w = null;
        try {
            w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.destName), "UTF-8")));
            for (Object s : classes) {
                if (((String)s).length() > 3 && ((String)s).charAt(0) == 'L' && ((String)s).charAt(((String)s).length() - 1) == ';') {
                    s = ((String)s).substring(1, ((String)s).length() - 1);
                }
                w.println(((String)s).replace('/', '.'));
            }
        }
        catch (IOException e) {
            try {
                System.err.println("Unable to generate preloader " + this.destName);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOHelper.close(w);
                throw throwable;
            }
            IOHelper.close((Writer)w);
        }
        IOHelper.close((Writer)w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherClassNames() {
        ZipInputStream is = null;
        try {
            ZipEntry entry;
            is = new ZipInputStream(new FileInputStream(this.jarName));
            GatherClassNamesFromClass remapper = new GatherClassNamesFromClass(this.classNames);
            ClassRemapper remap = new ClassRemapper(null, (Remapper)remapper);
            while ((entry = is.getNextEntry()) != null) {
                if (entry.isDirectory() || entry.getName() == null || !entry.getName().endsWith(".class")) continue;
                ClassReader cr = new ClassReader((InputStream)is);
                cr.accept((ClassVisitor)remap, 2);
            }
        }
        catch (IOException e) {
            try {
                System.err.println("Unable to process jar " + this.jarName);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOHelper.close(is);
                throw throwable;
            }
            IOHelper.close((InputStream)is);
        }
        IOHelper.close((InputStream)is);
    }
}

