/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.collector.mock;

import com.netcracker.profiler.cloud.transport.EndlessSocketInputStream;
import com.netcracker.profiler.cloud.transport.FieldIO;
import com.netcracker.profiler.cloud.transport.ProfilerProtocolException;
import com.netcracker.profiler.collector.mock.DataLogger;
import com.netcracker.profiler.collector.mock.MockCollectorServer;
import com.netcracker.profiler.collector.mock.StreamManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\b\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/netcracker/profiler/collector/mock/ClientConnectionHandler;", "Ljava/io/Closeable;", "socket", "Ljava/net/Socket;", "server", "Lcom/netcracker/profiler/collector/mock/MockCollectorServer;", "<init>", "(Ljava/net/Socket;Lcom/netcracker/profiler/collector/mock/MockCollectorServer;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "streamManager", "Lcom/netcracker/profiler/collector/mock/StreamManager;", "dataLogger", "Lcom/netcracker/profiler/collector/mock/DataLogger;", "fieldIO", "Lcom/netcracker/profiler/cloud/transport/FieldIO;", "inputStream", "Ljava/io/BufferedInputStream;", "outputStream", "Ljava/io/BufferedOutputStream;", "podName", "", "microserviceName", "cloudNamespace", "protocolVersion", "", "handle", "", "initializeConnection", "performHandshake", "processCommands", "handleInitStream", "handleReceiveData", "handleAckFlush", "handleKeepAlive", "sendAck", "numCommands", "", "close", "qubership-profiler-mock-collector"})
public final class ClientConnectionHandler
implements Closeable {
    @NotNull
    private final Socket socket;
    @NotNull
    private final MockCollectorServer server;
    private final Logger log;
    @NotNull
    private final StreamManager streamManager;
    @NotNull
    private final DataLogger dataLogger;
    private FieldIO fieldIO;
    private BufferedInputStream inputStream;
    private BufferedOutputStream outputStream;
    @NotNull
    private String podName;
    @NotNull
    private String microserviceName;
    @NotNull
    private String cloudNamespace;
    private long protocolVersion;

    public ClientConnectionHandler(@NotNull Socket socket, @NotNull MockCollectorServer server) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.socket = socket;
        this.server = server;
        this.log = LoggerFactory.getLogger(ClientConnectionHandler.class);
        this.streamManager = new StreamManager();
        this.dataLogger = new DataLogger();
        this.podName = "unknown";
        this.microserviceName = "unknown";
        this.cloudNamespace = "unknown";
        this.protocolVersion = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle() {
        try {
            this.initializeConnection();
            this.processCommands();
        }
        catch (SocketTimeoutException e) {
            this.log.debug("Socket timeout for {}:{}", (Object)this.microserviceName, (Object)this.podName);
        }
        catch (ProfilerProtocolException e) {
            Object[] objectArray = new Object[]{this.microserviceName, this.podName, e.getMessage()};
            this.log.error("Protocol error for {}:{}: {}", objectArray);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{this.microserviceName, this.podName, e};
            this.log.error("Error handling connection from {}:{}", objectArray);
        }
        finally {
            this.close();
        }
    }

    private final void initializeConnection() {
        this.socket.setSoTimeout(30000);
        this.socket.setSendBufferSize(8192);
        this.socket.setReceiveBufferSize(8192);
        this.socket.setKeepAlive(true);
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream(), 1024);
        InputStream socketInput = this.socket.getInputStream();
        this.inputStream = new BufferedInputStream((InputStream)new EndlessSocketInputStream(socketInput), 1024);
        BufferedInputStream bufferedInputStream = this.inputStream;
        if (bufferedInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputStream");
            bufferedInputStream = null;
        }
        InputStream inputStream = bufferedInputStream;
        BufferedOutputStream bufferedOutputStream = this.outputStream;
        if (bufferedOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
            bufferedOutputStream = null;
        }
        this.fieldIO = new FieldIO(this.socket, inputStream, (OutputStream)bufferedOutputStream);
        this.performHandshake();
    }

    private final void performHandshake() {
        long l;
        int command;
        BufferedInputStream bufferedInputStream = this.inputStream;
        if (bufferedInputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputStream");
            bufferedInputStream = null;
        }
        if ((command = bufferedInputStream.read()) != 20) {
            throw new ProfilerProtocolException("Expected COMMAND_GET_PROTOCOL_VERSION_V2 but got " + command);
        }
        FieldIO fieldIO = this.fieldIO;
        if (fieldIO == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO = null;
        }
        long clientVersion = fieldIO.readLong();
        FieldIO fieldIO2 = this.fieldIO;
        if (fieldIO2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO2 = null;
        }
        String string = fieldIO2.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this.podName = string;
        FieldIO fieldIO3 = this.fieldIO;
        if (fieldIO3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO3 = null;
        }
        String string2 = fieldIO3.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        this.microserviceName = string2;
        FieldIO fieldIO4 = this.fieldIO;
        if (fieldIO4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO4 = null;
        }
        String string3 = fieldIO4.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
        this.cloudNamespace = string3;
        Object[] objectArray = new Object[]{this.podName, this.microserviceName, this.cloudNamespace, clientVersion};
        this.log.info("Client handshake: pod={}, microservice={}, namespace={}, version={}", objectArray);
        if (clientVersion >= 100705L) {
            l = 100705L;
        } else if (clientVersion >= 100605L) {
            l = 100605L;
        } else {
            throw new ProfilerProtocolException("Unsupported client protocol version: " + clientVersion);
        }
        this.protocolVersion = l;
        FieldIO fieldIO5 = this.fieldIO;
        if (fieldIO5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO5 = null;
        }
        fieldIO5.writeLong(this.protocolVersion);
        BufferedOutputStream bufferedOutputStream = this.outputStream;
        if (bufferedOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
            bufferedOutputStream = null;
        }
        bufferedOutputStream.flush();
        this.log.info("Handshake completed with protocol version {}", (Object)this.protocolVersion);
    }

    private final void processCommands() {
        block10: while (!this.socket.isClosed() && this.socket.isConnected()) {
            try {
                int command;
                BufferedInputStream bufferedInputStream = this.inputStream;
                if (bufferedInputStream == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"inputStream");
                    bufferedInputStream = null;
                }
                if ((command = bufferedInputStream.read()) < 0) {
                    this.log.debug("End of stream from {}:{}", (Object)this.microserviceName, (Object)this.podName);
                    break;
                }
                switch (command) {
                    case 21: {
                        this.handleInitStream();
                        break;
                    }
                    case 2: {
                        this.handleReceiveData();
                        break;
                    }
                    case 17: {
                        this.handleAckFlush();
                        break;
                    }
                    case 4: {
                        this.log.info("Client {}:{} requested close", (Object)this.microserviceName, (Object)this.podName);
                        break block10;
                    }
                    case 18: {
                        this.handleKeepAlive();
                        break;
                    }
                    default: {
                        Object[] objectArray = new Object[]{command, this.microserviceName, this.podName};
                        this.log.warn("Unknown command: {} from {}:{}", objectArray);
                        break;
                    }
                }
            }
            catch (SocketTimeoutException e) {
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{this.microserviceName, this.podName, e};
                this.log.error("Error processing command from {}:{}", objectArray);
                break;
            }
        }
    }

    private final void handleInitStream() {
        FieldIO fieldIO = this.fieldIO;
        if (fieldIO == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO = null;
        }
        String streamName = fieldIO.readString();
        FieldIO fieldIO2 = this.fieldIO;
        if (fieldIO2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO2 = null;
        }
        int requestedRollingSequenceId = fieldIO2.readInt();
        FieldIO fieldIO3 = this.fieldIO;
        if (fieldIO3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO3 = null;
        }
        boolean resetRequired = fieldIO3.readInt() != 0;
        Object[] objectArray = new String[]{"stream_name", streamName};
        this.server.getMetricRegistry().counter("mock.server.streams", (String[])objectArray).increment();
        objectArray = new Object[]{streamName, requestedRollingSequenceId, resetRequired};
        this.log.info("Initializing stream: name={}, rollingSeqId={}, reset={}", objectArray);
        UUID streamHandle = UUID.randomUUID();
        Intrinsics.checkNotNull((Object)streamHandle);
        Intrinsics.checkNotNull((Object)streamName);
        this.streamManager.registerStream(streamHandle, streamName, requestedRollingSequenceId);
        FieldIO fieldIO4 = this.fieldIO;
        if (fieldIO4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO4 = null;
        }
        fieldIO4.writeUUID(streamHandle);
        FieldIO fieldIO5 = this.fieldIO;
        if (fieldIO5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO5 = null;
        }
        fieldIO5.writeLong(0L);
        FieldIO fieldIO6 = this.fieldIO;
        if (fieldIO6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO6 = null;
        }
        fieldIO6.writeLong(0L);
        FieldIO fieldIO7 = this.fieldIO;
        if (fieldIO7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO7 = null;
        }
        fieldIO7.writeInt(requestedRollingSequenceId);
        BufferedOutputStream bufferedOutputStream = this.outputStream;
        if (bufferedOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
            bufferedOutputStream = null;
        }
        bufferedOutputStream.flush();
        this.log.debug("Stream initialized: {} -> {}", (Object)streamName, (Object)streamHandle);
    }

    private final void handleReceiveData() {
        FieldIO fieldIO = this.fieldIO;
        if (fieldIO == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO = null;
        }
        UUID streamHandle = fieldIO.readUUID();
        FieldIO fieldIO2 = this.fieldIO;
        if (fieldIO2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO2 = null;
        }
        int dataLength = fieldIO2.readField();
        if (streamHandle == null) {
            this.log.warn("Received data for null stream handle");
            this.sendAck(1);
            return;
        }
        StreamManager.StreamInfo streamInfo = this.streamManager.getStream(streamHandle);
        if (streamInfo == null) {
            this.log.warn("Received data for unknown stream: {}", (Object)streamHandle);
            this.sendAck(1);
            return;
        }
        String[] stringArray = new String[]{"stream_name", streamInfo.getName()};
        this.server.getMetricRegistry().counter("mock.server.stream.chunks", stringArray).increment();
        stringArray = new String[]{"stream_name", streamInfo.getName()};
        this.server.getMetricRegistry().counter("mock.server.stream.bytes", stringArray).increment((double)dataLength);
        FieldIO fieldIO3 = this.fieldIO;
        if (fieldIO3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldIO");
            fieldIO3 = null;
        }
        byte[] byArray = fieldIO3.getArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getArray(...)");
        byte[] byArray2 = Arrays.copyOf(byArray, dataLength);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        byte[] data = byArray2;
        this.dataLogger.logData(streamInfo.getName(), data, dataLength, this.podName, this.microserviceName, this.cloudNamespace);
        this.streamManager.recordData(streamHandle, dataLength);
        this.sendAck(0);
    }

    private final void handleAckFlush() {
        this.log.trace("Ack flush requested by {}:{}", (Object)this.microserviceName, (Object)this.podName);
        this.sendAck(0);
    }

    private final void handleKeepAlive() {
        this.log.trace("Keep-alive from {}:{}", (Object)this.microserviceName, (Object)this.podName);
    }

    private final void sendAck(int numCommands) {
        BufferedOutputStream bufferedOutputStream = this.outputStream;
        if (bufferedOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
            bufferedOutputStream = null;
        }
        bufferedOutputStream.write(numCommands);
        BufferedOutputStream bufferedOutputStream2 = this.outputStream;
        if (bufferedOutputStream2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
            bufferedOutputStream2 = null;
        }
        bufferedOutputStream2.flush();
    }

    @Override
    public void close() {
        try {
            this.log.info("Closing connection from {}:{}", (Object)this.microserviceName, (Object)this.podName);
            this.streamManager.close();
            this.socket.close();
        }
        catch (Exception e) {
            this.log.error("Error closing connection", (Throwable)e);
        }
    }
}

