/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.collector.mock;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u001a\u001a\u00020\u000fR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netcracker/profiler/collector/mock/DataLogger;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "totalBytesReceived", "Ljava/util/concurrent/atomic/AtomicLong;", "totalChunksReceived", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "logData", "", "streamName", "", "data", "", "length", "", "podName", "microserviceName", "cloudNamespace", "getDataPreview", "isLikelyText", "", "getStatistics", "qubership-profiler-mock-collector"})
@SourceDebugExtension(value={"SMAP\nDataLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLogger.kt\ncom/netcracker/profiler/collector/mock/DataLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1869#2,2:151\n1869#2,2:153\n*S KotlinDebug\n*F\n+ 1 DataLogger.kt\ncom/netcracker/profiler/collector/mock/DataLogger\n*L\n55#1:151,2\n78#1:153,2\n*E\n"})
public final class DataLogger {
    private final Logger log = LoggerFactory.getLogger(DataLogger.class);
    @NotNull
    private final AtomicLong totalBytesReceived = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalChunksReceived = new AtomicLong(0L);
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());

    public final void logData(@NotNull String streamName, @NotNull byte[] data, int length, @NotNull String podName, @NotNull String microserviceName, @NotNull String cloudNamespace) {
        Intrinsics.checkNotNullParameter((Object)streamName, (String)"streamName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)podName, (String)"podName");
        Intrinsics.checkNotNullParameter((Object)microserviceName, (String)"microserviceName");
        Intrinsics.checkNotNullParameter((Object)cloudNamespace, (String)"cloudNamespace");
        this.totalBytesReceived.addAndGet(length);
        long chunkNumber = this.totalChunksReceived.incrementAndGet();
        String timestamp = this.timeFormatter.format(Instant.now());
        this.log.info(StringsKt.repeat((CharSequence)"=", (int)80));
        this.log.info("Data Chunk Received #{}", (Object)chunkNumber);
        this.log.info(StringsKt.repeat((CharSequence)"-", (int)80));
        this.log.info("  Timestamp:       {}", (Object)timestamp);
        this.log.info("  Stream:          {}", (Object)streamName);
        Object[] objectArray = new Object[]{cloudNamespace, microserviceName, podName};
        this.log.info("  Source:          {}/{}/{}", objectArray);
        Integer n = length;
        String[] stringArray = "%.2f";
        Object object = new Object[]{(double)length / 1024.0};
        String string = String.format((String)stringArray, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        this.log.info("  Size:            {} bytes ({} KB)", (Object)n, (Object)string);
        objectArray = new Object[3];
        objectArray[0] = this.totalBytesReceived.get();
        object = "%.2f";
        Object[] objectArray2 = new Object[]{(double)this.totalBytesReceived.get() / 1024.0 / 1024.0};
        Intrinsics.checkNotNullExpressionValue((Object)String.format((String)object, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        objectArray[2] = chunkNumber;
        this.log.info("  Total Received:  {} bytes ({} MB in {} chunks)", objectArray);
        if (length > 0) {
            String preview = this.getDataPreview(data, length);
            this.log.info("  Data Preview:");
            stringArray = new String[]{"\n"};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)preview, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                this.log.info("    {}", (Object)line);
            }
        }
        this.log.info(StringsKt.repeat((CharSequence)"=", (int)80));
    }

    private final String getDataPreview(byte[] data, int length) {
        int previewSize = Math.min(length, 256);
        StringBuilder sb = new StringBuilder();
        boolean isLikelyText = this.isLikelyText(data, previewSize);
        if (isLikelyText) {
            int n = 0;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String text = new String(data, n, previewSize, charset2);
            sb.append("[Text preview]\n");
            String[] stringArray = new String[]{"\n"};
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)10);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String line = (String)element$iv;
                boolean bl = false;
                if (line.length() > 100) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = line.substring(0, 100);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    string = stringBuilder.append(string2).append("...").toString();
                } else {
                    string = line;
                }
                String truncated = string;
                sb.append(truncated).append("\n");
            }
            if (length > previewSize) {
                sb.append("... (" + (length - previewSize) + " more bytes)");
            }
        } else {
            sb.append("[Hex dump - first " + previewSize + " bytes]\n");
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)previewSize)), (int)16);
            int i = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    int j;
                    String line = "%04X: ";
                    Object bl = new Object[]{i};
                    String string = String.format(line, Arrays.copyOf(bl, ((Object[])bl).length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                    sb.append(string);
                    for (j = 0; j < 16; ++j) {
                        StringBuilder stringBuilder;
                        if (i + j < previewSize) {
                            bl = "%02X ";
                            Object[] objectArray = new Object[]{data[i + j]};
                            String string3 = String.format((String)bl, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                            stringBuilder = sb.append(string3);
                            continue;
                        }
                        stringBuilder = sb.append("   ");
                    }
                    sb.append(" | ");
                    for (j = 0; j < 16; ++j) {
                        if (i + j >= previewSize) continue;
                        int n3 = data[i + j] & 0xFF;
                        int n4 = (32 <= n3 ? n3 < 127 : false) ? (int)n3 : 46;
                        sb.append((char)n4);
                    }
                    sb.append("\n");
                    if (i == n) break;
                    i += n2;
                }
            }
            if (length > previewSize) {
                sb.append("... (" + (length - previewSize) + " more bytes)");
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isLikelyText(byte[] data, int length) {
        int printableCount = 0;
        int sampleSize = Math.min(length, 100);
        for (int i = 0; i < sampleSize; ++i) {
            int n = data[i] & 0xFF;
            boolean bl = 32 <= n ? n < 127 : false;
            if (!bl && n != 9 && n != 10 && n != 13) continue;
            ++printableCount;
        }
        return (double)printableCount / (double)sampleSize > 0.8;
    }

    @NotNull
    public final String getStatistics() {
        StringBuilder stringBuilder = new StringBuilder().append("Total: ").append(this.totalChunksReceived.get()).append(" chunks, ").append(this.totalBytesReceived.get()).append(" bytes (");
        String string = "%.2f";
        Object[] objectArray = new Object[]{(double)this.totalBytesReceived.get() / 1024.0 / 1024.0};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return stringBuilder.append(string2).append(" MB)").toString();
    }
}

