/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.collector.mock;

import com.netcracker.profiler.collector.mock.ClientConnectionHandler;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.Closeable;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lcom/netcracker/profiler/collector/mock/MockCollectorServer;", "Ljava/lang/AutoCloseable;", "bindPort", "", "backlog", "<init>", "(II)V", "metricRegistry", "Lio/micrometer/core/instrument/simple/SimpleMeterRegistry;", "getMetricRegistry", "()Lio/micrometer/core/instrument/simple/SimpleMeterRegistry;", "mockConnections", "Lio/micrometer/core/instrument/Counter;", "kotlin.jvm.PlatformType", "getMockConnections", "()Lio/micrometer/core/instrument/Counter;", "log", "Lorg/slf4j/Logger;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/netcracker/profiler/collector/mock/MockCollectorServer$ServerState;", "serverSocket", "Ljava/net/ServerSocket;", "startupLatch", "Ljava/util/concurrent/CountDownLatch;", "executor", "Ljava/util/concurrent/ExecutorService;", "activeConnections", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/netcracker/profiler/collector/mock/ClientConnectionHandler;", "port", "getPort", "()I", "started", "duration", "Ljava/time/Duration;", "start", "", "handleClientConnection", "socket", "Ljava/net/Socket;", "close", "ServerState", "Companion", "qubership-profiler-mock-collector"})
@SourceDebugExtension(value={"SMAP\nMockCollectorServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockCollectorServer.kt\ncom/netcracker/profiler/collector/mock/MockCollectorServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1869#2,2:157\n*S KotlinDebug\n*F\n+ 1 MockCollectorServer.kt\ncom/netcracker/profiler/collector/mock/MockCollectorServer\n*L\n129#1:157,2\n*E\n"})
public final class MockCollectorServer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int bindPort;
    private final int backlog;
    @NotNull
    private final SimpleMeterRegistry metricRegistry;
    private final Counter mockConnections;
    private final Logger log;
    @NotNull
    private final AtomicReference<ServerState> state;
    @Nullable
    private ServerSocket serverSocket;
    @NotNull
    private final CountDownLatch startupLatch;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final ConcurrentHashMap<String, ClientConnectionHandler> activeConnections;
    @NotNull
    private static final AtomicInteger threadCounter = new AtomicInteger(0);

    public MockCollectorServer(int bindPort, int backlog) {
        this.bindPort = bindPort;
        this.backlog = backlog;
        this.metricRegistry = new SimpleMeterRegistry();
        this.mockConnections = this.metricRegistry.counter("mock.server.connections", new String[0]);
        this.log = LoggerFactory.getLogger(MockCollectorServer.class);
        this.state = new AtomicReference<ServerState>(ServerState.IDLE);
        this.startupLatch = new CountDownLatch(1);
        ExecutorService executorService = Executors.newCachedThreadPool(MockCollectorServer::executor$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.executor = executorService;
        this.activeConnections = new ConcurrentHashMap();
    }

    public /* synthetic */ MockCollectorServer(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 1715;
        }
        if ((n3 & 2) != 0) {
            n2 = 50;
        }
        this(n, n2);
    }

    @NotNull
    public final SimpleMeterRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public final Counter getMockConnections() {
        return this.mockConnections;
    }

    public final int getPort() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            throw new IllegalStateException("Server is not running");
        }
        return serverSocket.getLocalPort();
    }

    @NotNull
    public final MockCollectorServer started(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        System.out.println((Object)("duration = " + duration));
        this.start();
        this.startupLatch.await(duration.toMillis(), TimeUnit.MILLISECONDS);
        System.out.println((Object)("awat duration = " + duration));
        return this;
    }

    public final void start() {
        if (!this.state.compareAndSet(ServerState.IDLE, ServerState.RUNNING)) {
            this.log.warn("Can't start since its current state is {}", this.state);
            return;
        }
        this.executor.submit(() -> MockCollectorServer.start$lambda$0(this));
    }

    private final void handleClientConnection(Socket socket) {
        String clientAddress = socket.getInetAddress().getHostAddress() + ':' + socket.getPort();
        this.log.info("New connection from {}", (Object)clientAddress);
        try {
            ClientConnectionHandler handler = new ClientConnectionHandler(socket, this);
            ((Map)this.activeConnections).put(clientAddress, handler);
            this.executor.submit(() -> MockCollectorServer.handleClientConnection$lambda$0(handler, this, clientAddress));
        }
        catch (Exception e) {
            this.log.error("Failed to create handler for connection from {}", (Object)clientAddress, (Object)e);
            socket.close();
        }
    }

    @Override
    public void close() {
        if (!this.state.compareAndSet(ServerState.RUNNING, ServerState.CLOSING)) {
            this.log.warn("Can't stop {} server", (Object)this.state.get());
            return;
        }
        this.log.info("Stopping Mock Collector Server...");
        Collection<ClientConnectionHandler> collection = this.activeConnections.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientConnectionHandler handler = (ClientConnectionHandler)element$iv;
            boolean bl = false;
            try {
                handler.close();
            }
            catch (Exception e) {
                this.log.error("Error closing connection handler", (Throwable)e);
            }
        }
        this.activeConnections.clear();
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket != null) {
            serverSocket.close();
        }
        this.serverSocket = null;
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.log.info("Mock Collector Server stopped");
    }

    private static final Thread executor$lambda$0(Runnable runnable) {
        return new Thread(runnable, "profiler-mock-collector-" + threadCounter.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$0(MockCollectorServer this$0) {
        try {
            this$0.serverSocket = new ServerSocket(this$0.bindPort, this$0.backlog);
            this$0.startupLatch.countDown();
            this$0.log.info("Mock Collector Server started on port {}", (Object)this$0.getPort());
            this$0.log.info("Waiting for connections from Dumper clients...");
            while (this$0.state.get() == ServerState.RUNNING) {
                try {
                    Closeable closeable = this$0.serverSocket;
                    if (closeable == null || (closeable = closeable.accept()) == null) break;
                    Closeable clientSocket = closeable;
                    this$0.mockConnections.increment();
                    this$0.handleClientConnection((Socket)clientSocket);
                }
                catch (Exception e) {
                    if (this$0.state.get() != ServerState.RUNNING) continue;
                    this$0.log.error("Error accepting client connection", (Throwable)e);
                }
            }
            this$0.log.info("Server completed, state={}", (Object)this$0.state.get());
        }
        catch (Exception e) {
            this$0.log.error("Failed to start server on port {}", (Object)this$0.getPort(), (Object)e);
            throw e;
        }
        finally {
            ServerSocket serverSocket = this$0.serverSocket;
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleClientConnection$lambda$0(ClientConnectionHandler $handler, MockCollectorServer this$0, String $clientAddress) {
        try {
            $handler.handle();
        }
        catch (Exception e) {
            this$0.log.error("Error handling connection from {}", (Object)$clientAddress, (Object)e);
        }
        finally {
            this$0.activeConnections.remove($clientAddress);
            this$0.log.info("Connection closed: {}", (Object)$clientAddress);
        }
    }

    public MockCollectorServer() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netcracker/profiler/collector/mock/MockCollectorServer$Companion;", "", "<init>", "()V", "threadCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "qubership-profiler-mock-collector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/netcracker/profiler/collector/mock/MockCollectorServer$ServerState;", "", "<init>", "(Ljava/lang/String;I)V", "IDLE", "RUNNING", "CLOSING", "qubership-profiler-mock-collector"})
    public static final class ServerState
    extends Enum<ServerState> {
        public static final /* enum */ ServerState IDLE = new ServerState();
        public static final /* enum */ ServerState RUNNING = new ServerState();
        public static final /* enum */ ServerState CLOSING = new ServerState();
        private static final /* synthetic */ ServerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ServerState[] values() {
            return (ServerState[])$VALUES.clone();
        }

        public static ServerState valueOf(String value) {
            return Enum.valueOf(ServerState.class, value);
        }

        @NotNull
        public static EnumEntries<ServerState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = serverStateArray = new ServerState[]{ServerState.IDLE, ServerState.RUNNING, ServerState.CLOSING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

