/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.collector.mock;

import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0011J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016J\u0006\u0010\u0017\u001a\u00020\fJ\b\u0010\u0018\u001a\u00020\fH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/netcracker/profiler/collector/mock/StreamManager;", "Ljava/io/Closeable;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "streams", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/netcracker/profiler/collector/mock/StreamManager$StreamInfo;", "registerStream", "", "handle", "name", "", "rollingSequenceId", "", "getStream", "recordData", "size", "getAllStreams", "", "printStatistics", "close", "StreamInfo", "qubership-profiler-mock-collector"})
@SourceDebugExtension(value={"SMAP\nStreamManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamManager.kt\ncom/netcracker/profiler/collector/mock/StreamManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1869#2,2:101\n*S KotlinDebug\n*F\n+ 1 StreamManager.kt\ncom/netcracker/profiler/collector/mock/StreamManager\n*L\n67#1:101,2\n*E\n"})
public final class StreamManager
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(StreamManager.class);
    @NotNull
    private final ConcurrentHashMap<UUID, StreamInfo> streams = new ConcurrentHashMap();

    public final void registerStream(@NotNull UUID handle, @NotNull String name, int rollingSequenceId) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StreamInfo streamInfo = new StreamInfo(handle, name, rollingSequenceId, System.currentTimeMillis(), 0L, null, null, 112, null);
        ((Map)this.streams).put(handle, streamInfo);
        Object[] objectArray = new Object[]{handle, name, rollingSequenceId};
        this.log.info("Stream registered: {} (name={}, rollingSeqId={})", objectArray);
    }

    @Nullable
    public final StreamInfo getStream(@NotNull UUID handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        return this.streams.get(handle);
    }

    public final void recordData(@NotNull UUID handle, int size) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        StreamInfo stream = this.streams.get(handle);
        if (stream != null) {
            stream.getBytesReceived().addAndGet(size);
            stream.getChunksReceived().incrementAndGet();
            stream.setLastActivityAt(System.currentTimeMillis());
        }
    }

    @NotNull
    public final Collection<StreamInfo> getAllStreams() {
        Collection<StreamInfo> collection = this.streams.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final void printStatistics() {
        if (this.streams.isEmpty()) {
            this.log.info("No active streams");
            return;
        }
        this.log.info("=== Stream Statistics ===");
        Collection<StreamInfo> collection = this.streams.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StreamInfo stream = (StreamInfo)element$iv;
            boolean bl = false;
            long duration = System.currentTimeMillis() - stream.getCreatedAt();
            long bytesReceived = stream.getBytesReceived().get();
            long chunksReceived = stream.getChunksReceived().get();
            this.log.info("  Stream: {} ({})", (Object)stream.getName(), (Object)stream.getHandle());
            this.log.info("    Rolling Sequence ID: {}", (Object)stream.getRollingSequenceId());
            this.log.info("    Bytes Received: {} ({} KB)", (Object)bytesReceived, (Object)(bytesReceived / (long)1024));
            this.log.info("    Chunks Received: {}", (Object)chunksReceived);
            this.log.info("    Duration: {} ms", (Object)duration);
            this.log.info("    Avg Chunk Size: {} bytes", (Object)(chunksReceived > 0L ? bytesReceived / chunksReceived : 0L));
        }
        this.log.info("=========================");
    }

    @Override
    public void close() {
        this.printStatistics();
        this.streams.clear();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003JO\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0007H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0017\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/netcracker/profiler/collector/mock/StreamManager$StreamInfo;", "", "handle", "Ljava/util/UUID;", "name", "", "rollingSequenceId", "", "createdAt", "", "lastActivityAt", "bytesReceived", "Ljava/util/concurrent/atomic/AtomicLong;", "chunksReceived", "<init>", "(Ljava/util/UUID;Ljava/lang/String;IJJLjava/util/concurrent/atomic/AtomicLong;Ljava/util/concurrent/atomic/AtomicLong;)V", "getHandle", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "getRollingSequenceId", "()I", "getCreatedAt", "()J", "getLastActivityAt", "setLastActivityAt", "(J)V", "getBytesReceived", "()Ljava/util/concurrent/atomic/AtomicLong;", "getChunksReceived", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "qubership-profiler-mock-collector"})
    public static final class StreamInfo {
        @NotNull
        private final UUID handle;
        @NotNull
        private final String name;
        private final int rollingSequenceId;
        private final long createdAt;
        private long lastActivityAt;
        @NotNull
        private final AtomicLong bytesReceived;
        @NotNull
        private final AtomicLong chunksReceived;

        public StreamInfo(@NotNull UUID handle, @NotNull String name, int rollingSequenceId, long createdAt, long lastActivityAt, @NotNull AtomicLong bytesReceived, @NotNull AtomicLong chunksReceived) {
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)bytesReceived, (String)"bytesReceived");
            Intrinsics.checkNotNullParameter((Object)chunksReceived, (String)"chunksReceived");
            this.handle = handle;
            this.name = name;
            this.rollingSequenceId = rollingSequenceId;
            this.createdAt = createdAt;
            this.lastActivityAt = lastActivityAt;
            this.bytesReceived = bytesReceived;
            this.chunksReceived = chunksReceived;
        }

        public /* synthetic */ StreamInfo(UUID uUID, String string, int n, long l, long l2, AtomicLong atomicLong, AtomicLong atomicLong2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                l2 = l;
            }
            if ((n2 & 0x20) != 0) {
                atomicLong = new AtomicLong(0L);
            }
            if ((n2 & 0x40) != 0) {
                atomicLong2 = new AtomicLong(0L);
            }
            this(uUID, string, n, l, l2, atomicLong, atomicLong2);
        }

        @NotNull
        public final UUID getHandle() {
            return this.handle;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getRollingSequenceId() {
            return this.rollingSequenceId;
        }

        public final long getCreatedAt() {
            return this.createdAt;
        }

        public final long getLastActivityAt() {
            return this.lastActivityAt;
        }

        public final void setLastActivityAt(long l) {
            this.lastActivityAt = l;
        }

        @NotNull
        public final AtomicLong getBytesReceived() {
            return this.bytesReceived;
        }

        @NotNull
        public final AtomicLong getChunksReceived() {
            return this.chunksReceived;
        }

        @NotNull
        public final UUID component1() {
            return this.handle;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        public final int component3() {
            return this.rollingSequenceId;
        }

        public final long component4() {
            return this.createdAt;
        }

        public final long component5() {
            return this.lastActivityAt;
        }

        @NotNull
        public final AtomicLong component6() {
            return this.bytesReceived;
        }

        @NotNull
        public final AtomicLong component7() {
            return this.chunksReceived;
        }

        @NotNull
        public final StreamInfo copy(@NotNull UUID handle, @NotNull String name, int rollingSequenceId, long createdAt, long lastActivityAt, @NotNull AtomicLong bytesReceived, @NotNull AtomicLong chunksReceived) {
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)bytesReceived, (String)"bytesReceived");
            Intrinsics.checkNotNullParameter((Object)chunksReceived, (String)"chunksReceived");
            return new StreamInfo(handle, name, rollingSequenceId, createdAt, lastActivityAt, bytesReceived, chunksReceived);
        }

        public static /* synthetic */ StreamInfo copy$default(StreamInfo streamInfo, UUID uUID, String string, int n, long l, long l2, AtomicLong atomicLong, AtomicLong atomicLong2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                uUID = streamInfo.handle;
            }
            if ((n2 & 2) != 0) {
                string = streamInfo.name;
            }
            if ((n2 & 4) != 0) {
                n = streamInfo.rollingSequenceId;
            }
            if ((n2 & 8) != 0) {
                l = streamInfo.createdAt;
            }
            if ((n2 & 0x10) != 0) {
                l2 = streamInfo.lastActivityAt;
            }
            if ((n2 & 0x20) != 0) {
                atomicLong = streamInfo.bytesReceived;
            }
            if ((n2 & 0x40) != 0) {
                atomicLong2 = streamInfo.chunksReceived;
            }
            return streamInfo.copy(uUID, string, n, l, l2, atomicLong, atomicLong2);
        }

        @NotNull
        public String toString() {
            return "StreamInfo(handle=" + this.handle + ", name=" + this.name + ", rollingSequenceId=" + this.rollingSequenceId + ", createdAt=" + this.createdAt + ", lastActivityAt=" + this.lastActivityAt + ", bytesReceived=" + this.bytesReceived + ", chunksReceived=" + this.chunksReceived + ')';
        }

        public int hashCode() {
            int result = this.handle.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.rollingSequenceId);
            result = result * 31 + Long.hashCode(this.createdAt);
            result = result * 31 + Long.hashCode(this.lastActivityAt);
            result = result * 31 + this.bytesReceived.hashCode();
            result = result * 31 + this.chunksReceived.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StreamInfo)) {
                return false;
            }
            StreamInfo streamInfo = (StreamInfo)other;
            if (!Intrinsics.areEqual((Object)this.handle, (Object)streamInfo.handle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)streamInfo.name)) {
                return false;
            }
            if (this.rollingSequenceId != streamInfo.rollingSequenceId) {
                return false;
            }
            if (this.createdAt != streamInfo.createdAt) {
                return false;
            }
            if (this.lastActivityAt != streamInfo.lastActivityAt) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bytesReceived, (Object)streamInfo.bytesReceived)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.chunksReceived, (Object)streamInfo.chunksReceived);
        }
    }
}

