/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.formatters.title.UrlPatternReplacer;
import org.qubership.profiler.io.CallReaderFactory;
import org.qubership.profiler.io.DurationFiltererImpl;
import org.qubership.profiler.io.ICallReader;
import org.qubership.profiler.io.TemporalRequestParams;
import org.qubership.profiler.io.xlsx.AggregateCallsToXLSXListener;
import org.qubership.profiler.io.xlsx.CallsToXLSXListener;
import org.qubership.profiler.io.xlsx.ICallsToXLSXListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ExcelExporter {
    private static final Logger log = LoggerFactory.getLogger(ExcelExporter.class);
    @Autowired
    ApplicationContext context;
    @Autowired
    CallReaderFactory callReaderFactory;

    public void export(TemporalRequestParams temporal, Map<String, String[]> params, OutputStream out) {
        this.export(temporal, params, out, "");
    }

    public void export(TemporalRequestParams temporal, Map<String, String[]> params, OutputStream out, String serverAddress) {
        ICallsToXLSXListener callListener;
        if (serverAddress == null) {
            serverAddress = "";
        }
        String type = this.getParameterValue("type", params);
        String[] nodesArr = params.get("nodes");
        HashSet<String> nodes = nodesArr == null || nodesArr.length == 0 ? null : new HashSet<String>(Arrays.asList(nodesArr));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(out, 32768);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        DurationFiltererImpl cf = new DurationFiltererImpl(temporal.durationFrom, temporal.durationTo);
        if ("aggregate".equals(type)) {
            String minDigitsInIdStr = this.getParameterValue("minDigitsInId", params);
            int minDigitsInId = minDigitsInIdStr == null ? 0 : Integer.parseInt(minDigitsInIdStr);
            String[] urlReplacePatternsArr = params.get("urlReplacePatterns");
            UrlPatternReplacer urlPatternReplacer = urlReplacePatternsArr == null ? new UrlPatternReplacer(Collections.EMPTY_LIST) : new UrlPatternReplacer(Arrays.asList(urlReplacePatternsArr));
            String disableDefaultUrlReplacePatternsStr = this.getParameterValue("disableDefaultUrlReplacePatterns", params);
            boolean disableDefaultUrlReplacePatterns = disableDefaultUrlReplacePatternsStr == null ? false : Boolean.parseBoolean(disableDefaultUrlReplacePatternsStr);
            HashMap<String, Constable> formatContext = new HashMap<String, Constable>(3);
            formatContext.put("minDigitsInId", Integer.valueOf(minDigitsInId));
            formatContext.put("urlPatternReplacer", (Constable)urlPatternReplacer);
            formatContext.put("disableDefaultUrlReplacePatterns", Boolean.valueOf(disableDefaultUrlReplacePatterns));
            callListener = (ICallsToXLSXListener)this.context.getBean(AggregateCallsToXLSXListener.class, new Object[]{cf, bufferedOutputStream, formatContext});
        } else {
            callListener = (ICallsToXLSXListener)this.context.getBean(CallsToXLSXListener.class, new Object[]{serverAddress, cf, bufferedOutputStream});
        }
        try {
            List<ICallReader> readers = this.collectCallReaders(params, callListener, temporal, nodes);
            long start = System.currentTimeMillis();
            for (ICallReader cr : readers) {
                cr.find();
                exceptions.addAll(cr.getExceptions());
            }
            log.info("reading: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        for (Throwable e : exceptions) {
            callListener.processError(e);
            log.error("Exception when dumping list of calls to Excel: ", e);
        }
        callListener.postProcess();
    }

    private List<ICallReader> collectCallReaders(Map<String, String[]> params, ICallsToXLSXListener callListener, TemporalRequestParams temporal, Set<String> nodes) throws IOException {
        return this.callReaderFactory.collectCallReaders(params, temporal, callListener, new DurationFiltererImpl(temporal.durationFrom, temporal.durationTo), nodes);
    }

    private String getParameterValue(String key, Map<String, String[]> params) {
        String[] val = params.get(key);
        if (val == null || val.length == 0) {
            return null;
        }
        return val[0];
    }
}

