/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.qubership.profiler.configuration.PropertyFacade;
import org.qubership.profiler.dom.GanttInfo;
import org.qubership.profiler.io.HotspotTag;

public class Hotspot {
    private static final int MAX_PARAMS = PropertyFacade.getProperty((String)(Hotspot.class.getName() + ".MAX_PARAMS"), (int)256);
    public int id;
    public ArrayList<Hotspot> children;
    public Map<HotspotTag, HotspotTag> tags;
    public PriorityQueue<HotspotTag> mostImportantTags;
    public int reactorCallId;
    public Set<Long> lastAssemblyId;
    public long lastParentAssemblyId;
    public byte isReactorEndPoint;
    public byte isReactorFrame;
    public int reactorDuration;
    public long reactorStartTime;
    public long reactorLeastTime;
    public int emit;
    public int blockingOperator;
    public int prevOperation;
    public int currentOperation;
    public String fullRowId;
    public int folderId;
    public long childTime;
    public long totalTime;
    public int childCount;
    public int count;
    public int suspensionTime;
    public int childSuspensionTime;
    public long startTime = Long.MAX_VALUE;
    public long endTime = Long.MIN_VALUE;

    public Hotspot(int id) {
        this.id = id;
    }

    public void tag(long time, int tagId, int valueId, Object value, long assemblyId) {
        if (this.tags == null) {
            this.tags = new HashMap<HotspotTag, HotspotTag>();
        }
        HotspotTag hs = new HotspotTag(tagId, value, assemblyId);
        this.tags.put(hs, hs);
    }

    public Hotspot getOrCreateChild(int tagId, long lastParentAssemblyId) {
        ArrayList<Hotspot> children = this.children;
        if (children == null) {
            this.children = new ArrayList();
            children = this.children;
        } else {
            for (Hotspot child : children) {
                if (child.id != tagId) continue;
                return child;
            }
        }
        Hotspot hs = new Hotspot(tagId);
        children.add(hs);
        return hs;
    }

    public Hotspot getOrCreateChild(int tagId) {
        ArrayList<Hotspot> children = this.children;
        if (children == null) {
            this.children = new ArrayList();
            children = this.children;
        } else {
            for (Hotspot child : children) {
                if (child.id != tagId) continue;
                return child;
            }
        }
        Hotspot hs = new Hotspot(tagId);
        children.add(hs);
        return hs;
    }

    public void merge(Hotspot hs) {
        Map<HotspotTag, HotspotTag> hsTags;
        long hsTime = hs.totalTime;
        this.totalTime += hsTime;
        this.suspensionTime += hs.suspensionTime;
        this.childTime += hs.childTime;
        this.count += hs.count;
        if (this.startTime > hs.startTime) {
            this.startTime = hs.startTime;
        }
        if (this.endTime < hs.endTime) {
            this.endTime = hs.endTime;
        }
        if ((hsTags = hs.tags) == null || hsTags.isEmpty()) {
            return;
        }
        Map<HotspotTag, HotspotTag> tags = this.tags;
        if (tags == null) {
            tags = this.tags = new HashMap<HotspotTag, HotspotTag>();
        }
        for (HotspotTag hsTag : hsTags.values()) {
            HotspotTag tag = tags.get(hsTag);
            if (tag == null) {
                HotspotTag newTag = hsTag.dup();
                newTag.totalTime = hsTime + (long)hs.reactorDuration;
                newTag.assemblyId = hsTag.assemblyId;
                this.addTag(tags, newTag);
                continue;
            }
            tag.totalTime += hsTime;
            tag.count += hsTag.count;
        }
    }

    public void addTag(Map<HotspotTag, HotspotTag> tags, HotspotTag newTag) {
        HotspotTag evicted;
        if (tags.size() < MAX_PARAMS) {
            tags.put(newTag, newTag);
            return;
        }
        if (this.mostImportantTags == null) {
            this.mostImportantTags = new PriorityQueue<HotspotTag>(MAX_PARAMS, HotspotTag.COMPARATOR);
            for (HotspotTag tag : tags.keySet()) {
                this.mostImportantTags.add(tag);
            }
        }
        HotspotTag first = this.mostImportantTags.peek();
        if (newTag.totalTime <= first.totalTime) {
            evicted = newTag;
        } else {
            evicted = first;
            HotspotTag smallestTag = this.mostImportantTags.poll();
            tags.remove(smallestTag);
            this.mostImportantTags.add(newTag);
            tags.put(newTag, newTag);
        }
        HotspotTag other = new HotspotTag(evicted.id);
        HotspotTag existingOther = tags.get(other);
        if (existingOther == null) {
            tags.put(other, other);
        } else {
            existingOther.totalTime += other.totalTime;
            existingOther.count += other.count;
        }
    }

    public void mergeWithChildren(Hotspot hs, List<GanttInfo> infos) {
        Map<HotspotTag, HotspotTag> hsTags;
        this.childTime += hs.childTime;
        this.totalTime += hs.totalTime;
        this.childCount += hs.childCount;
        this.count += hs.count;
        this.suspensionTime += hs.suspensionTime;
        this.childSuspensionTime += hs.childSuspensionTime;
        if (hs.lastAssemblyId != null) {
            if (this.lastAssemblyId == null) {
                this.lastAssemblyId = new HashSet<Long>();
            }
            this.lastAssemblyId.addAll(hs.lastAssemblyId);
        }
        if (this.reactorStartTime != 0L && hs.reactorStartTime != 0L) {
            this.reactorStartTime = Math.min(hs.reactorStartTime, this.reactorStartTime);
        } else if (hs.reactorStartTime != 0L) {
            this.reactorStartTime = hs.reactorStartTime;
        }
        if (hs.reactorStartTime != 0L) {
            this.reactorLeastTime = Math.max(this.reactorLeastTime, hs.reactorStartTime + (long)hs.reactorDuration);
            this.reactorDuration = (int)(this.reactorLeastTime - this.reactorStartTime);
        }
        if (this.startTime > hs.startTime) {
            this.startTime = hs.startTime;
        }
        if (this.endTime < hs.endTime) {
            this.endTime = hs.endTime;
        }
        if (hs.children != null) {
            if (this.children == null) {
                this.children = hs.children.isEmpty() ? null : hs.children;
            } else {
                int childrenSize = this.children.size();
                for (Hotspot srcChild : hs.children) {
                    if (hs.fullRowId != null && infos != null) {
                        infos.add(new GanttInfo(srcChild.id, srcChild.emit, srcChild.isReactorFrame == 0 ? srcChild.startTime : srcChild.reactorStartTime, srcChild.isReactorFrame == 0 ? srcChild.totalTime : (long)srcChild.reactorDuration, hs.fullRowId, hs.folderId));
                    }
                    for (int i = 0; i < childrenSize; ++i) {
                        Hotspot child = this.children.get(i);
                        if (child.id != srcChild.id || child.isReactorFrame != 0) continue;
                        child.mergeWithChildren(srcChild);
                        srcChild = null;
                        break;
                    }
                    if (srcChild == null) continue;
                    this.children.add(srcChild);
                }
            }
        }
        if ((hsTags = hs.tags) == null || hsTags.isEmpty()) {
            return;
        }
        Map<HotspotTag, HotspotTag> tags = this.tags;
        if (tags == null) {
            this.tags = hsTags;
            return;
        }
        for (HotspotTag hsTag : hsTags.values()) {
            HotspotTag tag = tags.get(hsTag);
            if (tag == null) {
                this.addTag(tags, hsTag);
                continue;
            }
            tag.totalTime += hsTag.totalTime;
            tag.count += hsTag.count;
        }
    }

    public void mergeWithChildren(Hotspot hs) {
        this.mergeWithChildren(hs, null);
    }

    public void calculateTotalExecutions() {
        this.calculateTotalExecutions(new Hotspot(0));
    }

    protected void calculateTotalExecutions(Hotspot prev) {
        if (this.children != null) {
            for (Hotspot child : this.children) {
                child.calculateTotalExecutions(this);
            }
        }
        prev.childTime += this.totalTime;
        prev.childCount += this.count + this.childCount;
        prev.childSuspensionTime += this.suspensionTime + this.childSuspensionTime;
        this.childTime -= (long)this.childSuspensionTime;
        this.totalTime -= (long)(this.childSuspensionTime + this.suspensionTime);
    }

    @Deprecated
    public Map<Integer, Hotspot> flatProfile() {
        this.calculateTotalExecutions();
        return Collections.emptyMap();
    }

    public void remap(Map<Integer, Integer> id2id) {
        Map<HotspotTag, HotspotTag> tags;
        if (id2id.isEmpty()) {
            return;
        }
        Integer newId = id2id.get(this.id);
        if (newId != null) {
            this.id = newId;
        }
        if (this.children != null) {
            for (Hotspot child : this.children) {
                child.remap(id2id);
            }
        }
        if ((tags = this.tags) == null || tags.isEmpty()) {
            return;
        }
        HashMap<HotspotTag, HotspotTag> newTags = new HashMap<HotspotTag, HotspotTag>((int)((float)tags.size() / 0.75f), 0.75f);
        for (HotspotTag tag : tags.values()) {
            newId = id2id.get(tag.id);
            if (newId != null) {
                tag.id = newId;
            }
            this.addTag(newTags, tag);
        }
        this.tags = newTags;
    }
}

