/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.qubership.profiler.io.ArraySuspendLogCollection;
import org.qubership.profiler.io.ISuspendLogCollection;
import org.qubership.profiler.io.SuspendLogPair;
import org.qubership.profiler.sax.factory.SuspendLogFactory;
import org.springframework.context.ApplicationContext;

public class SuspendLog {
    public static final SuspendLog EMPTY = new SuspendLog(new long[0], new int[0]);
    public SuspendLogCursor cursor;
    protected ISuspendLogCollection suspendLogCollection;
    protected ApplicationContext applicationContext;
    protected String podName;
    protected long loadedTo;
    protected long loadedFrom;
    protected List<SuspendLogPair<Long, Integer>> datesWithDelays;

    public SuspendLog(long[] dates, int[] delays) {
        this(dates, delays, null);
    }

    public SuspendLog(long[] dates, int[] delays, int[] trueDelays) {
        this.suspendLogCollection = new ArraySuspendLogCollection(dates, delays, trueDelays);
        this.cursor = this.cursor();
    }

    public SuspendLog(long[] dates, int[] delays, int[] trueDelays, int size) {
        this.suspendLogCollection = new ArraySuspendLogCollection(dates, delays, trueDelays, size);
        this.cursor = this.cursor();
    }

    public SuspendLog(ApplicationContext applicationContext, String podName) {
        this.applicationContext = applicationContext;
        this.podName = podName;
        this.cursor = this.cursor();
    }

    public int getSuspendDuration(long begin, long end) {
        this.cursor.skipTo(begin);
        return this.cursor.moveTo(end);
    }

    public SuspendLogCursor cursor() {
        return new SuspendLogCursor();
    }

    public void setValue(long[] dates, int[] delays, int[] trueDelays) {
        this.suspendLogCollection = new ArraySuspendLogCollection(dates, delays, trueDelays);
    }

    private float getK(int index) {
        return this.suspendLogCollection.getTrueDelay(index) == -1 || index >= this.suspendLogCollection.size() ? 1.0f : (float)this.suspendLogCollection.getTrueDelay(index) / (float)this.suspendLogCollection.getDelay(index);
    }

    public int size() {
        return this.suspendLogCollection.size();
    }

    public static void main(String[] args) throws IOException {
        SuspendLog suspendLog = new SuspendLogFactory(null).readSuspendLog("testpodname");
        BufferedWriter wr = new BufferedWriter(new FileWriter(args[1]));
        ISuspendLogCollection suspendLogCollection = suspendLog.suspendLogCollection;
        long first = 0L;
        long prev = 0L;
        if (suspendLogCollection.size() > 0) {
            prev = first = suspendLogCollection.getDate(0) - (long)suspendLogCollection.getDelay(0);
        }
        wr.append("START\tEND\tSTART_OFFSET\tSTART_DELTA\tDELAY\n");
        for (int i = 0; i < suspendLogCollection.size(); ++i) {
            long start = suspendLogCollection.getDate(i) - (long)suspendLogCollection.getDelay(i);
            wr.append(Long.toString(start)).append('\t');
            wr.append(Long.toString(suspendLogCollection.getDate(i))).append('\t');
            wr.append(Long.toString(start - first)).append('\t');
            wr.append(Long.toString(start - prev)).append('\t');
            prev = start;
            wr.append(Long.toString(suspendLogCollection.getDelay(i))).append('\n');
        }
        ((Writer)wr).close();
    }

    public class SuspendLogCursor {
        public int idx;
        protected long now;
        protected long a;
        protected int endTimeForSearch = 30000;

        public void skipTo(long begin) {
            int idx = SuspendLog.this.suspendLogCollection.binarySearch(begin);
            if (idx < 0) {
                idx = -idx - 1;
            }
            this.idx = idx;
            this.now = begin;
            if (idx == SuspendLog.this.suspendLogCollection.size()) {
                return;
            }
            long z = SuspendLog.this.suspendLogCollection.getDate(idx);
            this.a = z - (long)SuspendLog.this.suspendLogCollection.getDelay(idx);
        }

        public int moveTo(long end) {
            if (this.idx == SuspendLog.this.suspendLogCollection.size()) {
                return 0;
            }
            long a = this.a;
            if (a >= end) {
                return 0;
            }
            long z = SuspendLog.this.suspendLogCollection.getDate(this.idx);
            float suspend = (int)Math.min((long)SuspendLog.this.suspendLogCollection.getDelay(this.idx), z - this.now);
            if (z >= end) {
                this.now = end;
                return (int)((suspend -= (float)(z - end)) * SuspendLog.this.getK(this.idx));
            }
            suspend *= SuspendLog.this.getK(this.idx);
            ++this.idx;
            while (this.idx < SuspendLog.this.suspendLogCollection.size()) {
                z = SuspendLog.this.suspendLogCollection.getDate(this.idx);
                int delay = SuspendLog.this.suspendLogCollection.getDelay(this.idx);
                float k = SuspendLog.this.getK(this.idx);
                if (z < end) {
                    suspend += (float)delay * k;
                } else {
                    a = z - (long)delay;
                    if (a >= end) break;
                    suspend += (float)(end - a) * k;
                    break;
                }
                ++this.idx;
            }
            this.now = end;
            this.a = a;
            return (int)suspend;
        }
    }
}

