/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.qubership.profiler.io.FileNameUtils;

public class WildcardFileFilter
implements FileFilter {
    private static final String CURRENT_DIR = WildcardFileFilter.removeLastChar(new File(".").getAbsolutePath());
    private final List<String> wildcards;

    public WildcardFileFilter(List<String> wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new ArrayList<String>(wildcards.size());
        for (String wildcard : wildcards) {
            if (wildcard.startsWith("/") || wildcard.startsWith(CURRENT_DIR)) {
                this.wildcards.add(wildcard);
                continue;
            }
            this.wildcards.add(CURRENT_DIR + wildcard);
        }
    }

    @Override
    public boolean accept(File path) {
        if (path == null) {
            return false;
        }
        String pathName = path.getAbsolutePath();
        for (String wildcard : this.wildcards) {
            if (!FileNameUtils.wildcardMatch(pathName, wildcard)) continue;
            return true;
        }
        return false;
    }

    private static String removeLastChar(String str) {
        return str.substring(0, str.length() - 1);
    }
}

